// Widget for chosing a inptext...
#include "InputCtl.moc"
#include <kapp.h>
#include <kfiledialog.h>

InputCtl::InputCtl(char const * const prompt=0, char const * const initial=0, QWidget *parent=0, const char *name=0):QWidget(parent, name)
{
	int x=0;
	if(prompt!=0) {
		lbl1=new QLabel(prompt,this);
		lbl1->setGeometry(0,0,lbl1->sizeHint().width(),lbl1->height());
		x+=lbl1->width();
	} else
		lbl1=0;
	inptext=new QLineEdit(this);
	if(lbl1!=0)
		lbl1->setBuddy(inptext);
	if(initial!=0)
		inptext->setText(initial);
	inptext->setGeometry(x,0,width()-x,inptext->height());
	inptext->setMaxLength(1024);
}
void InputCtl::resize(int w, int h)
{
	QWidget::resize(w,h);
	if(lbl1!=0)
		inptext->resize(w-lbl1->width(),inptext->height());
	else
		inptext->resize(w,inptext->height());
}
void InputCtl::setGeometry(int x, int y, int w, int h)
{
	move(x,y);
	resize(w,h);
}
InputCtl::~InputCtl()
{
	if(lbl1!=0)
		delete lbl1;
	delete inptext;
}
void InputCtl::setText(char const * const txt)
{
	inptext->setText(txt);
}
char const * const InputCtl::text()
{
	return inptext->text();
}
