#include "AddDlFree.moc"
#include <qwidget.h>
#include <qlabel.h>
#include <klocale.h>
#include <kapp.h>

AddDlFree::AddDlFree(bool dir=false, QWidget * parent=0, char * wname=0): QWidget(parent, wname)
{
	int y;
	isDir=dir;
	if(isDir)
		this->setCaption(i18n("Add freely downloadable directory"));
	else
		this->setCaption(i18n("Add freely downloadable file"));
	resize(320,80);
	setFixedSize(320,80);
	if(isDir)
		filename=new InputFileCtl(i18n("&Filename:"),0,true,0,this);
	else
		filename=new InputFileCtl(i18n("&Filename:"),0,false,0,this);
	filename->setGeometry(5,5,width()-10,filename->height());
	y=5+filename->height()+5;
	ok=new QPushButton(i18n("&OK"),this);
	ok->setAutoDefault(true);
	ok->setDefault(true);
	ok->setGeometry(5,y,this->width()/2-10,ok->height());
	connect(ok,SIGNAL(clicked()),SLOT(okButtonPressed()));
	cancel=new QPushButton(i18n("&Cancel"),this);
	connect(cancel,SIGNAL(clicked()),SLOT(cancelButtonPressed()));
	cancel->setGeometry(this->width()/2+5,y,this->width()/2-10,cancel->height());
	show();
}
AddDlFree::~AddDlFree()
{
	delete filename;
	delete ok;
	delete cancel;
}
void AddDlFree::okButtonPressed()
{
	char *f=(char *)filename->text();
	if(f!=0)
		emit dlFreeAdded(isDir,f);
	delete this;
}
void AddDlFree::cancelButtonPressed()
{
	delete this;
}
