%{

#include "k2url.tab.h"
#include <string.h>
#include <stdlib.h>

char* k2urlPutSymbol( char *_name );
int yywrap();

%}

%%

"://" { return DSLASH; }

"@"|":"|"#" { k2urllval.name = 0L; return (int)(*yytext); }

"/"[^@#:]* { k2urllval.name = k2urlPutSymbol( yytext ); return PATH; }
"#".* { k2urllval.name = k2urlPutSymbol( yytext + 1 ); return REF; }
[^/@#:]+ { k2urllval.name = k2urlPutSymbol( yytext ); return STRING; }

%%

char* k2urlPutSymbol( char *_name )
{
  char *p = (char*)malloc( strlen( _name ) + 1 );
  strcpy( p, _name );
  return p;
}

void k2url_initFlex( char *_code )
{
  k2url_switch_to_buffer( k2url_scan_string( _code ) );
}

int k2urlwrap()
{
  k2url_delete_buffer( YY_CURRENT_BUFFER );
  return 1;
}
