#include "kcommander2.h"
#include "ktar.h"

void KCommander2App::insertParam(QString pa,KShellProcess *p)
{
	QString parameter;
	parameter.append(pa);
	// jetzt in temp nach den %-Params suchen

	if(parameter.find("^s") != -1)
	{
		int pos = parameter.find("^s");
		parameter.replace( pos, 2, listWithFocus->dirPath );
	}
	
	if(parameter.find("^d") != -1)
	{
		int pos = parameter.find("^d");
		if(listWithFocus == linkerListView)
			parameter.replace( pos, 2, rechterListView->dirPath );
		else
			parameter.replace( pos, 2, linkerListView->dirPath );
	}
	
	else if(parameter.find("^f") != -1)
	{
		int pos = parameter.find("^f");
		parameter.replace( pos, 2, *listWithFocus->lastItemClicked->text[0] );
	}
	else if(parameter.find("^F") != -1)
	{
		if(listWithFocus->itemsSelected() == 0) return;	// wenn keine files selectiert sind, ab zurck
		listItem *li = listWithFocus->Liste;
		while(li != 0)
		{
			if(li->selected)
			{
				parameter = listWithFocus->dirPath + *li->text[0];
				*p << parameter;
			}
			li = li->next;
		}		
		return;
	}

	*p << parameter;
};

void KCommander2App::itemClicked(const char *,const char *)
{
}

void KCommander2App::itemDoubleClicked(const char *s,const char *n)
{
	int i;
	QString t,path,device;
	bool left = true;

	// zuerst die Variablen setzen jenachdem welcher listview
//	listView * listview = (listView *)sender();
	if(strcmp("lv1",n) == 0)
	{
		path = leftDirPath;
		device = leftDirButton->text();
	}	
	else
	{
		path = rightDirPath;
		device = rightDirButton->text();
		left = false;
	}
//****************************************** wenn .. geklickt ****************************			
// testen ob Klick auf ".."
	if(strcmp(s,"..") == 0)
	// hier looft alles aufs UNMOUNTEN hinaus !!
	{
	// Doppelt auf PARENT geklickt
		device = device.left(device.length()-1);		// Schrgstrich hinter dem Path weg !
    if(device == "") return;												// wenn schon im / dann wech hier !!
		
		
		// jetzt schauen, ob path in der mtab als iso eingetragen ist
		QFile f("/etc/mtab");
		QString ss;
		if ( f.open(IO_ReadOnly) )
		{    // file opened successfully
			QTextStream t( &f );        // use a text stream
			while ( !t.eof() )
			{        // until end of file...
				ss = t.readLine();       // line of text excluding '\n'
				// ist im eintrag ISO9660 enthalten ?
				if(ss.find(device + " ",0,false) != -1)
				{
					if((ss.find("iso9660",0,false) != - 1) || (ss.find("/dev/fd0",0,false) != - 1))
					{					
						QString dev = ss.left( ss.find(' '));
						KProcess proc;											
						proc << "umount"  << dev;
						proc.start(KProcess::DontCare,KProcess::All);
					}
				}
			}
			f.close();
		}
		
		// was auf jedenfall passieren muss, wenn auf parent geklickt !
		// Linken Listview neu einlesen
	
		QString exDir;
		if(strcmp("lv1",n) == 0)
		{
			exDir = leftDirButton->text();
			upDir(leftDirPath);
			linkerListView->readDir(leftDirPath);
			leftDirButton->setText(leftDirPath);
			commandLineLabel->setText(leftDirPath);
			exDir = exDir.right(exDir.length() - leftDirPath.length());
			exDir = exDir.left(exDir.length()-1);
			// jetzt die Liste durchforsten nach dem eintrag exDir
			listItem *li = linkerListView->Liste;
			while(li != 0)
			{
				if(exDir == *li->text[0])
//					if(li->listviewIcon ==  linkerListView->foldericon)		// ist item ein dir ??
						linkerListView->setItemFocus(li);
				li = li->next;
			}
		}
		else
		{
			exDir = rightDirButton->text();
			upDir(rightDirPath);
			rechterListView->readDir(rightDirPath);
			rightDirButton->setText(rightDirPath);
			commandLineLabel->setText(rightDirPath);
			exDir = exDir.right(exDir.length() - rightDirPath.length());
			exDir = exDir.left(exDir.length()-1);
			// jetzt die Liste durchforsten nach dem eintrag exDir
			listItem *li = rechterListView->Liste;
			while(li != 0)
			{
				if(exDir == *li->text[0])
//					if(li->listviewIcon ==  linkerListView->foldericon)		// ist item ein dir ??
						rechterListView->setItemFocus(li);
				li = li->next;
			}
		}
		itemSelected();

	}
//****************************** wenn .. geklickt, fertig ****************************			

//****************************************************************************************
//****************************************************************************************
//***********************  File oder Dir geklickt   **************************************
//****************************************************************************************
	else
	{
	// hier auf File oder Dir geklickt !!
     	// wenn geklicktes item ein dir ist, dann dorthin wechseln
			path += s;
			path += "/";	// t = path + geklicktes item(path)
			QDir d = QDir(path);
			bool a = d.cd(path);
      	if(a)
	      {
					if(!d.isReadable())
					{
							QMessageBox::warning( this, i18n("System Message"),"Permission Denied" );
							return;
					}
					// hier auf links oder rechts splitten !
					if(left)
					{
						leftDirButton->setText(path);
						commandLineLabel->setText(path);
						leftDirPath = path;
					}
					else
					{
						rightDirButton->setText(path);
						commandLineLabel->setText(path);
						rightDirPath = path;
					}
					
					// ist der Path in den wir reinwollen im drivelist enthalten ?
					
					QString device = path,
													 searchDevice;
					device = device.left(device.length()-1);	// SLASH abtrennen
					
					if(device != "")
					{		
						for(i=0;i<leftDriveList->count();i++)
						{
							// device = der angeklickte pfad
							// searchdevice ist ein text der drivelistbox inclusive []
							searchDevice = leftDriveList->text(i);
							searchDevice = searchDevice.left(searchDevice.length()-1);
							searchDevice = searchDevice.right(searchDevice.length()-1);
							// jetzt ist searchdevice ohne []
							// ist ein drivelisteintrag = geklickter path ?
							if(searchDevice == device)
							{
								// nun die fstab auslesen und nach iso9660 ausschau halten	
								QFile f("/etc/fstab");
								QString ss;
								if ( f.open(IO_ReadOnly) )
								{    // file opened successfully
									QTextStream t( &f );        // use a text stream
									while ( !t.eof() )
									{        // until end of file...
										ss = t.readLine();       // line of text excluding '\n'
										ss = ss.simplifyWhiteSpace();
										// ist im eintrag ISO9660 enthalten ?
										if(ss.find(device,0,false) != -1)
										{
											if(ss.find("iso9660",0,false) != -1)
											{
												QString dev;
												dev = ss.left( ss.find(' '));
												eingehangen = false;
												setCursor(3);
												KShellProcess proc;
												proc << "mount" << "-t" << "iso9660";
												proc << dev << device;

												QApplication::connect(&proc, SIGNAL(processExited(KProcess *)),this, SLOT(slotExamine()));
												QApplication::connect(&proc, SIGNAL(receivedStdout(KProcess *, char *, int)), this, SLOT(receivedStdout(KProcess *, char *, int)));
												QApplication::connect(&proc, SIGNAL(receivedStderr(KProcess *, char *, int)), this, SLOT(receivedStderr(KProcess *, char *, int)));
												proc.start(KProcess::Block,KProcess::All);
												while(eingehangen == false)
													;
												setCursor(0);
										  }
											else if(ss.find("/dev/fd0",0,false) != -1)
											{
												QString dev;
												dev = ss.left( ss.find(' '));
												eingehangen = false;
												setCursor(3);
												KShellProcess proc;
												proc << "mount" << "-t" << "auto";
												proc << dev << device;

												QApplication::connect(&proc, SIGNAL(processExited(KProcess *)),this, SLOT(slotExamine()));
												QApplication::connect(&proc, SIGNAL(receivedStdout(KProcess *, char *, int)), this, SLOT(receivedStdout(KProcess *, char *, int)));
												QApplication::connect(&proc, SIGNAL(receivedStderr(KProcess *, char *, int)), this, SLOT(receivedStderr(KProcess *, char *, int)));
												proc.start(KProcess::Block,KProcess::All);
												while(eingehangen == false)
													;
												setCursor(0);
										  }
										  
										
										}  // if device gefunden
									}	// while(eof)
									f.close();
								
								} //wenn fstab geht !
							}	// wenn search = device
						}			// for drivelist
					}
	  	 		if(left)
	  	 		{
	  	 			linkerListView->readDir(path);
	  	 		}
	  	 		else
	  	 		{
	  	 			rechterListView->readDir(path);
	  	 		}
				itemSelected();
	  	 		
	      }	// WENN DIR !
 				else
				{
//******************************************************************************************
//			File doppelt geclickt
//******************************************************************************************

						path = path.left(path.length()-1);
						// file ausfhren
						QString mime = optionen::getMimeType(path);
						mimeExec(path);
				}

	  }    	//ELSE
	
}

//******************************************************************************************
void KCommander2App::mimeExec(const char *t)
{
	// wenn es ausfhrbar ist, dann starten
	QFileInfo fi(t);		
	int p = optionen::getFilePermission(t);
	// hat das File irgendein ExeFlag ??
	if((p & 0100) || (p & 0010) || (p & 0001))
	{	// ja, dann ausfhren
		debug(t);
		debug("hat x flag");
		exec(t);		// keine Endung dranne, dann normal starten ber xterm
		return;
	}
	
	
	debug("nicht ausfhrbar !");
	QString mime = optionen::getMimeType(t);		// Endung rausfiltern
	debug("mime " + mime);
	if(mime == "")
	{
		//ohne endung auch keine verknuepfung !
		debug("keine Endung !");
		return;
	}
	QString proggy = optionen::getMimeProg(mime);
	if(proggy == "")
	{
		exec(t);
		return;
	}
	else
	{
		KProcess proc;
		proc << "xterm" << "-e" << proggy << t;
		proc.start(KProcess::DontCare,KProcess::All);
	}
}

//******************************************************************************************
void KCommander2App::LVkeyPressed(const char *s)
{
	if(strcmp(s,"^R") == 0)
	{
		menuActivated(ID_MENU_QUELLE);
	}
	//***************************************************************************************
	if(strcmp(s,"ENTF") == 0)
	{
		LVkeyPressed("F8");
		return;
	}
	//***************************************************************************************
	if(strcmp(s,"+") == 0)
	{
		menuActivated(ID_MENU_MARKGROUP);
		itemSelected();
		return;
	}
	//***************************************************************************************
	if(strcmp(s,"-") == 0)
	{
		menuActivated(ID_MENU_REMARKGROUP);
		itemSelected();
		return;
	}
	//***************************************************************************************
	if(strcmp(s,"F3") == 0)
	{
		listView *sourceLV = linkerListView;
		listView *destLV 	 = rechterListView;
		const char 	*sp = leftDirPath,
					  		*dp = rightDirPath;
		
		// Quellfenster ist immer das mit dem Focus
		if(rechterListView->listHasFocus)
			{
				sourceLV = rechterListView;	// raussuchen und in sourceLV speichern
				destLV	= linkerListView;
				dp = leftDirPath,
				sp = rightDirPath;
			}
			showWidget *d = new showWidget(sourceLV,sp);
			
			d->show();

			return;
	}
	//***************************************************************************************
	if(strcmp(s,"F4") == 0)
	{
   	int size;
		KProcess proc;
				
		listView *sourceLV = linkerListView;
		listView *destLV 	 = rechterListView;
		const char 	*sp = leftDirPath,
					  	*dp = rightDirPath;
		
		// Quellfenster ist immer das mit dem Focus
		if(rechterListView->listHasFocus)
		{
			sourceLV = rechterListView;	// raussuchen und in sourceLV speichern
			destLV	= linkerListView;
			dp = leftDirPath,
			sp = rightDirPath;
		}

      QString sou;
      	
    	struct listItem *s = sourceLV->Liste;  // also hier erstemal Zeiger auf Sourceliste holen
	   while(s != 0)
	   {
    		if (s->hasFocus) break;
        	else s = s->next;
      }
 			
 		sou = sp + *s->text[0];	
		s = 0;
      QFileInfo gr(sou);
		size = gr.size();
		if(!gr.isDir())
		{
			proc << "kedit" << sou;
			QApplication::connect(&proc, SIGNAL(processExited(KProcess *)), this, SLOT(slotExamine()));
			proc.start(KProcess::DontCare,KProcess::All);
      }
		return;	
	}
//***************************************************************************************
	if(strcmp(s,"SF4") == 0)
	{
		QString name;
		listView *sourceLV = linkerListView;
		listView *destLV 	 = rechterListView;
		const char *sp = leftDirPath,
			         *dp = rightDirPath;
		
		// Quellfenster ist immer das mit dem Focus
		if(rechterListView->listHasFocus)
			{
				sourceLV = rechterListView;	// raussuchen und in sourceLV speichern
				destLV	= linkerListView;
				dp = leftDirPath,
				sp = rightDirPath;
			}
    		InputBox ip(this,i18n("Name Of The New File"));
    		int code =  ip.exec();
		
    	if(code != 0)
    	{
			KProcess proc;
			name = sp;
			proc << "kedit"<< name+ip.me->text();
			QApplication::connect(&proc, SIGNAL(processExited(KProcess *)), this, SLOT(slotExamine()));
			proc.start(KProcess::DontCare,KProcess::All);
		}
		return;
	}
	//***************************************************************************************
	// Beispiel fr Dialog ....
	if(strcmp(s,"F5") == 0)
	{
		listView *sourceLV = linkerListView;
		listView *destLV 	 = rechterListView;
		const char 	*sp = leftDirPath,
						  	*dp = rightDirPath;
		
		// Quellfenster ist immer das mit dem Focus
		if(rechterListView->listHasFocus)
			{
				sourceLV = rechterListView;	// raussuchen und in sourceLV speichern
				destLV	= linkerListView;
				dp = leftDirPath,
				sp = rightDirPath;
			}
			bool p = true;
			if(sourceLV->itemsSelected() == 0)
				if(sourceLV->lastItemClicked == sourceLV->Liste)
					p = false;
			// nur wenn p TRUE ist, dialog ausfhren
			if(p)
			{
				dlgCopy2 *d = new dlgCopy2(
													sourceLV,
													destLV,
													sp,
													dp,
													(QWidget *)this);
				d->setCaption(i18n("Copy Files"));
				d->exec();
				delete d;
			}
		return;
	}
//***************************************************************************************
	if(strcmp(s,"F6") == 0)
	{
		listView *sourceLV = linkerListView;
		listView *destLV 	 = rechterListView;
		const char *sp = leftDirPath,
					  *dp = rightDirPath;
		
		// Quellfenster ist immer das mit dem Focus
		if(rechterListView->listHasFocus)
			{
				sourceLV = rechterListView;	// raussuchen und in sourceLV speichern
				destLV	= linkerListView;
				dp = leftDirPath,
				sp = rightDirPath;
			}
		
		// nun abfragen, ob files selectiert wurden
			dlgMove *d = new dlgMove(sourceLV,
												destLV,
												sp,
												dp,
												(QWidget *)this);
			d->setCaption(i18n("Move Files"));
			d->show();
			delete d;
			return;
}
//***************************************************************************************
	if(strcmp(s,"F7") == 0)
	{
		QString newDir;
		
			QString n;
			if(!rechterListView->listHasFocus)
			{
	    		InputBox ip(this,i18n("Name Of The New Directory ?"));
   	 		int code =  ip.exec();
    			newDir = ip.me->text();
				n = leftDirPath + newDir;
				QDir neue;
      	  	if (code) neue.mkdir(n);
					linkerListView->readDir(leftDirPath);
			}
			else
			{
	    		InputBox ip(this,i18n("Name Of The New Directory ?"));
   	 		int code =  ip.exec();
    			newDir = ip.me->text();
				n = rightDirPath + newDir;
	        	QDir neue;
   	     	if(code) neue.mkdir(n);
					rechterListView->readDir(rightDirPath);
			}
			itemSelected();
			return;
	}
//***************************************************************************************
	if(strcmp(s,"F8") == 0)
	{
		listView *sourceLV = linkerListView;
		listView *destLV 	 = rechterListView;
		const char *sp = leftDirPath,
					  *dp = rightDirPath;
		
		// Quellfenster ist immer das mit dem Focus
		if(rechterListView->listHasFocus)
			{
				sourceLV = rechterListView;	// raussuchen und in sourceLV speichern
				destLV	= linkerListView;
				dp = leftDirPath,
				sp = rightDirPath;
			}

		dlgDel *d = new dlgDel(sourceLV,
											destLV,
											sp,
											dp,
											(QWidget *)this);
		d->setCaption(i18n("Delete Files"));
		d->show();
		delete d;
		itemSelected();
		return;
	}
//***************************************************************************************
//	wenn SPACE auf einem Directory gedrckt wurde, die Size recursive auslesen
//***************************************************************************************
	if(strcmp(s," ") == 0)
	{
		listView *lv = linkerListView ;					// lv jetzt temporr
		listItem *li;                 // li auch
		QString s = leftDirPath;			// s zeiger auf path von listview
		if(rechterListView->listHasFocus)					// wenn der 2te listview den focus hat,
		{
			lv = rechterListView;										// variablen verbiegen
			s = rightDirPath;
		}
		li = lv->getItemFocus();									// item mit focus holen
		if(li->listviewIcon ==  lv->foldericon)		// ist item ein dir ??
		{
			unsigned int sz;												// ja! Size auslesen
			sz = getDirSize( (const char *)s + *li->text[0] + "/");
			QString t;
			t.sprintf("%u",sz);
			*li->text[1] = t;
		}
		lv->refreshListview();
		return;
	}		
//***************************************************************************************
	if(strcmp(s,"F9") == 0)
	{
			menuActivated(ID_MENU_HELPABOUT);
			return;
	}
	setCaption("Tastencode: " + (QString )s);
}

void KCommander2App::menuActivated(int itemId)
{
  listItem *li = listWithFocus->Liste;
  QString dest;
  if(listWithFocus == rechterListView)
  	dest = leftDirPath;
  else
  	dest = rightDirPath;
  QDir d;
  int code;
		
	switch (itemId)
	{
		case 2:
					break;
		case ID_MENU_SPLITFILE:
					{
						debug("Splitten");
						dlgSplit *ds = new dlgSplit(this);
						ds->exec();
						delete ds;
						return;
						break;
					}
		case ID_MENU_SEARCHFILE:
					{
						dlgFind *df = new dlgFind(this);
						df->exec();
						delete df;
						return;
						break;
					}
		case ID_MENU_ATTRIBUTES:
					{
						listView *lv = listWithFocus;
						bool p = true;
						if(lv->itemsSelected() == 0)
							if(lv->lastItemClicked == lv->Liste)
								p = false;
						
						if(p == true)
						{
							dlgPermissions *dp = new dlgPermissions(listWithFocus);
							int result = dp->exec();
							delete dp;
							result = 0;
						}
						return;
						break;
					}
		case ID_MENU_PACK:	// Packen !
					{
						
						QString s;
						bool internal = true;					
						
						int flag = optionen::askPack();
						if(flag == optionen::Ask)
						{
					      int frage = QMessageBox::warning( this, i18n("System"),
   																		i18n("Using Of Wich Packemode ?"),
            			                                   	i18n("&Intern"),
                  			                             	i18n("&Extern"),
                        			                       	i18n("&Cancel"),
                                                			0, 
                                                			2 );
          		if(frage == 2)
          			return;		// gar nicht packen !
          		if(frage == 1)
          			internal = false;
						}
						else
							if(flag == optionen::External)
								internal = false;
						
						
						
						
						//zuerst den Archivenamen abfragen
nochmal:
            QString aname = commandLineLabel->text();	// Pathnamen als Basis fr
            																					// Archivnamen whlen
            aname = aname.left(aname.length()-1);			// SLASH am Ende weg
						while(aname.find("/",0,false) != -1)			// vom Anfang alles bis incl. letztem Slash
						{																					// lschen
							int l = aname.find("/",0,false);
							aname = aname.right(aname.length()-l-1);
						}

						if(aname == "")                           // ist aname leer, auf "archive" setzen
							aname = "archieve";						
						// KTar muss jetzt noch bergeben werden, nach welchem Prinzip gepackt wird !
						aname = dest + aname ;                    // vor dem archive noch den path setzen
												
    				InputBox ip(this,i18n("Archievename ?"),aname);
		    		if( ip.exec() == 0) break;					// Abbruch !!
            aname = ip.me->text();
            if(aname == "") break;							//kein Name, also raus hier

// existiert Ziel schon ?
						QFile ff(QString(aname) + ".tar");
						if(ff.exists())
            {
             		int i = QMessageBox::information ( this, i18n("Destination exist !"), i18n("Overwrite ?"), QMessageBox::Yes, QMessageBox::No);
								if(i == QMessageBox::No)
									goto nochmal;
						}

						// jetzt rekuriv das verzeichnis auslesen und in tempdatei schreiben
						
						listItem *tempList = listWithFocus->Liste->next;
						
						QTime t = QTime::currentTime();
						s = t.toString();
						s.remove(2,1);
						s.remove(4,1);
						s = "/tmp/" + s;	// /tmp/ ist fr alle zum schrieben
						QFile *f = new QFile(s);
						// nur schreiben !
						if(f->open(IO_WriteOnly))
						{
							QString thisDir(QString(commandLineLabel->text()));
							QString temp(QString(thisDir + "\n"));
							f->writeBlock(temp,strlen(temp));
							
							// jetzt alle zu packenden files inclusive path in die datei schreiben
							while(tempList != 0)
							{
									if(tempList->selected)
									{
										// wenns ein directory ist, dann writerecursiv aufrufen,
										// ansonsten filenamen schreiben
										QFileInfo fi(QString(thisDir + *tempList->text[0]));
										if(fi.isDir())
										{
											writeRecursiveList(f,thisDir + *tempList->text[0],strlen(thisDir));
										}
										else
										{
											QString a;
											a = *tempList->text[0];
											a += "\n";
											convert(&a);
											f->writeBlock(a,strlen(a));
										}
									}
									tempList = tempList->next;
							}
							
							f->close();
							if(!internal)
							{
								KProcess proc;
								proc << "ktar";
								proc << "kc";											//nur KCommander darf aufrufen !!
								proc << s;												// name des tempfiles
								proc << aname;										// Name des Archives
								proc << packMethode;							// erklrt sich von selbst
								proc.start(KProcess::DontCare,KProcess::All);
							}
							else
							{
									KTar *ktar = new KTar(s,aname,this);
									ktar->exec();
									delete ktar;
									if(listWithFocus == linkerListView)
										rechterListView->readDir(rightDirPath);
									else
										linkerListView->readDir(leftDirPath);
							}
						}
					}
					break;
		case ID_MENU_EXIT:
					saveOptions();
					close(this);
					break;
		case ID_MENU_MARKGROUP:															// Auswahl an files
	   		{
	   		InputBox *ip = new InputBox(this,i18n("Fileextension"));
    		code =  ip->exec();
				d.setNameFilter(ip->me->text());
				if(code != 0)
				{
					// zuerst ein DIR holen
					if(listWithFocus == linkerListView)
						d = leftDirPath;
					else
						d = rightDirPath;
						d.setFilter(QDir::Files | QDir::Dirs | QDir::Hidden);
					for ( int i=0; i<(signed)d.count(); i++ )
						{
								// alle items->text die d[i] gleichen, auf selected stellen
							  li = listWithFocus->Liste->next;
								while(li != 0)
								{
									if(strcmp(*li->text[0],d[i]) == 0)
										li->selected = true;
									li = li->next;
								}
						}
				listWithFocus->refreshListview();
				}
				break;		
				}
		case ID_MENU_REMARKGROUP:															// Auswahl an files
	   		{
	   		InputBox *ip = new InputBox(this,i18n("Fileextension"));
    		code =  ip->exec();
				d.setNameFilter(ip->me->text());
				if(code != 0)
				{
					// zuerst ein DIR holen
					if(listWithFocus == linkerListView)
						d = leftDirPath;
					else
						d = rightDirPath;
						d.setFilter(QDir::Files | QDir::Dirs | QDir::Hidden);
					for ( int i=0; i<(signed)d.count(); i++ )
						{
								// alle items->text die d[i] gleichen, auf selected stellen
							  li = listWithFocus->Liste->next;
								while(li != 0)
								{
									if(strcmp(*li->text[0],d[i]) == 0)
										li->selected = false;
									li = li->next;
								}
						}
				listWithFocus->refreshListview();
				}
				break;		
				}
		case ID_MENU_MARKALL:															// Alle Dateien auswhlen
					while(li != 0)
					{
						li->selected = true;
						li = li->next;
					}
					listWithFocus->refreshListview();
					itemSelected();
					break;
		case ID_MENU_MARKNONE:															// keine Dateien auswhlen
					while(li != 0)
					{
						li->selected = false;
						li = li->next;
					}
					listWithFocus->refreshListview();
					itemSelected();
					break;
		case ID_MENU_MARKREVERSE:															// Auswahl umkehren
					while(li != 0)
					{
						if(li->selected)
							li->selected = false;
						else
							li->selected = true;

						li = li->next;
					}
					listWithFocus->refreshListview();
					itemSelected();
					break;
		case ID_MENU_STARTTERM:				// Terminal starten
					{
						QDir::setCurrent(commandLineLabel->text());	
						KProcess proc;
						proc << "xterm";
						proc << "-e";
						proc << "csh";
						proc.start(KProcess::DontCare,KProcess::All);
						break;
					
					}
		case ID_MENU_SWAPLISTVIEWS:		// Fenster tauschen
					{
						linkerListView->readDir(rightDirPath);
						rechterListView->readDir(leftDirPath);
						QString s = leftDirPath;
						leftDirPath = rightDirPath;
						rightDirPath = s;
						leftDirButton->setText(leftDirPath);
						rightDirButton->setText(rightDirPath);
						itemSelected();
						break;
					}
		case ID_MENU_OPTIONS:
					{
						dlgOptions *d = new dlgOptions(	linkerListView,
																	rechterListView,
																	this);
						d->exec();
						delete d;
						saveOptions();
						readOptions();
						break;
					}
		case ID_MENU_HELPABOUT:
					{
						aboutwindow *d = new aboutwindow(this);
						d->exec();
						delete d;
						break;
					}
		case ID_MENU_SYSINFO:
					{
						dlgSysInfo *d = new dlgSysInfo(this);
						d->exec();
						delete d;
						break;
					}
		case ID_MENU_STARTER:
					{
						dlgStartmenu *d = new dlgStartmenu(this);
						d->exec();
						delete d;
						// Alle Mens von ID_STARTMENU bis ID_STARTMENU+99 lschen
						for(int i=ID_STARTMENU;i< ID_STARTMENU+100;i++)
							if(popup5->findItem(i))
								popup5->removeItem(i);
						// jetzt die vorhandenen neuen adden !
						KConfig *config = kapp->getConfig();
						config->setGroup("Startmenu");
						QString s;
						bool flag = true;
						int i=0;
						while(flag)
						{
							s.sprintf("Menutitle%d",i);
							QString titel = config->readEntry(s,"");
							if(titel == "") break;
							popup5->insertItem(titel,ID_STARTMENU+i);
							i++;
						}
						
						break;
					}
		case ID_MENU_QUELLE:
					{
						if(linkerListView->listHasFocus)
							linkerListView->readDir(leftDirPath);
						else
							rechterListView->readDir(rightDirPath);
						break;
					}

		    		
		default:
					
					if((itemId >= ID_STARTMENU) && (itemId < ID_STARTMENU+100))
					{
							
							KConfig *config = kapp->getConfig();
							config->setGroup("Startmenu");
							QString s;
							int i = itemId-ID_STARTMENU;
							
							s.sprintf("MenuApp%d",i);
							QString app(config->readEntry(s,""));
							
							s.sprintf("MenuParam%d",i);
							QString p(config->readEntry(s,""));
							
							KShellProcess proc("bash");
							proc << app;
							
							// Parameter nun noch zerpflcken
							p = p.simplifyWhiteSpace();
							
							while(p.find(" ") != -1)	// solange in schleife bleiben, wei ein space vorhanden
							{					
								int pos = p.find(" "); 					// Stelle mit Space finden
								QString temp(p.left(pos));				// temp wird JETZT bergeben
								p = p.right(p.length()-pos-1);  // der Rest weniger Space bleibt in Param
								insertParam(temp,&proc);
							}
							insertParam(p,&proc);
							proc.start(KProcess::DontCare,KProcess::All);
					}
					else
					{
						QString s;
						s.sprintf("Men [%d] unbekannt !!!",itemId);
						debug(s);
						break;
					}
	}
}

void KCommander2App::menuPressed()
{
}


void KCommander2App::driveActivated(const char *s)
{
	QString send = sender()->name();
	QString ss,temp;
	ss = s;
	ss = ss.right(ss.length()-1);
	ss = ss.left(ss.length()-1);
	temp = ss;

	QDir d(temp);
	if(!d.isReadable())
	{
		QMessageBox::critical( 0, "KCommander", QString(i18n("Permission denied !!")) );
		return;
	}
	// temp = /cdrom/teac32
	QFile f("/etc/fstab");
	if ( f.open(IO_ReadOnly) )
	{    // file opened successfully
		QTextStream t( &f );        // use a text stream
		while ( !t.eof() )
		{        // until end of file...
			ss = t.readLine();       // line of text excluding '\n'
			ss = ss.simplifyWhiteSpace();
			// ist im eintrag ISO9660 enthalten ?

			if(ss.find(temp + " ",0,false) != -1)
			{
				
				if(ss.find("iso9660",0,false) != -1)
				{
					QString dev;
					dev = ss.left( ss.find(' '));
					eingehangen = false;
					setCursor(3);
					KShellProcess proc;
					proc << "mount" << "-t" << "iso9660";
					proc << dev << temp;
					QApplication::connect(&proc, SIGNAL(processExited(KProcess *)),this, SLOT(slotExamine()));
					QApplication::connect(&proc, SIGNAL(receivedStdout(KProcess *, char *, int)), this, SLOT(receivedStdout(KProcess *, char *, int)));
					QApplication::connect(&proc, SIGNAL(receivedStderr(KProcess *, char *, int)), this, SLOT(receivedStderr(KProcess *, char *, int)));
					proc.start(KProcess::Block,KProcess::All);
					while(eingehangen == false)
							;	// Auf das Ende von MOUNT warten
					setCursor(0);
			  }
				else if(ss.find("/dev/fd0",0,false) != -1)
				{
					QString dev;
					dev = ss.left( ss.find(' '));
					eingehangen = false;
					setCursor(3);
					KShellProcess proc;
					proc << "mount" << "-t" << "auto";
					proc << dev << temp;
					QApplication::connect(&proc, SIGNAL(processExited(KProcess *)),this, SLOT(slotExamine()));
					QApplication::connect(&proc, SIGNAL(receivedStdout(KProcess *, char *, int)), this, SLOT(receivedStdout(KProcess *, char *, int)));
					QApplication::connect(&proc, SIGNAL(receivedStderr(KProcess *, char *, int)), this, SLOT(receivedStderr(KProcess *, char *, int)));
					proc.start(KProcess::Block,KProcess::All);
					while(eingehangen == false)
							;	// Auf das Ende von MOUNT warten
					setCursor(0);
			  }
			
			}  // if device gefunden
		}	// while(eof)
		f.close();
	}
	ss = temp + "/";
	if(ss == "//")
		ss = "/";
	if(send == "0")
	{
		leftDirPath = ss;
		leftDirButton->setText(ss);
		linkerListView->setFocus();
		linkerListView->readDir(ss);
	}
	else
	{
		rightDirPath = ss;
		rightDirButton->setText(ss);
		rechterListView->setFocus();
		rechterListView->readDir(ss);
	}
	itemSelected();
}

void KCommander2App::LVcolums()
{
	listView *lv = (listView *)sender();
	listView *destlv;

	if(lv == linkerListView)	// wenn Signal vom linken LV kam
		destlv = rechterListView;
	else
		destlv = linkerListView;
	for(int i=0;i<linkerListView->colums;i++)
		destlv->columWidth[i] = lv->columWidth[i];
	destlv->refreshColums(0);
}





void	KCommander2App::LVgotFocus()
{
	QString s = sender()->name();
	if(s == "lv2")
	{
		leftDirButton->setPalette(QPalette(*cg2,*cg2,*cg2));
		rightDirButton->setPalette(QPalette(*cg1,*cg1,*cg1));
		commandLineLabel->setText(rightDirPath);
		listWithFocus = rechterListView;
	}
	else
	{
		rightDirButton->setPalette(QPalette(*cg2,*cg2,*cg2));
		leftDirButton->setPalette(QPalette(*cg1,*cg1,*cg1));
		commandLineLabel->setText(leftDirPath);
		listWithFocus = linkerListView;
	}

}
void	KCommander2App::LVlostFocus()
{
}
void	KCommander2App::buttonLeistePressed()
{
	QString key;
	QPushButton *s = (QPushButton *)sender();
	key = s->text();
	key = key.left(2);
	LVkeyPressed(key);
}
void	KCommander2App::itemSelected()
{
	int a;
	QString ss;
	 	// aus beiden Listen das erste Item deselectieren (..)
	 	linkerListView->Liste->selected = false;
	 	rechterListView->Liste->selected = false;

	 	a = linkerListView->itemsSelected();
		ss.sprintf(i18n("%d / %d selected Files"),a,linkerListView->itemCount-1);
		leftSelLabel->setText(ss);
	    leftDirButton->setText(leftDirPath);
				
	 	a = rechterListView->itemsSelected();
		ss.sprintf(i18n("%d / %d selected Files"),a,rechterListView->itemCount-1);
		rightSelLabel->setText(ss);
    rightDirButton->setText(rightDirPath);
}
void	KCommander2App::itemDeSelected(const char *s,const char *n)
{
	itemSelected();
}

void KCommander2App::commandBoxActivated()
{
	KProcess proc;
	QString s,d;
	int z;

	QDir::setCurrent(commandLineLabel->text());	
	
	s = commandBox->currentText();
	commandBox->setEditText("");
	proc << "xterm" << "-e";
	z = s.find(" ");
	if (z != -1)
	{
	while(z != -1)
		{
			z = s.find(" ");
			d = s.left(z);
			s = s.right(s.length()-(z+1));
			proc << d;
		}
	 } else proc << s;
	QApplication::connect(&proc, SIGNAL(processExited(KProcess *)), this, SLOT(slotExamine()));
	proc.start(KProcess::DontCare,KProcess::All);

}

void	KCommander2App::slotExamine()
{
	eingehangen = true;
}

void	KCommander2App::receivedStdout (KProcess *proc, char *buffer, int buflen)
{
	QString s = buffer;
	debug("************* ANFANG STDOUT *************");
	debug(buffer);
	debug("*************  ENDE STDOUT  *************");
}

void	KCommander2App::receivedStderr (KProcess *proc, char *buffer, int buflen)
{
	QString s = buffer;
	s = s.left(buflen);
	if(s.find("no medium",0,false) != -1)
	{
		QMessageBox::critical( 0, "KCommander", QString(i18n("No Medium Found !!")) );
	}
/*
	else
		QMessageBox::critical( 0, "KCommander", s );
*/
}























