// Arno 29. Oktober Geburtstag !!!!!!!!!!

int timeout = 1000;

#include <qpainter.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qlabel.h>
#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qscrollbar.h>
#include <ctype.h>

#include "listview.h"
// standart icons
#include "DXlogo.xpm"
#include "folder2.xpm"
#include "file.xpm"
#include "filelink.xpm"
#include "folderLink.xpm"
#include "up.xpm"
#include "kapp.h"
#include "optionen.h"

// nun alle XPMs, welche den mimetyp darstellen




// Mauspfeile definieren
/*
1. B=1 and M=1 gives black.
2. B=0 and M=1 gives white.
3. B=0 and M=0 gives transparency.
4. B=1 and M=0 gives an undefined result.
*/

int stringCompare(const char *s1,const char *s2, bool ignoreCase = true);
void swapItems(struct listItem *,struct listItem *);

uchar c0_bm[] = {	
						0x40,0x02,	0x40,0x02,	0x40,0x02,	0x40,0x02,	0x40,0x02,
						0x40,0x02,	0x40,0x02,	0x40,0x02,	0x40,0x02,	0x40,0x02,
						0x40,0x02,	0x40,0x02,	0x40,0x02,	0x40,0x02,	0x40,0x02,
						0x40,0x02	};
						
uchar c0_mk[] = {
						0xc0,0x06,	0xc0,0x06,	0xc0,0x06,	0xc0,0x06,	0xc0,0x06,
						0xc0,0x06,	0xc0,0x06,	0xc0,0x06,	0xc0,0x06,	0xc0,0x06,
						0xc0,0x06,	0xc0,0x06,	0xc0,0x06,	0xc0,0x06,	0xc0,0x06,
						0xc0,0x06
						};


listView::listView(int x,int y,int b,int h,QWidget *parent=0, const char *name): QWidget(parent,name) {
	
	mouseOverItem = 0;
	mustUpdate = false;
	init();
	richtung = 0;
	shiftItem = 0;
	listHasFocus = false;
	setMinimumSize(200,200);
	setFocusPolicy(StrongFocus );		// Listview kann focus bekommen
	
	QString s,s1;
	setGeometry(x,y,b,h);
	p = new QPainter(this);	
	s = name;	s += "hSlider";	scroll1 = new QScrollBar ( 0,0,1,10,0,QScrollBar::Horizontal, this, s );
	s = name;	s += "vSlider";	scroll2 = new QScrollBar ( 0,0,1,10,0,QScrollBar::Vertical, this, s );

	connect(scroll1, SIGNAL(valueChanged(int)),SLOT(hScrollChanged(int)));
	connect(scroll2, SIGNAL(valueChanged(int)),SLOT(vScrollChanged(int)));
	mainWindow = parent;
	foldericon = new QPixmap((const char **)folder2);
	folderlinkicon = new QPixmap((const char **)folderLink);
	fileicon = new QPixmap((const char **)file);
	linkicon = new QPixmap((const char **)filelink);
	upicon   = new QPixmap((const char **)up);	
	
	
	
}

void listView::btClicked()
{
}

listView::~listView(){
	p->end();					// QPainter beenden
	delete foldericon;
	delete folderlinkicon;
	delete fileicon;
	delete linkicon;
	delete upicon;
	delete p;
}

void listView::init(){
	lastItemClicked = 0;
	selectItems = false;
	colums = 0;
	QString s;

	setMouseTracking(true);
	mausGedrueckt = false;
	sortButton = 0;
	sortOrder = true;
	itemCount = 0;

	c0_bitmap = new QBitmap( 16, 16, c0_bm, TRUE );
	c0_mask = new QBitmap  ( 16, 16, c0_mk, TRUE );
	cursor0 = new QCursor( *c0_bitmap, *c0_mask, 8, 0 );

	Liste = 0;
	
	// Farben, die spter konfigurierbar sind !!!
	
	updateReady = true;
	startTimer(timeout);

}

//*************************[ Anzahl der Spalten setzen ]************************************		
void listView::setColums(int Spalten){
// Spaltenanzahl setzen
	if(colums == 0)
	{
		// es existieren noch keine Spaltenkpfe
		colums = Spalten;
		for(int i=0;i<Spalten;i++)
		{
			columText[i] = "";
//			setColumWidth(i,100);
		}
	}
	else
	//vorhandene Spaltenkpfe lschen ! (Listen lschen !)
	{
	}

}


//*************************[ Text einer Spalte setzen ]************************************		
void listView::setColumText(int SpaltenNummer,QString text){
	if(colums == 0) return;					// wenn Spaltenanzahl = 0 dann zurck
	if(SpaltenNummer > colums) return;  // wenn gewhlte Spaltennummer zu gro, dann zurck !
	columText[SpaltenNummer] = text;
}


//*************************[ Alles neu Zeichnen ]************************************		
void listView::paintEvent ( QPaintEvent * ){
	QPointArray pts;
	
	
	p->setPen(black);
	p->drawLine(0,0,width(),0);		// 3D-Look des gesamten Fensters malen !
	p->drawLine(0,0,0,height());
	

	QPixmap dx((const char **)DXlogo);
	bitBlt(this,width()-16,height()-16,&dx);

	int ph = height()-16-HeaderHeight;
	int max = ph/20;
	maxVisibleItems = max;
	
	// damit beim runterscrollen das letzte item nicht bis nach oben scrollt,
	// muss der range des scrollers mit der anzahl der maximal sichtbaren items
	// subtrahiert werden
	if(itemCount > max)
		scroll2->setRange(0,itemCount-max);
	else
		scroll2->setRange(0,0);
	
	refreshColums(0);
	refreshListview();	
}


void listView::mouseMoveEvent (QMouseEvent *e)
{
	
	QString 	s;
	int 		x = e->x();
	int		y = e->y();
	
	if(!mausGedrueckt)
	// hier wird nur geschaut, ob Maus zwischen den ColumSpalten ist
	// und dann der Mauspfeil gesetzt
	{
	   int differenz = scroll1->value();
		if(y < HeaderHeight+4)
		{
			// Maus befindet sich innerhalb der Spaltenkpfe
			bool j=false;
			for(int i=0;i<colums;i++)
				// ist Maus ber Trennlinie ?
				if((columWidth[i] == x-2+differenz) ||
					(columWidth[i] == x-3+differenz) ||
					(columWidth[i] == x-1+differenz))
					{
						j=true;
						schiebeSpalte = i;
					}
				
				if(j)
					setCursor(*cursor0 );
				else
					{
					setCursor(0);
					schiebeSpalte = -1;
					}
		}
		else
		{	// Maus nicht auf Spaltenkopf, also Cursor wieder normal
			setCursor(0);
			schiebeSpalte = -1;
		}
	}
	else
	// wenn schiebeSpalte <> -1 ist, dann Spalten verschieben
	{
		int differenz = scroll1->value();
		// differenz = anzahl pixel links ausserhalb	
			
		// Differenz zur Maus: e->x()-columWidth[Spaltennummer]
		// da aber spalte verschoben ist, muss differenz wieder dazu
		
		int dif = x - columWidth[schiebeSpalte]+differenz;
      // also dif ist die breite, um die die spalte verschoben werden soll
		
		// nun die absolute breite der zu verschiebenden spalten holen
		int b2 = columWidth[schiebeSpalte];	
		
		
		if(schiebeSpalte != 0)
			b2 -= columWidth[schiebeSpalte-1];	// absolute breite der spalte

					
		// Spalte darf nicht kleiner als 20 Punkte werden !
		// b2 + dif = Breite nach Verschiebung
		if((b2 + dif)>20)
		{
			//	Spalte darf man nicht rausschieben knnen
			if((columWidth[schiebeSpalte]+ dif -differenz) < (width()-4))
			{
				for(int i=schiebeSpalte;i<colums;i++)
					columWidth[i] += dif;
				refreshColums(0);
			}
		
		}
	emit(columsChanged());
	mustUpdate = true;
	}

	// wenn rechtemouse gedrueckt, dann weiterselecten
	if(selectItems)
	{
		QString s;
		y -= HeaderHeight;
		int pixToScroll = maxVisibleItems*20;
		if(y > pixToScroll)
			richtung = +1;
		else if(y <= 0)
			richtung = -1;
		else
			{
				int ri = 1;
				// hier kommt er nur her, wen rechte maus gedrueckt, und maus innerhalb des LV
				// verschoben wurde
				struct listItem *fi = Liste;								// fi auf Anfang Liste setzen
				for(int i=0;i<scroll2->value();i++)
				{	
					if(fi == firstItemClicked) ri = -1;	// nachher wieder rckwrts
					fi = fi->next;								// fi auf erstes sichtbares Item setzen
				}

				y = (e->y() - HeaderHeight) / 20;		// mte jetzt der Zeilenummer entsprechen auf der die maus steht
				for(int i=0;i<y;i++)							// fi auf das item setzen, worber die maus jetzt ist
					if(fi->next != 0)
					{	
						if(fi == firstItemClicked) ri = -1;	// nachher wieder rckwrts
						fi = fi->next;
					}
					else
						return;									// wenn maus im leeren bereich, dann nischt machen
				
				
				// nun von fi an bis zu firstItemClicked auf selected setzen
//delta				setItemFocus(fi);
				mouseOverItem = fi;
				if(fi == firstItemClicked) return;
				while(ri != 0)
				{
					if(fi->selected != firstItemClicked->selected)
					{
						fi->selected = firstItemClicked->selected;
						drawItem(fi,y);
						if(fi->selected)
							emit(itemSelected(*fi->text[0],name()));
						else
							emit(itemDeSelected(*fi->text[0],name()));

					}
					
					if(ri == 1)
					{
						//vorwrts
						fi = fi->next;
						y ++;
					}
					else
					{
						//rckwrts
						fi = fi->prev;
						y--;
					// so, soweit so gut, jetzt nicht den ganzen listview malen, sondern
					// nur die markierten kaestchen
					}
					if((fi == 0) || (fi == firstItemClicked)) ri = 0; //aus schleife raus
				}
				richtung = 0;
			}
	}

}

//*************************[ Header neu zeichnen ]************************************		
void	listView::refreshColums(int s)
{
	QPointArray pts;
   QString ss;
   int differenz;
	int x2;
	if(s == 0)
		x2 = 1;
	else
		x2 = columWidth[s-1]+4;

	int m;
	if(colums != 0)
		m = columWidth[colums-1];
	else
		m = 0;

	// komplettes Quadrat grau zeichnen
	Rechteck(p,x2-1,0,width()+1-x2,HeaderHeight,0xc0c0c0,false,false);

	if(m < width())
	{
		scroll1->setRange(0,0);
		differenz = 0;
	}
	else
	{
		scroll1->setRange(0,m - width());
		differenz = scroll1->value();
	}
	
	if(colums != 0)
	for(int i=s;i<colums;i++)
	{
		int x;
		x= columWidth[i]-differenz; //rechter Rand des Buttons !
		// Zwischenlinien der Buttons zeichnen
		p->setPen(black);
		p->drawLine(2+x,0,2+x,HeaderHeight-2);
		p->setPen(white);
		p->drawLine(3+x,0,3+x,HeaderHeight-2);
		if(columText[i])
			{
				int x,b;
				if(i == 0)
				{
					x = 2;
					b = columWidth[i];
					}
				else
				{
					x = columWidth[i-1]+2;
					b = columWidth[i]-columWidth[i-1];
				}
				x -= differenz;
				// columtext schreiben
				p->setPen(white);
				p->drawText( x+12, 1, b-14, HeaderHeight-2, AlignCenter,columText[i]);
				p->setPen(black);
				p->drawText( x+13, 2, b-14, HeaderHeight-2, AlignCenter,columText[i]);
			
			}
		p->setPen(black);
		// rechten rand malen, weil er verstuemmelt wird
		p->drawLine(width()-1,1,width()-1,HeaderHeight-2);
		p->setPen(white);
		// linken rand malen, weil er verstuemmelt wird
		p->drawLine(0,1,0,HeaderHeight-2);
				
	}
	drawArrow();
	mustUpdate = true;
}


//*************************[ Pfeil (Sortierung) neu zeichnen ]************************************		
void	listView::drawArrow()
{
	if(colums == 0) return;
	int differenz = scroll1->value();	// max. zu verschieben

	int x;
	if(sortButton == 0) x=7;
	else x = columWidth[sortButton-1] + 9;
	
	x -= differenz;
	
	p->setPen(black);
	p->drawLine(x,5,x,HeaderHeight-2);
	if(!sortOrder)
		{
			p->drawLine(x-3,HeaderHeight-5,x,HeaderHeight-2);
			p->drawLine(x+3,HeaderHeight-5,x,HeaderHeight-2);
		}
	else
		{
			p->drawLine(x-3,8,x,5);
			p->drawLine(x+3,8,x,5);
		}
}

//*****************************************************************************************
void listView::mousePressEvent (QMouseEvent *e)
{	
	listHasFocus = true;
	emit(gotFocus());
	
	setFocus();
	if(colums == 0) return;
	QRect *lv = new QRect(0,HeaderHeight,width()-16,height()-16-HeaderHeight);
	mouseX = e->x();
	mouseY = e->y();
	
//*****************************************************************************************
	if(lv->contains(QPoint(mouseX,mouseY)))
	{
		QString s;
		struct listItem *li = Liste;
		int b = e->button();
		
		int Zeile = (mouseY - HeaderHeight) / 20 + scroll2->value();
		for(int i=0;i<Zeile;i++)
			{
			if(li->next != 0)
				li = li->next;
			else
				return;
			}
		
		// Click mit rechter Maus auf Item
		if(b == 2)
		{
			if(li->selected)
				{
					li->selected = false;
					setItemFocus(li);
					emit(itemDeSelected(*li->text[0],name()));
				}
			else
				{
					li->selected = true;	
					setItemFocus(li);
					emit(itemSelected(*li->text[0],name()));
				}
			refreshListview();
			selectItems = true;
			firstItemClicked = li;					// Zeiger auf das zuerst angeklickte Item (fr Timer notwendig)
		}
		else if(b == 1)    								// Klick mit linker maus auf item
		{
			struct listItem *l=Liste;  			// tempor. l erzeugen
				
				// von shiftitem bis mausitem alles selektieren
				
			if(shiftItem != 0)
			{
				bool f = false;
				bool raus = false;
				while(l != 0)
				{
					if((l == shiftItem) || (l == li))
						if(f == false)
							f = true;
						else	// letztes item gefunden !
							raus = true;
					if(f)
						l->selected = true;
					if(raus) break;
					l = l->next;
				}
				refreshListview();
				return;
			}
				
				setItemFocus(li);							// allen items den focus stehlen
				lastItemClicked = li;
				emit(itemClicked(*li->text[0],name()));
				refreshListview();
		}
		return;
	}
//*****************************************************************************************
	int differenz = scroll1->value();
	
	mausGedrueckt = true;
	
	// Druck auf Header ??
	if((schiebeSpalte == -1) & (e->y() <= HeaderHeight))
		{ int sb=0;
			for(int i=(colums-1);i>=0;i--)
				{
					if(e->x() <= columWidth[i]-differenz+2) sb = i;
				}
			
			// wenn Pfeil schon auf gleichem Button, dann Pfeil anders rum
			if(sb < colums)
			{	
				if(sb == sortButton)
					if(sortOrder)
						sortOrder = false;
					else
						sortOrder = true;
				sortButton = sb;
				refreshColums(0);
			}
				sortList();
				refreshListview();
		return;	// raushopsen
		}
}
//*****************************************************************************************
void listView::mouseReleaseEvent (QMouseEvent *e)
{
	richtung = 0;
	selectItems = false;
	if(colums == 0) return;
	mausGedrueckt = false;
	schiebeSpalte = -1;
	int b = e->button();
	if(b == 2)								// wenn rechter mousebutton losgelassen, dann
		if(mouseOverItem != 0)
			setItemFocus(mouseOverItem);
}

//*****************************************************************************************
void listView::resizeEvent ( QResizeEvent *e )
{
	scroll1->setGeometry(0,height()-16,width()-16,16);
	scroll2->setGeometry(width()-16,HeaderHeight,16,height()-16-HeaderHeight);
}
	


//*************************[ zeichnet ein Rechteck ]************************************		
//		Parameter:
//						p = QPainter vom Aufrufer
//						x = x-Position
//						y = y-Position
//						b = Breite
//						h = Hhe
//						farbe = Farbe des Containers
//						gedrueckt = soll Flche gedrckt sein ?
//						flat = wenn false dann 3D ansonsten FLACH zeichnen

void listView::Rechteck(QPainter *p,int x,int y,int b, int h,long farbe,bool gedrueckt,bool flat)
{
	if(!flat)
		p->setPen(black);	// wenn nicht flach, dann schwarzer rand
	else
		p->setPen(farbe);	//ansonsten rand in gleicher farbe wie container

	p->setBrush(farbe);
	QPointArray pts;
	// Container zeichnen
	pts.setPoints( 4,  x, y,  x+b-1,y,  x+b-1,y+h-1,  x,y+h-1 );
	p->drawPolygon( pts,TRUE );
	// je nach GEDRUECKT die Linien drumrum malen
	
	if(!flat)
	{
		p->setPen(white);
		if(!gedrueckt)
			{
				p->drawLine(x,y,x+b-1,y);
				p->drawLine(x,y,x,y+h-1);
			}
		else
			{
				p->drawLine(x,y+h-1,x+b-1,y+h-1);
				p->drawLine(x+b-1,y+h-1,x+b-1,y);
			}
   }

}

// ***********************************************************************************
// Funktionen zur Manipulation der Liste
// ***********************************************************************************

void listView::clear()
{
	if(colums == 0) return;
	
	struct listItem *li = Liste,*l;
	while(li->next != 0)
	{
		for(int i=0;i<colums;i++)
			delete li->text[i];
		l = li;
		li = li->next;
		delete l;
	}
	Liste = 0;
	itemCount = 0;
	scroll2->setRange(0,0);
//	refreshListview();
}
//*****************************************************************************************
struct listItem * listView::addItem()
{

	struct listItem *neu = new listItem;
		if(!neu)	return 0;				// Speicher voll ? dann FEHLER !
	struct listItem *suche = Liste;	// Zeiger auf Anfang Liste setzen
	
	neu->kennung = 1234567;	
	
	for(int i=0;i < colums;i++)
		neu->text[i] = new QString;	// AnzahlSpalten * QStrings allocieren

   neu->listviewIcon = 0;
   neu->selected = false;
   neu->hasFocus = false;
			
	neu->next = 0;
	// Vorgnger setzen
	if(Liste == 0)
		{
		neu->prev = 0;
		Liste = neu;
		}
	else
		{
			while(suche->next != 0)						// jetzt letztes Item suchen
				suche  = suche->next;
			neu->prev = suche;					// prev vom neuen Item auf SUCHE setzen
			suche->next = neu;					// next von SUCHE auf NEU setzen
		}
	itemCount ++;									// Anzahl Items 1 hher
	
	int ph = height()-16-HeaderHeight;
	int max = ph/20;
	if(itemCount > max)
		scroll2->setRange(0,itemCount-max);
	else
		scroll2->setRange(0,0);

	return neu;
}
//*****************************************************************************************
void	listView::delItem(struct listItem *item)
{
	if(item->kennung != 1234567)		return;
	struct listItem *vorgaenger=0;
	struct listItem *nachfolger=0;
	
	if(item->prev != 0)
		vorgaenger = item->prev;
	if(item->next != 0)
		nachfolger = item->next;
	
	if(vorgaenger != 0)							// wenn es vorgaenger gibt,
	{
		if(nachfolger)								// und auch einen nachfolger
			{
				vorgaenger->next = nachfolger;// dann PREV auf eventuellen nachfolger setzen
			}
		else
			vorgaenger->next = 0;
	}
	
	if(nachfolger != 0)							// wenn es nachfolger gibt,
	{
		if(vorgaenger)								// und auch einen vorgaenger
			{
				nachfolger->prev = vorgaenger;// dann PREV auf eventuellen nachfolger setzen
			}
		else
			nachfolger->prev = 0;
	}
	// in beiden Fllen
	itemCount -= 1;		// Liste eins krzer
	delete[] item;
	mustUpdate = true;
}
//*****************************************************************************************
void listView::refreshListview()
{
	
	if(colums == 0) return;
	if(!updateReady) return;
	if(Liste == 0) return;
	
	QString s;
	int differenz = scroll1->value();
	
	// WEGEN FLACKERN MUSS ICH DEN UMWEG UEBER DOUBLEBUFFERING NEHMEN	
	// Pixmap mit Breite und Hhe des Listviews erstellen	
	int	pb=width()-17;
	int	ph = height()-16-HeaderHeight;
	
	QPixmap pm(pb,ph);
	pm.fill(backgroundColor);
	QPainter *qp = new QPainter(&pm);	
//	qp->setPen(black);
	QPointArray pts;
	
	int max = 	maxVisibleItems = ph / 20;
	bool eol=false;

	int i=0;
	//max = maximale anzahl zeilen
	bool fertig = false;
	struct listItem *item=Liste;

	int differenzY = scroll2->value();
	// jetzt bis zum ersten sichtbaren item skippen
	while(differenzY-- != 0)
		item = item->next;	

		// das muesste stimmen !!
		firstVisibleItem = item;
		
		while(!fertig)		// solange items darstellen bis ein nicht sichtbares folgt
		{
			
			// zuerst hintergrund, wenn selected
			if(item->selected)
			{
				qp->setBrush(selBackgroundColor);
				qp->setPen(selBackgroundColor);
			}
			else	
			{				
				qp->setBrush(backgroundColor);
				qp->setPen(backgroundColor);
			}
					
// hier wird item gezeichnet, welches focus hat
//**************************************************************************
			if(item->hasFocus)
			{
					qp->setPen(cursorRand);
					// wenn cursor gefllt sein soll, dann
					if(cursorFilled)
						if(item->selected)
						{
							qp->setBrush(cursorColorSelected);
							qp->setPen(cursorTextColorSelected);
						}
						else
						{
             	qp->setBrush(cursorColor);
							qp->setPen(cursorTextColor);
						}
			
			}
					
			pts.setPoints(4, 0, i*20,
							     width()-18,i*20,			// Rechteck um Item malen
								  width()-18,i*20+19,
								  0,i*20+19);
			qp->drawPolygon(pts);	
//**************************************************************************
			
			// zuerst hintergrund, wenn selected
			if(item->selected)
			{
				qp->setBrush(selBackgroundColor);
				qp->setPen(selBackgroundColor);
			}
			else	
			{				
				qp->setBrush(backgroundColor);
				qp->setPen(backgroundColor);
			}
			
			if(item->selected)
				qp->setPen(selForgroundColor);
			else
				qp->setPen(forgroundColor);

			for(int j=0;j<colums;j++)
			{
				int x,b;
				if(j==0)
				{
					x = 20;
					b = columWidth[j]-20;
				}
				else
				{
					x = columWidth[j-1]+5;
					b = columWidth[j]-columWidth[j-1]-5;
				}
				x -= differenz;
				//
				qp->drawText(x,i*20 , b,20,AlignLeft,*item->text[j]);
				if(item->listviewIcon != 0)
						bitBlt( (QPaintDevice *)&pm, 0-differenz+2, i*20+2, item->listviewIcon );
			}
			
			max --; i ++;
			eol = false;	// end of list
			if(item->next == 0)	// wenn keins mehr folgt, dann hier raus
			{
				eol = true;
				fertig = true;
			}
			else
				item = item->next;
			if(max == 0)
				fertig = true;
		}
	if(!eol)
		item = item->prev;
/*	
	if(item->next != 0)
		lastVisibleItem = item->prev;
	else
		lastVisibleItem = item;
*/
	lastVisibleItem = item;
	bitBlt( (QPaintDevice *)this, 1, HeaderHeight, &pm );
	delete qp;	
	updateReady = true;
}
//*****************************************************************************************
void	listView::focusInEvent ( QFocusEvent * fe)
{
	listHasFocus = true;
	if(lastItemClicked == 0)
	{
		setItemFocus(Liste);		//erstes Item bekommt Focus !
	}
   else
	{
		listHasFocus = true;
		lastItemClicked->hasFocus = true;
	}
	refreshListview();
	emit(gotFocus());
}
//*****************************************************************************************
void	listView::focusOutEvent ( QFocusEvent * fe)
{
	listHasFocus = false;
	//lastItemClicked = getItemFocus();
	struct listItem *li = Liste;
	while(li != 0)
	{
		li->hasFocus = false;
		li = li->next;
	}
	refreshListview();
	emit(lostFocus());
}
//*****************************************************************************************
void listView::timerEvent(QTimerEvent *t)
{
	if(colums == 0) return;
	if(mustUpdate)	// flag wird bei Bedarf von anderen Funktionen auf TRUE gesetzt
		{
//		refreshColums(0);
		refreshListview();
		if(updateReady)
			mustUpdate = false;
		}
	if(selectItems)
	{
		// hier kommt er hin, wenn rechte Maus im Listviewbereich geklickt wurde,
		// und die Maus verschoben wird
		// li zeigt dann auf das erste sichtbare item im LV
		if(richtung != 0)
		{
			// diese routine wird nur aufgerufen, wenn die maus ausserhalb des listviews
			// bei gedrueckter rechten maus gezogen wird !!
			if(richtung == 1)
				{
				if(scroll2->value() == scroll2->maxValue())
					{
						selectItems = false;
						return;
					}
				}
			else if(richtung == -1)
				{
				if(scroll2->value() == 0)
					{
						selectItems = false;
						return;
					}
				}
			
			if(richtung >0)		// Scrollen nach unten
			{
				scroll2->setValue(scroll2->value() + richtung);		// den Scroller verschieben
				
				struct listItem *fi = Liste;								// fi auf Anfang Liste setzen
				for(int i=0;i<scroll2->value();i++)
					fi = fi->next;								// fi auf erstes sichtbares Item setzen
				
				struct listItem *li = fi;								// li auf fi setzen
				// und letztes sichtbares Item suchen
				int a = (height()-16-HeaderHeight) / 20-1;
				for(int i=0;i<a;i++)
						li = li->next;
				li->selected = firstItemClicked->selected;
				emit(itemSelected(*li->text[0],name()));
				refreshListview();
			}
			else if(richtung <0)	// Scrollen nach oben
			{
				scroll2->setValue(scroll2->value() + richtung);		// den Scroller verschieben
				struct listItem *fi = Liste;								// fi auf Anfang Liste setzen
				for(int i=0;i<scroll2->value();i++)
					fi = fi->next;								// fi auf erstes sichtbares Item setzen
				fi->selected = firstItemClicked->selected;
					emit(itemSelected(*fi->text[0],name()));
				refreshListview();
			}
		
		}
	}
}
//*****************************************************************************************
void listView::setItemText(struct listItem *item,int nr,const char *s)
{
	if(nr >= colums) return;
	item->text[nr] = new QString(s);
}
//*****************************************************************************************
void listView::readDir(const char *s)
{
  
  if(Liste != 0)  clear();
  dirPath = s;
  QString ss;
  struct listItem *item;
  setColums(4);
  setColumText(0,i18n("Filename"));
  setColumText(1,i18n("Filesize"));
  setColumText(2,i18n("Date"));
  setColumText(3,i18n("Filepermissions"));
		
	QFile f;

	char * sss = (char *)s;   
   QDir thisDir(sss);
l1:
   	if(!thisDir.exists())
		{
			  for(int i = strlen(sss)-2;i > -1;i--)
			  {
  					if(sss[i] == '/')
			 			{
			 				sss[i+1] = 0;
 							thisDir.setPath(sss);
		  				goto l1;
		  			}
  			}
 		}
   thisDir.setFilter(	QDir::Dirs |
   							QDir::Files |
   							QDir::Drives |
   							QDir::Modified |
   							QDir::Hidden |
   							QDir::System);
	if ( thisDir.isReadable() )
	{
		const QFileInfoList * files = thisDir.entryInfoList();
		if ( files ) {
		
			QFileInfoListIterator it( *files );
			QFileInfo * f;
         QDateTime dt;
						

			while( (f=it.current()) != 0 ) {
				++it;
				dt = f->lastModified();
				QString s = dt.date().toString();
				s = s.right(s.length()-4);				// Tag cutten
				QString Monat = s.left(3);
				s = s.right(s.length()-4);				// Tag cutten
            QString Jahr = s.right(4);
            s = s.left(s.length()-4);
            if(s.length() <3) s = "0" + s;
            s = s.left(2) + "-";
            if(strcmp(Monat,"Jan") == 0) Monat = "01-";
            else if(strcmp(Monat,"Feb") == 0) Monat = "02-";
            else if(strcmp(Monat,"Mar") == 0) Monat = "03-";
            else if(strcmp(Monat,"Apr") == 0) Monat = "04-";
            else if(strcmp(Monat,"May") == 0) Monat = "05-";
            else if(strcmp(Monat,"Jun") == 0) Monat = "06-";
            else if(strcmp(Monat,"Jul") == 0) Monat = "07-";
            else if(strcmp(Monat,"Aug") == 0) Monat = "08-";
            else if(strcmp(Monat,"Sep") == 0) Monat = "09-";
            else if(strcmp(Monat,"Oct") == 0) Monat = "10-";
            else if(strcmp(Monat,"Nov") == 0) Monat = "11-";
            else if(strcmp(Monat,"Dec") == 0) Monat = "12-";
				s = Monat + s + Jahr;								
				s = s + "  " + dt.time().toString();
				if ( f->fileName() == ".")
					; // nothing
				else if( f->fileName() == "..")
				{
				  	item = addItem();
				  	setItemText(item,0,f->fileName());
				  	setItemText(item,1,i18n("parent directory"));
				  	setItemText(item,2,s);
				  	item->listviewIcon = upicon;
				  	if(listHasFocus)
					  	item->hasFocus = true;
				 }
				else if ( f->isSymLink() )
				{
				  	item = addItem();												// item adden
				  	setItemText(item,0,f->fileName());			// filenamen eintragen
				  	setItemText(item,1,i18n("Symbolic Link"));		// "Symbol.." eintragen
				  	setItemText(item,2,s);									// datum eintragen
				  	QString symPath = f->readLink();				// ist es ein link auf ein directory ?
				  	if(QDir(dirPath + symPath).exists())
					  	item->listviewIcon = folderlinkicon;	// ja, dann anderes icon setzen als
					  else
					  	item->listviewIcon = linkicon;				// wenn nicht !
				}
				else if ( f->isDir() )
				{
				  	item = addItem();
				  	setItemText(item,0,f->fileName());
				  	setItemText(item,1,i18n("Directory"));
				  	setItemText(item,2,s);
				  	item->listviewIcon = foldericon;
				}
				else
				{
						// Hier ist es auf jeden Fall ein File
				  	QString size;
				  	item = addItem();
				  	setItemText(item,0,f->fileName());
				  	size.sprintf("%d",f->size());
				  	setItemText(item,1,size);
				  	setItemText(item,2,s);
						// icon raussuchen
					QString mime =  optionen::getMimeType(dirPath + f->fileName());
				  	item->listviewIcon = fileicon;
/*
				  	if(mime != "")
				  	{
				  		if(mime == "c")
						  	item->listviewIcon = pm_ext_c_file;
				  		if(mime == "h")
						  	item->listviewIcon = pm_ext_h_file;
				  	}
*/
				}
			}
		}
	sortList();
	lastItemClicked = Liste;
	}
	else
	{
		// Dir ist nicht lesbar !!
	}
//	refreshListview();
	mustUpdate = true;
}
//*****************************************************************************************
void listView::sortList()
{
	if(itemCount < 2) return;		// 0 oder 1 item brauchen nicht sortiert werden
	
	struct listItem   *item1, *item2;
	int a;
	bool sorted = false;				// werden zwei items vertauscht, so flag auf false setzen
	while(!sorted)
	{
		item1 = Liste;
		item2 = Liste->next;
		sorted = true;
		while(item1->next != 0)
		 {
		 	
        	if(sortOrder)
		 		a = stringCompare(*item1->text[sortButton],*item2->text[sortButton]);
			else
				a = stringCompare(*item2->text[sortButton],*item1->text[sortButton]);
		 	
		 	if(a > 0)
		 	{
		 		// items vertauschen
		 		swapItems(item1,item2);
		 		sorted = false;
		 	}
		 	item1 = item1->next;
		 	item2 = item1->next;
		 }
	}
	
	sorted = false;				// werden zwei items vertauscht, so flag auf false setzen
	while(!sorted)
	{
		item1 = Liste;
		item2 = Liste->next;
		sorted = true;
		while(item1->next != 0)
		 {
		 	
		 	if((item1->listviewIcon != foldericon) && (item2->listviewIcon == foldericon))
		 	{
		 		swapItems(item1,item2);
		 		sorted = false;
		 	}
		 	item1 = item1->next;
		 	item2 = item1->next;
		 }
	}


	struct listItem *merke = Liste;			// dieser zeiger speichert adresse von ".." item
	while(merke->listviewIcon != upicon)
		merke = merke->next;
	// merke hat nun pointer auf ".."
	
	struct listItem *davor = merke->prev;
	struct listItem *danach = merke->next;
	if(davor != 0)					// wenn doppelp. am ende, bzw. mitte steht, dann ....
		if(danach == 0)
		// wenn kein nachfolger existiert, dann
			davor->next = 0;
		else
		{
			davor->next = danach;
			danach->prev = davor;
		}
	else								// hier steht er aber am anfang
	{
		Liste = danach;
		danach->prev = 0;
	}
	// merke = pointer auf ".."
	merke->next = Liste;
	merke->prev = 0;
	Liste->prev = merke;
	Liste = merke;
}
//*****************************************************************************************
int stringCompare(const char *s1,const char *s2, bool ignoreCase = true)
{
	int q = 'a' - 'A';
	QString s;
	
	char t1[256];
	char t2[256];
	strcpy(t1,s1);
	strcpy(t2,s2);
	if(ignoreCase)
		{
			for(int i=0;i < (signed int)strlen(t1);i++)
				if((t1[i] >= 'a') || (t1[i] >= 'z'))
					t1[i] -= q;
			for(int i=0;i < (signed int)strlen(t2);i++)
				if((t2[i] >= 'a') || (t2[i] >= 'z'))
					t2[i] -= q;
		}
	int i=0;

   int m;
   if(strlen(t1) > strlen(t2))
   	m = strlen(t1);
   else
   	m = strlen(t2);

   while(i < m)
   {
		if(t1[i] < t2[i])			return -1;
		if(t1[i] > t2[i])			return 1;
		i++;
   }
	return 0;		
}
//*****************************************************************************************
void listView::hScrollChanged(int v)
{
	refreshColums(0);
	refreshListview();
}
void listView::vScrollChanged(int v)
{
	refreshListview();
}

//*************************[ Breite einer Spalte setzen ]************************************		
void listView::setColumWidth(int SpaltenNummer,int SpaltenBreite){
	if(colums == 0) return;					// wenn Spaltenanzahl = 0 dann zurck

// minimale Spaltenbreite = 20
	if(SpaltenBreite < 20) SpaltenBreite = 20;
// Spaltenbreite setzen
	if(SpaltenNummer > colums) return;  // wenn gewhlte Spaltennummer zu gro, dann zurck !
	
	if(SpaltenNummer == 0)
		// Spaltenbreite ist gleich ENDpixel der Spalte
		columWidth[SpaltenNummer] = SpaltenBreite;
	else
		columWidth[SpaltenNummer] = columWidth[SpaltenNummer-1] + SpaltenBreite;;
	refreshColums(SpaltenNummer);
}

//*****************************************************************************************
void swapItems(struct listItem *i1,struct listItem *i2)
{
	struct listItem temp;
	memcpy(&temp,i1 ,sizeof(struct listItem)-8);
	memcpy(i1,i2,sizeof(struct listItem)-8);
	memcpy(i2,&temp,sizeof(struct listItem)-8);
}
//*****************************************************************************************
int listView::itemsSelected()
{
	int s = 0;
	struct listItem *li=Liste->next;
	while(li != 0)		//DX
	{
		if(li->selected)
			s += 1;
		li = li->next;
	}
	return s;
}
//*****************************************************************************************
void	listView::keyReleaseEvent ( QKeyEvent * e )
{
	QString s;
	int key = e->key();
	if(key > 255)
	{
		// Hier werden die Sondertasten behandelt

		key &= 0xff;
		
		if(key == 32) //SHIFT
			shiftItem = 0;
	}
}
//*****************************************************************************************
void	listView::keyPressEvent ( QKeyEvent * e )
{
	struct listItem *li = Liste;
	while(!li->hasFocus)	li = li->next;	// li ist jetzt das Item, welches den Focus hat

	bool	shift = false;
	QString s;
	int key = e->key();
	// shift wurde gedrckt, wenn state == 8
	
	if(key > 255)
	{
		// Hier werden die Sondertasten behandelt

		key &= 0xff;
//		s.sprintf("Sondertaste: %d",key);
//		mainWindow->setCaption(s);
		
		if(key == 32) 			
			shiftItem = li;

		if(e->state() == 8)
		{
			s = "S";
		}
		else
		{
			s = "";
		}
		
		switch (key){
			case 4:
				emit(itemDoubleClicked(*getItemFocus()->text[0],name()));
        break;
			case 6: 	// Einfge-Taste
				{
					QKeyEvent *k = new QKeyEvent(Event_KeyPress,32,32,0);
					keyPressEvent(k);
					delete k;
					k = new QKeyEvent(Event_KeyPress,4096+21,4096+21,0);
					keyPressEvent(k);
					delete k;
				}
				break;
			case 7:
				s += "ENTF";
				break;
			case 16:		// POS1
				scroll2->setValue(0);
				setItemFocus(Liste);
				break;
			case 17:		// ENDE
				{
					scroll2->setValue(scroll2->maxValue());
					listItem *lv = Liste;
					while(lv->next != 0)
						lv = lv->next;
						setItemFocus(lv);
				}
				break;
			case 18:		// cursor links
				scroll1->setValue(scroll1->value()-5);
				break;
			
			case 19:		// cursor hoch
				s = "";
				// ist Vorgnger von li = 0 ?
				if(li != Liste)
				{
					listItem *t = li;			// pointer merken !
					//ist auf diesem Item SHIFT gedrckt worden,
					//so wird dieses invertiert !
					if(li == shiftItem)
					{
						if(shiftItem->selected)
							shiftItem->selected = false;
						else
							shiftItem->selected = true;
					}
					li->hasFocus = false;
					li = li->prev;
					li->hasFocus = true;
					lastItemClicked = li;
					if(shiftItem != 0)
						li->selected = shiftItem->selected;
					// ist li jetzt ausserhalb Bildschirm ?
					if(t == firstVisibleItem)
						scroll2->setValue(scroll2->value()-10);
					refreshListview();
				}
				break;
			case 21:		// cursor runter
				s = "";
				// ist Vorgnger von li = 0 ?
				if(li->next != 0)
				{
					listItem *t = li;			// pointer merken !
					//ist auf diesem Item SHIFT gedrckt worden,
					//so wird dieses invertiert !
					if(li == shiftItem)
					{
						if(shiftItem->selected)
							shiftItem->selected = false;
						else
							shiftItem->selected = true;
					}
					li->hasFocus = false;
					li = li->next;
					li->hasFocus = true;
					lastItemClicked = li;
					if(shiftItem != 0)
						li->selected = shiftItem->selected;
					// ist li jetzt ausserhalb Bildschirm ?
					if(t == lastVisibleItem)
						scroll2->setValue(scroll2->value()+10);
					refreshListview();
				}
				break;
			
			case 20:		// cursor rechts
				s = "";
				scroll1->setValue(scroll1->value()+5);
				break;
			case 22:		// Bild hoch
				s = "";
				scroll2->setValue(scroll2->value()-5);
				setItemFocus(firstVisibleItem);
				break;
			case 23:		// Bild runter
				scroll2->setValue(scroll2->value()+5);
				setItemFocus(lastVisibleItem);
				break;
			case 32:		//SHIFT !
				shift = true;
				break;
   		case 48:
    			s += "F1";
    			break;
   		case 49:
    			s += "F2";
    			break;
   		case 50:
    			s += "F3";
    			break;
   		case 51:
    			s += "F4";
    			break;
   		case 52:
    			s += "F5";
    			break;
   		case 53:
    			s += "F6";
    			break;
   		case 54:
    			s += "F7";
    			break;
   		case 55:
    			s += "F8";
    			break;
  		case 56:
    			s += "F9";
    			break;
   		case 57:
    			s += "F10";
    			break;
   		case 58:
    			s += "F11";
    			break;
   		case 59:
    			s += "F12";
    			break;
						
		}
		if(s != "")
			emit(keyPressed(s));
	}
   else
   {
		struct listItem *li=Liste;
		bool found = false;
		if(key == 32)		// Space gedrckt ??
		{
			while((li != 0) && !found)
				{
					if(li->hasFocus)
						{
							if(li->selected)
								li->selected = false;
							else
								li->selected = true;
							refreshListview();
							found = true;						
						}
					li=li->next;
				}
	   }
		s.sprintf("%c",key);
	   emit(keyPressed(s));
   }
}

void	listView::drawItem(struct listItem *item,int y)
{
	// y = ZeilenNummer von 0 an
	QPointArray pts;
//	int i;
	int	differenz = scroll1->value();
	int x,b;
			
			if(item->selected)
			{
				p->setBrush(selBackgroundColor);
				p->setPen(selBackgroundColor);
			}
			else	
			{				
				p->setBrush(backgroundColor);
				p->setPen(backgroundColor);
			}
					
			if(item->hasFocus)
					p->setPen(red);
			pts.setPoints(4,  1, y*20+HeaderHeight,
									width()-17,y*20+HeaderHeight,			// Rechteck um Item malen
									width()-17, y*20+19+HeaderHeight,
									1,y*20+19+HeaderHeight);
			p->drawPolygon(pts);	
				
			if(item->selected)
				p->setPen(selForgroundColor);
			else
				p->setPen(forgroundColor);

			for(int j=0;j<colums;j++)
			{
				if(j==0)
				{
					x = 20;
					b = columWidth[j]-20;
				}
				else
				{
					x = columWidth[j-1]+5;
					b = columWidth[j]-columWidth[j-1]-5;
				}
				x -= differenz;
				
				p->drawText(x+1,y*20+HeaderHeight , b,20,AlignLeft,*item->text[j]);
				if(item->listviewIcon != 0)
					bitBlt( (QPaintDevice *)this, 1-differenz+2, y*20+HeaderHeight+2, item->listviewIcon );
			}
			p->setPen(black);
			p->drawLine(0,HeaderHeight,0,height());


}


void	listView::mouseDoubleClickEvent ( QMouseEvent *e )
{
	setFocus();
	if(e->button() == 1) //nur bei linkem mausbutton emitten !
		if(lastItemClicked != 0)
			emit(itemDoubleClicked(*lastItemClicked->text[0],name()));
}


void listView::setItemFocus(listItem *li)
{
	lastItemClicked = li;
	listHasFocus = true;
	listItem *l = Liste;
	while(l != 0)
	{
		l->hasFocus = false;
		if(l == li)
			l->hasFocus = true;
		l = l->next;
	}
	refreshListview();
}

struct listItem * listView::getItemFocus()
{
	listItem *l = Liste;
	while(l != 0)
	{
		if(l->hasFocus) return l;
		l = l->next;
	}
	return 0;
}


