/***************************************************************************
                          kscalar.cpp  -  description
                             -------------------
    begin                : Thu Dec 9 1999
    copyright            : (C) 1999 by B. Heath Robinson
    email                : bheath@earthlink.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "kscalar.h"
#include "kcomplex.h"
#include "functions.h"

#include <math.h>

KScalar::KScalar(){
}
KScalar::KScalar(KScalar& newScalar){
	dValue=newScalar.dValue;
}
KScalar::KScalar(const char * sNewValue,int iBase){
	dValue = convertFromBase(sNewValue,iBase);
}
KScalar::~KScalar(){
}
void KScalar::setValue(const char * sNewValue,int iBase) {
	dValue = convertFromBase(sNewValue,iBase);
	return;
}
double KScalar::getValue() const {
	return this->dValue;
}
const char * KScalar::getStringRepresentation(int iBase)
{
	const char * sRep;
	sRep = convertToBase(dValue,iBase);	
	return sRep;
}

//KScalar Operands
void KScalar::add(KScalar& argElement){
	dValue = double(dValue + argElement.getValue());
}
void KScalar::subtract(KScalar& argElement){
	dValue = double(dValue - argElement.getValue());
}
void KScalar::multiply(KScalar& argElement){
	dValue = double(dValue * argElement.getValue());
}
void KScalar::divide(KScalar& argElement){
	dValue = double(dValue / argElement.getValue());
}
void KScalar::power(KScalar& argElement){
	dValue = double(pow(dValue, int(argElement.getValue())));
}
void KScalar::root(KScalar& argElement){
	dValue = double(pow(dValue, 1.0/int(argElement.getValue())));
}
void KScalar::modulous(KScalar& argElement){
	dValue = double(int(dValue) % int(argElement.getValue()));
}
void KScalar::AND(KScalar& argElement){
	dValue = double(int(dValue) & int(argElement.getValue()));	
}
void KScalar::OR(KScalar& argElement){
	dValue = double(int(dValue) | int(argElement.getValue()));	
}

void KScalar::negate(){
	dValue = -dValue;
}
void KScalar::inverse(){
	dValue = 1 / dValue;
}
void KScalar::compliment(){
	dValue = double(~int(dValue));
}
void KScalar::sine(int unit=0){
	dValue = sin(convertAngle(dValue,unit,1));
}
void KScalar::cosine(int unit=0){
	dValue = cos(convertAngle(dValue,unit,1));
}
void KScalar::tangent(int unit=0){
	dValue = tan(convertAngle(dValue,unit,1));
}
void KScalar::hypSine(){
	dValue = sinh(dValue);
}
void KScalar::hypCosine(){
	dValue = cosh(dValue);
}
void KScalar::hypTangent(){
	dValue = tanh(dValue);
}
void KScalar::arcsine(int unit=0){
	dValue = convertAngle(asin(dValue),1,unit);
}
void KScalar::arccosine(int unit=0){
	dValue = convertAngle(acos(dValue),1,unit);
}
void KScalar::arctangent(int unit=0){
	dValue = convertAngle(atan(dValue),1,unit);
}
void KScalar::hypArcsine(){
	dValue = asinh(dValue);
}
void KScalar::hypArccosine(){
	dValue = acosh(dValue);
}
void KScalar::hypArctangent(){
	dValue = atanh(dValue);
}
void KScalar::ln(){
	dValue = log(dValue);
}	
void KScalar::log10(){
	dValue = log(dValue);
}
void KScalar::ten2X(){
	dValue = double(pow(10,dValue));
}
void KScalar::e2X(){
	dValue = double(pow(M_E,dValue));
}	
void KScalar::factorial(){
	dValue = double(fact(int(dValue)));
}
