/***************************************************************************
                          kpncalc.cpp  -  description
                             -------------------
    begin                : Sun Nov 21 1999
    copyright            : (C) 1999 by B. Heath Robinson
    email                : bheath@earthlink.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kpncalc.h"
#include "kstack.h"
#include "kelement.h"
#include "kscalar.h"
#include "kcomplex.h"
#include <ctype.h>
#include <iostream.h>
#include <stdlib.h>
#include <string.h>
#include <qlistbox.h>
#include <qwidget.h>
#include <qbuttongroup.h>
#include <qkeycode.h>
#include <qclipboard.h>

KPNCalc::KPNCalc(QWidget *parent, const char *name) : QWidget(parent,name){
	
	initDialog();
  this->setCaption(i18n("K Polish Notation Calc"));
  IOBase=1;
	enableDecInput();

  angleUnit=0;
	hyp=0;
	arc=0;
	
	calcStack = new KStack;
	undoStack = new KStack;
	lblBuffer->setText('\0');
	
	setButtonAccels();
	setButtonPixmaps();
	connectSlots();
	
}
void KPNCalc::keyPressEvent(QKeyEvent * k){
	switch (k->key()) {
		//case Key_0 : butZeroClicked(); break;
		//case Key_1 : butOneClicked(); break;
		//case Key_2 : butTwoClicked(); break;
		//case Key_3 : butThreeClicked(); break;
		//case Key_4 : butFourClicked(); break;
		//case Key_5 : butFiveClicked(); break;
		//case Key_6 : butSixClicked(); break;
		//case Key_7 : butSevenClicked(); break;
		//case Key_8 : butEightClicked(); break;
		//case Key_9 : butNineClicked(); break;
		//case Key_A : butAClicked(); break;
		//case Key_B : butBClicked(); break;
		//case Key_C : butCClicked(); break;
		//case Key_D : butDClicked(); break;
		//case Key_E : butEClicked(); break;
		//case Key_F : butFClicked(); break;
		//case Key_Period : butPeriodClicked(); break;
		//case Key_Minus : butSubtractClicked(); break;
		//case Key_Plus : butAddClicked(); break;
		//case Key_Slash : butDivideClicked(); break;
		//case Key_Asterisk : butMultiplyClicked(); break;
		//case Key_Delete : butDeleteClicked(); break;
		case Key_Return : butEnterClicked(); break;
	}
}

void KPNCalc::ReloadGrid(){
	const char * charBuffer;
	KElement * currentElement;
	lstStack->clear();

	currentElement = calcStack->getBase();
	while(currentElement != '\0'){
		charBuffer = new char[11];
		charBuffer = currentElement->getStringRepresentation(IOBase);
		lstStack->insertItem(charBuffer,0);	
		currentElement = currentElement->getPrevious();
	}
	lstStack->setBottomItem(lstStack->count());
}

void KPNCalc::enableBinInput(){
	butTwo->setEnabled(FALSE);
	butThree->setEnabled(FALSE);
	butFour->setEnabled(FALSE);
	butFive->setEnabled(FALSE);
	butSix->setEnabled(FALSE);
	butSeven->setEnabled(FALSE);
	butEight->setEnabled(FALSE);
	butNine->setEnabled(FALSE);
	butA->setEnabled(FALSE);
	butB->setEnabled(FALSE);
	butC->setEnabled(FALSE);
	butD->setEnabled(FALSE);
	butE->setEnabled(FALSE);
	butF->setEnabled(FALSE);
	butPeriod->setEnabled(FALSE);
}
void KPNCalc::enableDecInput(){
	butTwo->setEnabled(TRUE);
	butThree->setEnabled(TRUE);
	butFour->setEnabled(TRUE);
	butFive->setEnabled(TRUE);
	butSix->setEnabled(TRUE);
	butSeven->setEnabled(TRUE);
	butEight->setEnabled(TRUE);
	butNine->setEnabled(TRUE);
	butA->setEnabled(FALSE);
	butB->setEnabled(FALSE);
	butC->setEnabled(FALSE);
	butD->setEnabled(FALSE);
	butE->setEnabled(FALSE);
	butF->setEnabled(FALSE);
	butPeriod->setEnabled(TRUE);
}
void KPNCalc::enableHexInput(){
	butTwo->setEnabled(TRUE);
	butThree->setEnabled(TRUE);
	butFour->setEnabled(TRUE);
	butFive->setEnabled(TRUE);
	butSix->setEnabled(TRUE);
	butSeven->setEnabled(TRUE);
	butEight->setEnabled(TRUE);
	butNine->setEnabled(TRUE);
	butA->setEnabled(TRUE);
	butB->setEnabled(TRUE);
	butC->setEnabled(TRUE);
	butD->setEnabled(TRUE);
	butE->setEnabled(TRUE);
	butF->setEnabled(TRUE);
	butPeriod->setEnabled(FALSE);
}

KPNCalc::~KPNCalc(){         	
	delete(calcStack);
	delete(undoStack);
}

void KPNCalc::butOneClicked(){
	RefreshStatus();
	addCharToBuffer(i18n("1"));
}
void KPNCalc::butTwoClicked(){
	RefreshStatus();
	addCharToBuffer(i18n("2"));
}
void KPNCalc::butThreeClicked(){
	RefreshStatus();
	addCharToBuffer(i18n("3"));
}
void KPNCalc::butFourClicked(){
	RefreshStatus();
	addCharToBuffer(i18n("4"));
}
void KPNCalc::butFiveClicked(){
	RefreshStatus();
	addCharToBuffer(i18n("5"));
}
void KPNCalc::butSixClicked(){
	RefreshStatus();
	addCharToBuffer(i18n("6"));
}
void KPNCalc::butSevenClicked(){
	RefreshStatus();
	addCharToBuffer(i18n("7"));
}
void KPNCalc::butEightClicked(){
	RefreshStatus();
	addCharToBuffer(i18n("8"));
}
void KPNCalc::butNineClicked(){
	RefreshStatus();
	addCharToBuffer(i18n("9"));
}
void KPNCalc::butZeroClicked(){
	RefreshStatus();
	addCharToBuffer(i18n("0"));
}
void KPNCalc::butAClicked(){
	RefreshStatus();
	addCharToBuffer(i18n("A"));
}
void KPNCalc::butBClicked(){
	RefreshStatus();
	addCharToBuffer(i18n("B"));
}
void KPNCalc::butCClicked(){
	RefreshStatus();
	addCharToBuffer(i18n("C"));
}
void KPNCalc::butDClicked(){
	RefreshStatus();
	addCharToBuffer(i18n("D"));
}
void KPNCalc::butEClicked(){
	RefreshStatus();
	addCharToBuffer(i18n("E"));
}
void KPNCalc::butFClicked(){
	RefreshStatus();
	addCharToBuffer(i18n("F"));
}
void KPNCalc::butPeriodClicked(){
	RefreshStatus();
	if (lblBuffer->text() == '\0') {
		addCharToBuffer(i18n("0"));
		addCharToBuffer(i18n("."));
	} else {
		if (!strchr(lblBuffer->text(), '.'))
			addCharToBuffer(i18n("."));
		else
			lblStatus->setText("The buffer already contains a period.");
	}
}

void KPNCalc::butNegateClicked(){
	char * lblText;
	double lblValue;
	RefreshStatus();
	saveUndo();
	if (lblBuffer->text() != '\0') {
		lblValue = atof(lblBuffer->text());
		if (lblValue > 0) {
			if(strchr(lblBuffer->text(),'e')) {
				char * eLoc;
				eLoc = strchr(lblBuffer->text(),'e');
				if (atoi(eLoc+1) > 0) {
					char * exponent;
					exponent = new char[strlen(eLoc)];
					exponent = strcpy(exponent,(eLoc+1));
					lblText = new char[strlen(lblBuffer->text())+1];
					lblText = strcpy(lblText,strtok((char*)lblBuffer->text(),i18n("e")));
					strcat(lblText,i18n("e-"));
					strcat(lblText,exponent);
					delete(exponent);
				} else {
					if (*(eLoc+1) != '-') {
						lblText = new char[strlen(lblBuffer->text())+1];
						lblText = strcpy(lblText,strtok((char*)lblBuffer->text(),i18n("e")));
						strcat(lblText,i18n("e-"));						
					} else {
						char * exponent;
						exponent = new char[strlen(eLoc)];
						exponent = strcpy(exponent,(eLoc+2));
						lblText = new char[strlen(lblBuffer->text())-1];
						lblText = strcpy(lblText,strtok((char*)lblBuffer->text(),i18n("e")));
						strcat(lblText,i18n("e"));
						strcat(lblText,exponent);
						delete(exponent);
					}					
				}
  		} else {
				lblText = new char[1+strlen(lblBuffer->text())];
				lblText = strcpy(lblText,i18n("-"));
				strcat(lblText,lblBuffer->text());
			}
		} else {
			lblText = new char[strlen(lblBuffer->text())-1];
			lblText = strcpy(lblText,lblBuffer->text());
			for (int i=strlen(lblText);i>0;i--){
				lblText[i-1] = lblBuffer->text()[i];
			}
		}
		lblBuffer->setText(lblText);
		delete(lblText);
	} else {
		calcStack->negate();
		ReloadGrid();
	}
}
void KPNCalc::butExpNotationClicked(){
	RefreshStatus();
	if (lblBuffer->text() != '\0')
		if (!strchr(lblBuffer->text(), 'e'))
			addCharToBuffer(i18n("e"));
		else
			lblStatus->setText("You are already in exponential notation mode.");
	else
		lblStatus->setText("You must first have a base to raise.");
}

void KPNCalc::butPasteClicked(){
	QClipboard *cb = QApplication::clipboard();
	lblBuffer->setText(cb->text());
	//delete(cb);
}
void KPNCalc::butCopyClicked(){
	QClipboard *cb = QApplication::clipboard();
	cb->setText(lstStack->text(lstStack->currentItem()));
	//delete(cb);
}
void KPNCalc::butEnterClicked(){
	KElement * newElement;
	RefreshStatus();
	saveUndo();
	if (lblBuffer->text() != '\0') {
		newElement = createNewElement(lblBuffer->text());
		calcStack->push(newElement);
		ReloadGrid();
		lblBuffer->setText('\0');
	}
}
void KPNCalc::butSwapClicked(){
	RefreshStatus();
	if (validateOperation(2)) {
		saveUndo();
		calcStack->swap();
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need two arguements to swap."));
	}	
}
void KPNCalc::butRollClicked(){
	int selectedItem;
	RefreshStatus();
	selectedItem=lstStack->currentItem();
	if (validateOperation(2) && selectedItem != -1) {
		saveUndo();
		calcStack->roll(lstStack->count()-selectedItem-1);
		ReloadGrid();
		lstStack->setCurrentItem(selectedItem);
	} else {
		lblStatus->setText(i18n("You need at least two arguements to roll."));
	}	

}
void KPNCalc::butFlipClicked(){
	int selectedItem;
	RefreshStatus();
	selectedItem=lstStack->currentItem();
	if (validateOperation(2) && selectedItem != -1) {
		saveUndo();
		calcStack->flip(lstStack->count()-selectedItem-1);
		ReloadGrid();
		lstStack->setCurrentItem(selectedItem);
	} else {
		lblStatus->setText(i18n("You need at least two arguements to flip."));
	}	

}
void KPNCalc::butFloatClicked(){
	int selectedItem;
	RefreshStatus();
	selectedItem=lstStack->currentItem();
	cout << selectedItem << endl;
	if (validateOperation(2) && selectedItem != -1 && selectedItem != 0) {
		saveUndo();
		calcStack->floate(lstStack->count()-selectedItem-1);
		ReloadGrid();
		lstStack->setCurrentItem(selectedItem-1);
	} else {
		if (validateOperation(2))
			if (selectedItem != -1)
				lblStatus->setText(i18n("You cannot float the top element."));
			else
				lblStatus->setText(i18n("Please select an element to float."));
		else
			lblStatus->setText(i18n("You need two arguements to float."));

	}	

}
void KPNCalc::butSinkClicked(){
	int selectedItem;
	RefreshStatus();
	selectedItem=lstStack->currentItem();
	cout << selectedItem << endl;
	if (validateOperation(2) && selectedItem != -1 && unsigned(selectedItem) != lstStack->count()-1) {
 		saveUndo();
		calcStack->sink(lstStack->count()-selectedItem-1);
		ReloadGrid();
		lstStack->setCurrentItem(selectedItem+1);
	} else {
		if (validateOperation(2))
			if (selectedItem != -1)
				lblStatus->setText(i18n("You cannot sink the bottom element."));
			else
				lblStatus->setText(i18n("Please select an element to sink."));
		else
			lblStatus->setText(i18n("You need two arguements to sink."));
	}	

}
void KPNCalc::butDeleteClicked(){
	RefreshStatus();
	if (validateOperation(1)) {
		saveUndo();
		calcStack->pop();
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need an arguement to delete."));
	}	
}
void KPNCalc::butClearClicked(){
	RefreshStatus();
	saveUndo();
	calcStack->clear();
	ReloadGrid();
}
void KPNCalc::butCancelClicked(){
	lblBuffer->setText('\0');
}
void KPNCalc::butBackClicked(){
	char * lblText;
	if (strlen(lblBuffer->text()) !=0 ) {
		lblText = new char[sizeof('\0')*strlen(lblBuffer->text())];
		lblText=strncpy(lblText,lblBuffer->text(),strlen(lblBuffer->text())-1);
		lblText[strlen(lblBuffer->text())-1]='\0';
		lblBuffer->setText(lblText);
		delete(lblText);
	}
}
void KPNCalc::butANDClicked(){
	RefreshStatus();
	if (validateOperation(2)) {
		saveUndo();
		calcStack->AND();
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need two arguements to AND."));
	}	
}
void KPNCalc::butORClicked(){
	RefreshStatus();
	if (validateOperation(2)) {
		saveUndo();
		calcStack->OR();
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need two arguements to OR."));
	}	
}
void KPNCalc::butComplimentClicked(){
	RefreshStatus();
	if (validateOperation(1)) {
		saveUndo();
		calcStack->compliment();
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need two arguements to find compliment."));
	}	
}
void KPNCalc::butAddClicked(){
	RefreshStatus();
	if (validateOperation(2)) {
		saveUndo();
		calcStack->add();
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need two arguements to add."));
	}	
}
void KPNCalc::butSubtractClicked(){
	RefreshStatus();
	if (validateOperation(2)) {
		saveUndo();
		calcStack->subtract();
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need two arguements to subtract."));
	}
}
void KPNCalc::butMultiplyClicked(){
	RefreshStatus();
	if (validateOperation(2)) {
		saveUndo();
		calcStack->multiply();
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need two arguements to multiply."));
	}
}
void KPNCalc::butDivideClicked(){
	RefreshStatus();
	if (validateOperation(2)) {
		saveUndo();
		calcStack->divide();
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need two arguements to divide."));
	}
}
void KPNCalc::butModulousClicked(){
	RefreshStatus();
	if (validateOperation(2)) {
		saveUndo();
		calcStack->modulous();
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need two arguements to modulous."));
	}
}
void KPNCalc::butInverseClicked(){
	RefreshStatus();
	if (validateOperation(1)) {
		saveUndo();
		calcStack->inverse();
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need an arguement to invert."));
	}
}
void KPNCalc::butE2XClicked(){
	RefreshStatus();
	if (validateOperation(1)) {
		saveUndo();
		calcStack->e2X();
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need an arguement to which to raise e."));
	}
}
void KPNCalc::butTen2XClicked(){
	RefreshStatus();
	if (validateOperation(1)) {
		saveUndo();
		calcStack->ten2X();
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need an arguements to to which to raise 10."));
	}
}
void KPNCalc::butRootClicked(){
	RefreshStatus();
	if (validateOperation(2)) {
		saveUndo();
		calcStack->root();
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need two arguements to find yth root."));
	}
}
void KPNCalc::butPowerClicked(){
	RefreshStatus();
	if (validateOperation(2)) {
		saveUndo();
		calcStack->power();
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need two arguements to raise to yth power."));
	}
}
void KPNCalc::butArcClicked(){
	if (arc == 1)
		arc = 0;
	else
		arc = 1;
}
void KPNCalc::butHypClicked(){
	if (hyp == 1)
		hyp = 0;
	else
		hyp = 1;
}
void KPNCalc::butSinClicked(){
	RefreshStatus();
	if (validateOperation(1)) {
		saveUndo();
		if (hyp)
			if (arc) {
				calcStack->hypArcsine();
				butArc->toggle();
				butArcClicked();
			} else
				calcStack->hypSine();
		else
			if (arc) {
				calcStack->arcsine(angleUnit);
				butArc->toggle();
				butArcClicked();
			} else
				calcStack->sine(angleUnit);
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need one argument to find the sine."));
	}
}
void KPNCalc::butCosClicked(){
	RefreshStatus();
	if (validateOperation(1)) {
		saveUndo();
		if (hyp)
			if (arc) {
				calcStack->hypArccosine();
				butArc->toggle();
				butArcClicked();
			} else
				calcStack->hypCosine();
		else
			if (arc) {
				calcStack->arccosine(angleUnit);
				butArc->toggle();
				butArcClicked();
			}	else
				calcStack->cosine(angleUnit);
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need one arguements find the cosine."));
	}
}
void KPNCalc::butTanClicked(){
	RefreshStatus();
	if (validateOperation(1)) {
		saveUndo();
		if (hyp)
			if (arc) {
				calcStack->arctangent();
				butArc->toggle();
				butArcClicked();
			}	else
				calcStack->hypTangent();
		else
			if (arc) {
				calcStack->arctangent(angleUnit);
				butArc->toggle();
				butArcClicked();
			}	else
				calcStack->tangent(angleUnit);
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need one arguements find the tangent."));
	}
}
void KPNCalc::butLogClicked(){
	RefreshStatus();
	if (validateOperation(1)) {
		saveUndo();
		calcStack->log10();
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need two arguements to raise to yth power."));
	}
}
void KPNCalc::butLnClicked(){
	RefreshStatus();
	if (validateOperation(1)) {
		saveUndo();
		calcStack->ln();
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need two arguements to raise to yth power."));
	}
}
void KPNCalc::butFactorialClicked(){
	RefreshStatus();
	if (validateOperation(1)) {
		saveUndo();
		calcStack->factorial();
		ReloadGrid();
	} else {
		lblStatus->setText(i18n("You need two arguements to raise to yth power."));
	}
}

void KPNCalc::butUndoClicked(){
	restoreUndoStack();
}

void KPNCalc::butHelpClicked(){
	 kapp->invokeHTMLHelp("kpncalc/index.html","");
}

int KPNCalc::validateOperation(int stackHtReq){
	KElement * newElement;
	if (calcStack->stackHeight > stackHtReq-1) {
		if (lblBuffer->text() != '\0') {
				newElement = createNewElement(lblBuffer->text());
				calcStack->push(newElement);
				lblBuffer->setText('\0');			
		}
		return 1;
	} else {
		if (calcStack->stackHeight == stackHtReq-1 && lblBuffer->text() != '\0') {
			if (lblBuffer->text() != '\0') {
				newElement = createNewElement(lblBuffer->text());
				calcStack->push(newElement);
				lblBuffer->setText('\0');			
			}	else {
				return 0;
			}
			return 1;
		} else {
			return 0;
		}
	}
}

void KPNCalc::butBaseClicked(){
	if (IOBase==2)
		IOBase = 0;
	else
		IOBase++;

	switch(IOBase){
		case 0: enableBinInput();butBase->setText(i18n("Binary"));break;
		case 1: enableDecInput();butBase->setText(i18n("Decimal"));break;
		case 2: enableHexInput();butBase->setText(i18n("Hexidecimal"));break;
	}
	ReloadGrid();
}
void KPNCalc::butAngleClicked(){
	if (angleUnit==2)
		angleUnit = 0;
	else
		angleUnit++;
	switch(angleUnit){
		case 0: butAngle->setText(i18n("Degrees")); break;
		case 1: butAngle->setText(i18n("Radians"));break;
		case 2: butAngle->setText(i18n("Gradients"));break;
	}
}

void KPNCalc::RefreshStatus(){
	lblStatus->setText('\0');
}
void KPNCalc::addCharToBuffer(const char * c){
	char * lblText;
	if (lblBuffer->text() != '\0') {
		lblText = new char[1 + strlen(lblBuffer->text())];
		lblText = strcpy(lblText, lblBuffer->text());
		strcat(lblText,c);
	} else {
		lblText = new char[2];
		lblText = strcpy(lblText,c);
	}
	lblBuffer->setText(lblText);
	delete(lblText);
}
void KPNCalc::restoreUndoStack(){
	delete(calcStack);
	undoStack->flip(undoStack->stackHeight-1);
	calcStack = undoStack;
	undoStack = new KStack(*calcStack);
	butUndo->setEnabled(FALSE);
	ReloadGrid();
}
void KPNCalc::saveUndo(){
	if (calcStack->stackHeight > 0) {
		delete(undoStack);
		undoStack = new KStack(*calcStack);
		butUndo->setEnabled(TRUE);
	}
}

KElement * KPNCalc::createNewElement(const char * sStringRep){
	KElement * newElement;
	if (isdigit(sStringRep[0]) > 0 || (isdigit(sStringRep[1]) > 0 && sStringRep[0] == '-'))	{   						
		KScalar * newScalar;
		newScalar = new KScalar(sStringRep, IOBase);
		newElement = new KElement(*newScalar);
	}	else if (strchr(sStringRep,'(')) {
    KComplex * newComplex;
		newElement = new KElement;
		newComplex = new KComplex(sStringRep, IOBase);
		newElement = new KElement(*newComplex);
	}/*	else if (strchr(sStringRep, '[')) {
		KMatrix * newMatrix;
		newMatrix = new KMatrix(sStringRep, IOBase);
		newElement = new KElement(*newMatrix);
	}*/
	return newElement;
}


void KPNCalc::connectSlots(){
	connect(butOne, SIGNAL( clicked() ), this, SLOT( butOneClicked() ));
	connect(butTwo, SIGNAL( clicked() ), this, SLOT( butTwoClicked() ));
	connect(butThree, SIGNAL( clicked() ), this, SLOT( butThreeClicked() ));
	connect(butFour, SIGNAL( clicked() ), this, SLOT( butFourClicked() ));
	connect(butFive, SIGNAL( clicked() ), this, SLOT( butFiveClicked() ));
	connect(butSix, SIGNAL( clicked() ), this, SLOT( butSixClicked() ));
	connect(butSeven, SIGNAL( clicked() ), this, SLOT( butSevenClicked() ));
	connect(butEight, SIGNAL( clicked() ), this, SLOT( butEightClicked() ));
	connect(butNine, SIGNAL( clicked() ), this, SLOT( butNineClicked() ));
	connect(butZero, SIGNAL( clicked() ), this, SLOT( butZeroClicked() ));
	connect(butA, SIGNAL( clicked() ), this, SLOT( butAClicked() ));
	connect(butB, SIGNAL( clicked() ), this, SLOT( butBClicked() ));
	connect(butC, SIGNAL( clicked() ), this, SLOT( butCClicked() ));
	connect(butD, SIGNAL( clicked() ), this, SLOT( butDClicked() ));
	connect(butE, SIGNAL( clicked() ), this, SLOT( butEClicked() ));
	connect(butF, SIGNAL( clicked() ), this, SLOT( butFClicked() ));
	connect(butPeriod, SIGNAL( clicked() ), this, SLOT( butPeriodClicked() ));
	connect(butNegate, SIGNAL( clicked() ), this, SLOT( butNegateClicked() ));
	connect(butExpNotation, SIGNAL( clicked() ), this, SLOT( butExpNotationClicked() ));
	connect(butEnter, SIGNAL( clicked() ), this, SLOT( butEnterClicked() ));
	connect(butSwap, SIGNAL( clicked() ), this, SLOT( butSwapClicked() ));
	connect(butRoll, SIGNAL( clicked() ), this, SLOT( butRollClicked() ));
	connect(butFlip, SIGNAL( clicked() ), this, SLOT( butFlipClicked() ));
	connect(butFloat, SIGNAL( clicked() ), this, SLOT( butFloatClicked() ));
	connect(butSink, SIGNAL( clicked() ), this, SLOT( butSinkClicked() ));
	connect(butDelete, SIGNAL( clicked() ), this, SLOT( butDeleteClicked() ));
	connect(butClear, SIGNAL( clicked() ), this, SLOT( butClearClicked() ));	
	connect(butBack, SIGNAL( clicked() ), this, SLOT( butBackClicked() ));
	connect(butCancel, SIGNAL( clicked() ), this, SLOT( butCancelClicked() ));
	connect(butAND, SIGNAL( clicked() ), this, SLOT( butANDClicked() ));
	connect(butOR, SIGNAL( clicked() ), this, SLOT( butORClicked() ));
	connect(butCompliment, SIGNAL( clicked() ), this, SLOT( butComplimentClicked() ));
	connect(butAdd, SIGNAL( clicked() ), this, SLOT( butAddClicked() ));	
	connect(butSubtract, SIGNAL( clicked() ), this, SLOT( butSubtractClicked() ));	
	connect(butMultiply, SIGNAL( clicked() ), this, SLOT( butMultiplyClicked() ));	
	connect(butDivide, SIGNAL( clicked() ), this, SLOT( butDivideClicked() ));	
	connect(butModulous, SIGNAL( clicked() ), this, SLOT( butModulousClicked() ));	
	connect(butInverse, SIGNAL( clicked() ), this, SLOT( butInverseClicked() ));	
	connect(butPower, SIGNAL( clicked() ), this, SLOT( butPowerClicked() ));	
	connect(butRoot, SIGNAL( clicked() ), this, SLOT( butRootClicked() ));	
	connect(butUndo, SIGNAL( clicked() ), this, SLOT( butUndoClicked() ));
	connect(butArc, SIGNAL( clicked() ), this, SLOT( butArcClicked() ));	
	connect(butHyp, SIGNAL( clicked() ), this, SLOT( butHypClicked() ));
	connect(butSin, SIGNAL( clicked() ), this, SLOT( butSinClicked() ));
	connect(butCos, SIGNAL( clicked() ), this, SLOT( butCosClicked() ));
	connect(butTan, SIGNAL( clicked() ), this, SLOT( butTanClicked() ));
	connect(butLn, SIGNAL( clicked() ), this, SLOT(	butLnClicked() ));
	connect(butLog, SIGNAL( clicked() ), this, SLOT( butLogClicked() ));
	connect(butE2X, SIGNAL( clicked() ), this, SLOT( butE2XClicked() ));
	connect(butTen2X, SIGNAL( clicked() ), this, SLOT( butTen2XClicked() ));
	connect(butFactorial, SIGNAL( clicked() ), this, SLOT( butFactorialClicked() ));
	connect(butAngle, SIGNAL( clicked() ), this, SLOT( butAngleClicked() ));
	connect(butBase, SIGNAL( clicked() ), this, SLOT( butBaseClicked() ));
	connect(butCopy, SIGNAL( clicked() ), this, SLOT( butCopyClicked() ));
	connect(butPaste, SIGNAL( clicked() ), this, SLOT( butPasteClicked() ));
	connect(butHelp, SIGNAL( clicked() ), this, SLOT( butHelpClicked() ));
	
}

void KPNCalc::setButtonPixmaps(){
  QString qsPixmapLocation;
	qsPixmapLocation = kapp->kde_datadir() + "/kpncalc/buttons/";
	butEnter->setPixmap(QPixmap(qsPixmapLocation + "enter.xpm"));
	butFlip->setPixmap(QPixmap(qsPixmapLocation + "flip.xpm"));
	butSwap->setPixmap(QPixmap(qsPixmapLocation + "swap.xpm"));
	butRoll->setPixmap(QPixmap(qsPixmapLocation + "roll.xpm"));

	qsPixmapLocation = kapp->kde_toolbardir() + "/";
	butCancel->setPixmap(QPixmap(qsPixmapLocation + "start.xpm"));
	butBack->setPixmap(QPixmap(qsPixmapLocation + "back.xpm"));
	butClear->setPixmap(QPixmap(qsPixmapLocation + "filenew2.xpm"));
	butFloat->setPixmap(QPixmap(qsPixmapLocation + "up.xpm"));
	butSink->setPixmap(QPixmap(qsPixmapLocation + "down.xpm"));
	butDelete->setPixmap(QPixmap(qsPixmapLocation + "delete.xpm"));
	butUndo->setPixmap(QPixmap(qsPixmapLocation + "undo.xpm"));
	butCopy->setPixmap(QPixmap(qsPixmapLocation + "editcopy.xpm"));
	butPaste->setPixmap(QPixmap(qsPixmapLocation + "editpaste.xpm"));
	butHelp->setPixmap(QPixmap(qsPixmapLocation + "help.xpm"));
}
/**  */
void KPNCalc::setButtonAccels(){
	butOne->setAccel('1');
	butTwo->setAccel('2');
	butThree->setAccel('3');
	butFour->setAccel('4');
	butFive->setAccel('5');
	butSix->setAccel('6');
	butSeven->setAccel('7');
	butEight->setAccel('8');
	butNine->setAccel('9');
	butZero->setAccel('0');
	butA->setAccel('A');
	butB->setAccel('B');
	butC->setAccel('C');
	butD->setAccel('D');
	butE->setAccel('E');
	butF->setAccel('F');
	butExpNotation->setAccel('X');
	butInverse->setAccel('I');
	butRoot->setAccel('R');
	butPower->setAccel('P');
	butLn->setAccel('L');
	butCompliment->setAccel('^');
	butFactorial->setAccel('!');
	butNegate->setAccel('N');
	butSin->setAccel('S');
	butCos->setAccel('O');
	butTan->setAccel('T');
	butAND->setAccel('&');
	butOR->setAccel('|');
	butCompliment->setAccel('M');
	butEnter->setAccel(Key_Enter);
	butPeriod->setAccel(Key_Period);
	butAdd->setAccel(Key_Plus);
	butSubtract->setAccel(Key_Minus);
	butMultiply->setAccel(Key_Asterisk);
	butDivide->setAccel(Key_Slash);	
	butModulous->setAccel(Key_Percent);
	butDelete->setAccel(Key_Delete);
	butClear->setAccel(CTRL+'L');	
	butSwap->setAccel(CTRL+'S');
	butFlip->setAccel(CTRL+'F');
	butRoll->setAccel(CTRL+'R');
	butFloat->setAccel(CTRL+'O');
	butSink->setAccel(CTRL+'I');
	butUndo->setAccel(CTRL+'Z');
	butBack->setAccel(Key_Backspace);
	butCancel->setAccel(Key_Escape);
	butAngle->setAccel(CTRL+'A');
	butBase->setAccel(CTRL+'B');
	butCopy->setAccel(CTRL+'C');
	butPaste->setAccel(CTRL+'V');
	butHelp->setAccel(Key_F1);

}
