/***************************************************************************
                          kelement.cpp  -  description
                             -------------------
    begin                : Fri Nov 19 1999
    copyright            : (C) 1999 by B. Heath Robinson
    email                : bheath@earthlink.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kelement.h"
#include "kpncalcerr.h"
#include <string.h>

KElement::KElement(){
	previousElement = '\0';
	scalarElement = '\0';
	complexElement = '\0';
	sErrorMessage='\0';
}
KElement::KElement(KElement& newElement){
	previousElement = '\0';
	sErrorMessage='\0';
	scalarElement = '\0';
	complexElement = '\0';
	switch (newElement.elementType){
	case 'S' : setElement(*newElement.scalarElement); break;
	case 'C' : setElement(*newElement.complexElement); break;
	}
	elementType = newElement.elementType;
}
KElement::KElement(KScalar& newScalarElement){
	previousElement = '\0';
	sErrorMessage='\0';
	complexElement = '\0';
	setElement(newScalarElement);	
}
KElement::KElement(KComplex& newComplexElement){
	previousElement = '\0';
	sErrorMessage='\0';
	scalarElement = '\0';
	setElement(newComplexElement);
}
/*KElement::KElement(KMatrix * newMatrixElement){
	previousElement = '\0';
	sErrorMessage='\0';
	setElement(newMatrixElement);
}*/
KElement::~KElement(){
	if (sErrorMessage != '\0')
		delete sErrorMessage;
}
const char * KElement::getStringRepresentation(int iBase) {
	const char * sStringRep;
	switch (elementType) {
	case 'S': sStringRep = scalarElement->getStringRepresentation(iBase); break;
	case 'C': sStringRep = complexElement->getStringRepresentation(iBase); break;	
	}
	return sStringRep;
}

int KElement::setElement(KScalar& newScalarElement) {
	scalarElement = new KScalar(newScalarElement);
	elementType = 'S';
	if (complexElement != '\0'){
		delete complexElement;
		complexElement = '\0';
	}	
/*	if (matrixElement != '\0'){
		delete matrixElement;
		matrixElement = '\0';
	}*/
	return 0;
}
int KElement::setElement(KComplex& newComplexElement) {
	complexElement = new KComplex(newComplexElement);
	elementType = 'C';
	if (scalarElement != '\0'){
		delete scalarElement;
		scalarElement = '\0';
	}	
/*	if (matrixElement != '\0'){
		delete matrixElement;
		matrixElement = '\0';
	}*/
	return 0;
}
/*int KElement::setElement(KMatrix * newMatrixElement){
	matrixElement = KMatrix(newMatrixElement);
	elementType = 'M';
	if (complexElement != '\0'){
		delete complexElement;
		complexElement = '\0';
	}	
	if (scalarElement != '\0'){
		delete scalarElement;
		scalarElement = '\0';
	}
	return 0;
}*/

KElement * KElement::getPrevious() const {
	return previousElement;
}
void KElement::setPrevious(KElement * newElement){
	previousElement = newElement;
}
void KElement::setError(int iErrNo) {
	iErrorNumber = iErrNo;
	sErrorMessage = new char[30];
	switch (iErrNo) {
		case 10: strcpy(sErrorMessage, CALC_ERRMSG_INVALID_ARG); break;
		default: strcpy(sErrorMessage, CALC_ERRMSG_UNKNOWN); break;
	}
}

void KElement::add(KElement& addElement){
	switch(elementType) {
		case 'S':	{
				 		switch (addElement.getType()){
							case 'S': scalarElement->add(*addElement.scalarElement); break;
							//case 'C': scalarElement->add(*addElement.complexElement); break;
						}
					}; break;
		case 'C':	{
				 		switch (addElement.getType()){
							case 'S': complexElement->add(*addElement.scalarElement); break;
							case 'C': complexElement->add(*addElement.complexElement); break;
						}
					}; break;
	}
}
void KElement::subtract(KElement& subtractElement){
	switch(elementType) {
		case 'S':	{
				 		switch (subtractElement.getType()){
							case 'S': scalarElement->subtract(*subtractElement.scalarElement); break;
							//case 'C': scalarElement->subtract(*subtractElement.complexElement); break;
						}
					}; break;
		case 'C':	{
				 		switch (subtractElement.getType()){
							case 'S': complexElement->subtract(*subtractElement.scalarElement); break;
							case 'C': complexElement->subtract(*subtractElement.complexElement); break;
						}
					}; break;
	}
}
void KElement::multiply(KElement& multiplyElement){
	switch(elementType) {
		case 'S':	{
				 		switch (multiplyElement.getType()){
							case 'S': scalarElement->multiply(*multiplyElement.scalarElement); break;
							//case 'C': scalarElement->multiply(*multiplyElement.complexElement); break;
						}
					}; break;
		case 'C':	{
				 		switch (multiplyElement.getType()){
							case 'S': complexElement->multiply(*multiplyElement.scalarElement); break;
							case 'C': complexElement->multiply(*multiplyElement.complexElement); break;
						}
					}; break;
	}
}
void KElement::divide(KElement& divisorElement){
	switch(elementType) {
		case 'S':	{
				 		switch (divisorElement.getType()){
							case 'S': scalarElement->divide(*divisorElement.scalarElement); break;
							//case 'C': scalarElement->divide(*divisorElement.complexElement); break;
						}
					}; break;
		case 'C':	{
				 		switch (divisorElement.getType()){
							case 'S': complexElement->divide(*divisorElement.scalarElement); break;
							case 'C': complexElement->divide(*divisorElement.complexElement); break; 		
						}
					}; break;
	}
}
void KElement::power(KElement& exponentElement){
	switch(elementType) {
		case 'S':	{
				 		switch (exponentElement.getType()){
							case 'S': scalarElement->power(*exponentElement.scalarElement); break;
							//case 'C': scalarElement->power(*exponentElement.complexElement); break;
						}
					}; break;
		case 'C':	{
				 		switch (exponentElement.getType()){
							case 'S': complexElement->power(*exponentElement.scalarElement); break;
							case 'C': complexElement->power(*exponentElement.complexElement); break;
						}
					}; break;
	}
}
void KElement::root(KElement& rootElement){
	switch(elementType) {
		case 'S':	{
				 		switch (rootElement.getType()){
							case 'S': scalarElement->root(*rootElement.scalarElement); break;
							//case 'C': scalarElement->root(*rootElement.complexElement); break;
						}
					}; break;
		case 'C':	{
				 		switch (rootElement.getType()){
							case 'S': complexElement->root(*rootElement.scalarElement); break;
							case 'C': complexElement->root(*rootElement.complexElement); break;
						}
					}; break;
	}
}
void KElement::modulous(KElement& divisorElement) {
	switch(elementType) {
		case 'S':	{
				 		switch (divisorElement.getType()){
							case 'S': scalarElement->modulous(*divisorElement.scalarElement); break;
							//case 'C': scalarElement->modulous(*divisorElement.complexElement); break;
						}
					}; break;
		case 'C':	{
				 		switch (divisorElement.getType()){
							case 'S': complexElement->modulous(*divisorElement.scalarElement); break;
							case 'C': complexElement->modulous(*divisorElement.complexElement); break;
						}
					}; break;
	}
}
void KElement::AND(KElement& ANDElement){
	switch(elementType) {
		case 'S':	{
				 		switch (ANDElement.getType()){
							case 'S': scalarElement->AND(*ANDElement.scalarElement); break;
							//case 'C': scalarElement->AND(*ANDElement.complexElement); break;
						}
					}; break;
		case 'C':	{
				 		switch (ANDElement.getType()){
							case 'S': complexElement->AND(*ANDElement.scalarElement); break;
							case 'C': complexElement->AND(*ANDElement.complexElement); break;
						}
					}; break;
	}
};
void KElement::OR(KElement& ORElement){
	switch(elementType) {
		case 'S':	{
				 		switch (ORElement.getType()){
							case 'S': scalarElement->OR(*ORElement.scalarElement); break;
							//case 'C': scalarElement->OR(*ORElement.complexElement); break;
						}
					}; break;
		case 'C':	{
				 		switch (ORElement.getType()){
							case 'S': complexElement->OR(*ORElement.scalarElement); break;
							case 'C': complexElement->OR(*ORElement.complexElement); break;
						}
					}; break;
	}
};

	//Unary Operators
void KElement::negate(){
	switch(elementType) {
		case 'S':	scalarElement->negate(); break;
		case 'C':	complexElement->negate(); break;
	}
}
void KElement::inverse(){
	switch(elementType) {
		case 'S':	scalarElement->inverse(); break;
		case 'C':	complexElement->inverse(); break;
	}
}
void KElement::sine(int unit=0){
	switch(elementType) {
		case 'S':	scalarElement->sine(unit);
		case 'C':	complexElement->sine(unit);
	}
}
void KElement::cosine(int unit=0){
	switch(elementType) {
		case 'S':	scalarElement->cosine(unit);
		case 'C':	complexElement->cosine(unit);
	}
}
void KElement::tangent(int unit=0){
	switch(elementType) {
		case 'S':	scalarElement->tangent(unit);
		case 'C':	complexElement->tangent(unit);
	}
}
void KElement::hypSine(){
	switch(elementType) {
		case 'S':	scalarElement->hypSine(); break;
		case 'C':	complexElement->hypSine(); break;
	}
}
void KElement::hypCosine(){
	switch(elementType) {
		case 'S':	scalarElement->hypCosine(); break;
		case 'C':	complexElement->hypCosine(); break;
	}
}
void KElement::hypTangent(){
	switch(elementType) {
		case 'S':	scalarElement->hypTangent(); break;
		case 'C':	complexElement->hypTangent(); break;
	}
}
void KElement::arcsine(int unit=0){
	switch(elementType) {
		case 'S':	scalarElement->arcsine(unit);
		case 'C':	complexElement->arcsine(unit);
	}
}
void KElement::arccosine(int unit=0){
	switch(elementType) {
		case 'S':	scalarElement->arccosine(unit);
		case 'C':	complexElement->arccosine(unit);
	}
}
void KElement::arctangent(int unit=0){
	switch(elementType) {
		case 'S':	scalarElement->arctangent(unit);
		case 'C':	complexElement->arctangent(unit);
	}
}
void KElement::hypArcsine(){
	switch(elementType) {
		case 'S':	scalarElement->hypArcsine(); break;
		case 'C':	complexElement->hypArcsine(); break;
	}
}
void KElement::hypArccosine(){
	switch(elementType) {
		case 'S':	scalarElement->hypArccosine(); break;
		case 'C':	complexElement->hypArccosine(); break;
	}
}
void KElement::hypArctangent(){
	switch(elementType) {
		case 'S':	scalarElement->hypArctangent(); break;
		case 'C':	complexElement->hypArctangent(); break;
	}
}
void KElement::ln(){
	switch(elementType) {
		case 'S':	scalarElement->ln(); break;
		case 'C':	complexElement->ln(); break;
	}
}
void KElement::log10(){
	switch(elementType) {
		case 'S':	scalarElement->log10(); break;
		case 'C':	complexElement->log10(); break;
	}
}
void KElement::e2X(){
	switch(elementType) {
		case 'S':	scalarElement->e2X(); break;
		case 'C':	complexElement->e2X(); break;
	}
}
void KElement::ten2X(){
	switch(elementType) {
		case 'S':	scalarElement->ten2X(); break;
		case 'C':	complexElement->ten2X(); break;
	}
}
void KElement::factorial(){
	switch(elementType) {
		case 'S':	scalarElement->factorial(); break;
		case 'C':	complexElement->factorial(); break;
	}
}
void KElement::compliment(){
	switch(elementType) {
		case 'S':	scalarElement->compliment(); break;
		case 'C':	complexElement->compliment(); break;
	}
}
