/*
 Copyright (C) 1999, Mark W J Redding <grawlfang@tesco.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

EXEC SQL BEGIN DECLARE SECTION;

BASED_ON stars.bs_catalog bs_cat;
BASED_ON stars.name name;
BASED_ON stars.short_constellation con;
BASED_ON stars.hd_catalog hd_cat;
BASED_ON stars.ads_catalog ads_cat;
BASED_ON stars.varid varid;
BASED_ON stars.ra_hour ra_h;
BASED_ON stars.ra_minute ra_m;
BASED_ON stars.ra_second ra_s;
BASED_ON stars.right_ascension ra;
BASED_ON stars.dec_degree dec_d;
BASED_ON stars.dec_minute dec_m;
BASED_ON stars.dec_second dec_s;
BASED_ON stars.declination dec;
BASED_ON stars.visual_magnitude vis_mag;
BASED_ON stars.bv_magnitide bv_mag;
BASED_ON stars.spectrum spec;

BASED_ON stars.right_ascension min_ra,max_ra;
BASED_ON stars.declination min_dec,max_dec;

BASED_ON stars.right_ascension from_ra,to_ra;
BASED_ON stars.declination from_dec,to_dec;

BASED_ON constellations.constellation constellation;

EXEC SQL END DECLARE SECTION;


EXEC SQL DECLARE MAG_STARS CURSOR FOR
		SELECT	BS_CATALOG,
			NAME,
			SHORT_CONSTELLATION,
			HD_CATALOG,
			ADS_CATALOG,
			VARID,
			RA_HOUR,
			RA_MINUTE,
			RA_SECOND,
			RIGHT_ASCENSION,
			DEC_DEGREE,
			DEC_MINUTE,
			DEC_SECOND,
			DECLINATION,
			VISUAL_MAGNITUDE,
			BV_MAGNITIDE,
			SPECTRUM
		FROM STARS
		WHERE VISUAL_MAGNITUDE < :vis_mag
		ORDER BY BS_CATALOG;

EXEC SQL DECLARE FIND_STAR CURSOR FOR
		SELECT	BS_CATALOG,
			NAME,
			SHORT_CONSTELLATION,
			HD_CATALOG,
			ADS_CATALOG,
			VARID,
			RA_HOUR,
			RA_MINUTE,
			RA_SECOND,
			RIGHT_ASCENSION,
			DEC_DEGREE,
			DEC_MINUTE,
			DEC_SECOND,
			DECLINATION,
			VISUAL_MAGNITUDE,
			BV_MAGNITIDE,
			SPECTRUM
		FROM STARS
		WHERE VISUAL_MAGNITUDE < :vis_mag
		  AND ( RIGHT_ASCENSION > :min_ra
		  AND   RIGHT_ASCENSION < :max_ra )
		  AND ( DECLINATION > :min_dec
		  AND   DECLINATION < :max_dec )
		ORDER BY BS_CATALOG;


EXEC SQL DECLARE OUTLINE_STARS CURSOR FOR
	SELECT CONNECT_FROM,CONNECT_TO
	FROM CONSTELLATION_OUTLINES
	ORDER BY CONNECT_FROM;


int OpenStars(double mag)
{
	vis_mag=mag;

	EXEC SQL OPEN MAG_STARS;
	return(SQLCODE);
}

int FetchStars()
{
	EXEC SQL FETCH MAG_STARS
			INTO	:bs_cat,
				:name,
				:con,
				:hd_cat,
				:ads_cat,
				:varid,
				:ra_h,
				:ra_m,
				:ra_s,
				:ra,
				:dec_d,
				:dec_m,
				:dec_s,
				:dec,
				:vis_mag,
				:bv_mag,
				:spec;
	return(SQLCODE);
}

int CloseStars()
{
	EXEC SQL CLOSE MAG_STARS;
	return(SQLCODE);
}

BASED_ON stars.bs_catalog getBSCatalog()
{
	return(bs_cat);
}

char *getName()
{
	return(name);
}

char *getShortConst() 
{
	return(con);
}

BASED_ON stars.hd_catalog getHDCatalog()
{
	return(hd_cat);
}

BASED_ON stars.ads_catalog getADSCatalog()
{
	return(ads_cat);
}

char *getVarID()
{
	return(varid);
}

BASED_ON stars.ra_hour getRAhour()
{
	return(ra_h);
}

BASED_ON stars.ra_minute getRAminute()
{
	return(ra_m);
}

BASED_ON stars.ra_second getRAsecond()
{
	return(ra_s);
}

BASED_ON stars.right_ascension getRA()
{
	return(ra);
}

BASED_ON stars.dec_degree getDECdegree()
{
	return(dec_d);
}

BASED_ON stars.dec_minute getDECminute()
{
	return(dec_m);
}

BASED_ON stars.dec_second getDECsecond()
{
	return(dec_s);
}

BASED_ON stars.declination getDeclination()
{
	return(dec);
}

BASED_ON stars.visual_magnitude getVMagnitude()
{
	return(vis_mag);
}

BASED_ON stars.bv_magnitide getBVMagnitude()
{
	return(bv_mag);
}

char *getSpectrum()
{
	return(spec);
}

int getStarCount(double mag)
{
int count;

	EXEC SQL SELECT COUNT(*)
			INTO :count
			FROM STARS
			WHERE VISUAL_MAGNITUDE < :mag;
	return(count);
}

int OpenFind(double ra, double dec, double mag, double range)
{
	vis_mag=mag;
	min_ra=ra*15.0-range;
	max_ra=ra*15.0+range;
	min_dec=dec-range;
	max_dec=dec+range;

	EXEC SQL OPEN FIND_STAR;
	return(SQLCODE);
}

int FetchFind()
{
	EXEC SQL FETCH FIND_STAR
			INTO	:bs_cat,
				:name,
				:con,
				:hd_cat,
				:ads_cat,
				:varid,
				:ra_h,
				:ra_m,
				:ra_s,
				:ra,
				:dec_d,
				:dec_m,
				:dec_s,
				:dec,
				:vis_mag,
				:bv_mag,
				:spec;
	return(SQLCODE);
}

int CloseFind()
{
	EXEC SQL CLOSE FIND_STAR;
	return(SQLCODE);
}

char *getConstellation(char *scon)
{
	EXEC SQL SELECT CONSTELLATION
		INTO :constellation
		FROM CONSTELLATIONS
		WHERE SHORT_CONSTELLATION = :scon;
	if(SQLCODE)
		return(scon);
	else
		return(constellation);
}

int ConnectStars(long bs1 , long bs2)
{
	EXEC SQL INSERT INTO CONSTELLATION_OUTLINES
		(CONNECT_FROM,CONNECT_TO)
		VALUES
		(:bs1,:bs2);
	if(!SQLCODE)
	{
		EXEC SQL COMMIT;
	}
	return(SQLCODE);
}

int UnconnectStars(long bs1, long bs2)
{
	EXEC SQL DELETE FROM CONSTELLATION_OUTLINES
		WHERE CONNECT_FROM = :bs1
		  AND CONNECT_TO = :bs2;
	if(!SQLCODE)
	{
		EXEC SQL COMMIT;
	}
	return(SQLCODE);
}

int OpenOutlines()
{
	EXEC SQL OPEN OUTLINE_STARS;
	return(SQLCODE);
}

int FetchOutlines(double *ra1, double *dec1, double *ra2, double *dec2)
{
long bs1,bs2;

	EXEC SQL FETCH OUTLINE_STARS
		INTO	:bs1,
			:bs2;
	if(!SQLCODE)
	{
		EXEC SQL SELECT RIGHT_ASCENSION,DECLINATION
			INTO :from_ra,:from_dec
			FROM STARS
			WHERE BS_CATALOG = :bs1;
		EXEC SQL SELECT RIGHT_ASCENSION,DECLINATION
			INTO :to_ra,:to_dec
			FROM STARS
			WHERE BS_CATALOG = :bs2;
	}
	if(!SQLCODE)
	{
		*ra1=from_ra;
		*dec1=from_dec;
		*ra2=to_ra;
		*dec2=to_dec;
	}
	return(SQLCODE);
}

int CloseOutlines()
{
	EXEC SQL CLOSE OUTLINE_STARS
	return(SQLCODE);
}

