/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#include <header.hxx>
#include <t_t1_dl.hxx>


void  t_vecinos(Vertice_T1* so, Triangulo_T1_dlist& lista) {
   Triangulo_T1_dlink* aux;
   Triangulo_T1* tr_ini,*tr,*tr_aux;
   int sent=1;
   Boolean recorrido=FALSE;
   aux=new Triangulo_T1_dlink;
   if (aux==NIL) ERROR();
   tr_ini=so->t;
   aux->set(tr_ini,NIL,NIL);
   lista.append(aux);
   tr_aux=tr_ini;
   do {
     tr=tr_aux->vecino(so,sent);
     if (tr==tr_ini) {
          recorrido=TRUE;
     }
     else {
       if (tr) {
          aux=new Triangulo_T1_dlink;
          if (aux==NIL) ERROR();
          aux->set(tr,NIL,NIL);
          if (sent==1) 
              lista.insert(aux);
          else
              lista.append(aux);
          tr_aux=tr;
      }
       else {
         if (sent==1) {
              sent=-1;
              tr_aux=tr_ini;
         }
         else {
            recorrido=TRUE;      
         }
       }
     }  
   } while (recorrido==FALSE);    
 }
