/*
 * ADAPT2D : a software for automatic mesh adaptation in 2D
 *
 * AUTHOR : Manuel J. Castro Diaz(e-mail:castro@gamba.cie.uma.es)
 * ADAPTED FOR FREEFEM : Prud'homme Christophe (e-mail:prudhomm@ann.jussieu.fr) 
 *
 * this code is public domain
 * 
 * You may copy freely these files and use it for    
 * teaching or research. These or part of these may   
 * not be sold or used for a commercial purpose without
 * our consent
 * 
 * Any problems should be reported to the AUTHOR
 * at the following address : castro@gamba.cie.uma.es
 */


#ifndef _aristaT1dlist_c
#define _aristaT1dlist_c

#include <a_t1_dl.hxx>
#include <at1_l.hxx>
#include <front_t1.hxx>

void Arista_T1_dlist::write (ostream& os) {
  int num=0;
  num=this->num_elem();
  Arista_T1_dlink* aux;
  aux=begin;
  os <<endl<< "Numero de Aristas"<<num<<endl;
  os << endl
     << "       ***** Aristas *****"<<endl
     << "             --------"<<endl;
  
  while (aux) {
    os <<aux<<" "<<(*(aux->a))<<endl;
    aux=aux->suc;
  }
}
ostream& operator<<(ostream& os, Arista_T1_dlist& rrl)
{rrl.write(os); return os;}

/*  ---------------------------------------------------------------------
                     SUBRRUTINA   FRONTERA 
                     
        Proposito: Obtener todas las aristas de la frontera de un mallado 
        ---------  del tipo Mallado_T1 y ordenarlas para recorrerlas
                   en el sentido positivo de la frontera. La frontera
                   puede tener distintas componentes conexas.

       Entrada:    El mallado base apuntado por this.
       -------

       Salida:     Aristas ordenadas unas detras de otras segun el
       ------      sentido positivo. Cada componente conexa estara
                   formada por una lista de aristas.
*/

Frontera_T1*  Arista_T1_dlist::crea_frontera() {
  
  Frontera_T1* frontera;
  FraristaT1_link* comp_conex;
  AristaT1_list* arete_list;
  AristaT1_link* arete;
  Arista_T1_dlink* La_lk;
  Arista_T1* a0;
  
  frontera=new Frontera_T1;
  if (frontera==NIL) ERROR();
  La_lk=begin;
  while (La_lk) {
    a0=La_lk->a;
    if (a0->front==TRUE) {    // la arista esta en la frontera
      arete=new AristaT1_link;
      if (arete==NIL) ERROR();
      arete->set(a0,NIL);
      
      arete_list=new AristaT1_list;
      if (arete_list==NIL) ERROR();
      arete_list->append(arete);
      
      comp_conex=new FraristaT1_link;
      if (comp_conex==NIL) ERROR();
      comp_conex->set(arete_list,NIL,NIL);
      
      frontera->append(comp_conex);
      frontera->testeo();
    }
    La_lk=La_lk->sig();
  }
  return frontera;
}
#endif
