/***************************************************************************
                          bdoclst.cpp  -  description
                             -------------------
    begin                : Mon Jan 3 2000
    copyright            : (C) 2000 by Hans-Jrgen Schumann
    email                : hans@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#include <iostream.h>
// include files for QT
#include <qstring.h>
#include <qdir.h>
#include <qfileinf.h>

// include files for KDE
#include <kapp.h>
#include <klocale.h>

// application specific includes
#include "bdoclst.h"
#include "bitana.h"

BDocLst::BDocLst(QWidget *parent, const char *name ) : QListView(parent,name) {

	addColumn(i18n("results"));
  // groups
	rgr.append(new QListViewItem(this, i18n("Text/Gematria"),"abb dar aus"));
	rgr.append(new QListViewItem(this, i18n("ELS"),"ana int"));
	rgr.append(new QListViewItem(this, i18n("Neighbour"), "nbr"));
  rgr.append(new QListViewItem(this, i18n("Dictionary"), "lex"));
	setRootIsDecorated(true);

	rfi.setAutoDelete(true);
	rfi.clear();
}

int BDocLst::resultList() {
  extern BitanaApp *bitana;
	QDir rd;
	QFileInfo *rf;
	QString grlist;
  int gpos;
	int numfil = 0;
	QListViewItem *group;
	rfi.clear();
	rd.setPath(bitana->getTmpDir());
	const QFileInfoList *list = rd.entryInfoList("*");
  QFileInfoListIterator it(*list);
	
	group = rgr.first();
	while (group != NULL) {
		grlist = group->text(1);
    while (!grlist.isEmpty()) {
	  	gpos = grlist.find(' ');
			if (gpos > 0) {
				list = rd.entryInfoList(grlist.left(gpos)+ "*.lst");
				grlist.remove(0, gpos + 1);
			}
			else {
				list = rd.entryInfoList(grlist + "*.lst");
				grlist.remove(0, grlist.length());
      }
			it = *list;	
      while ((rf = it.current()) != 0) {
				rfi.append(new QListViewItem(rgr.current(), rf->baseName(), rf->fileName()));
				++numfil;
		    ++it;
  		}
		}			 	
 		group = rgr.next();
	}
  return(numfil);
}

QListViewItem *BDocLst::itemFile(QString file) {	

 rfi.first();
	do
		if ((rfi.current()->text(1)) == file) return (rfi.current());
  while (rfi.next() != NULL);
	return(NULL);
}	


BDocLst::~BDocLst(){
}

