/**************************************************************************
 * $Id: edit.cpp 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "edit.h"

#include <samplin.h>
#include <qkeycode.h>

#include "edit.moc"

Edit::Edit ( QWidget* parent, const char* name )
:QMultiLineEdit( parent, name )
{
clearTableFlags(Tbl_smoothScrolling);
setFont(QFont("courier"));
}

void Edit::init(void)
{
   clearTableFlags(Tbl_smoothScrolling);
   
}


Edit::~Edit()
{
}

void Edit::insertAtEnd(const char *text)
{
   QString str;
   int lines;

   setAutoUpdate(FALSE);
   lines=numLines();
   str=textLine(lines-1);
   str+=text;
   removeLine(lines-1);
   insertLine(str);

   end();
   setYOffset(MAX(0,totalHeight()-height()+2));
   setAutoUpdate(TRUE);
   repaint();
   //   update();
   //   setTopCell(MAX(0,100 /*numRows()*/ /*-height()/cellHeight()*/));
   
//   update();
}

void Edit::keyPressEvent ( QKeyEvent *e)
{
   
   
   if (e->key() == Key_Insert){
      this->setOverwriteMode(!this->isOverwriteMode());
      emit toggleOverwrite_signal();
      return;
   }

   QMultiLineEdit::keyPressEvent(e);
      
   emit cursorPosition_signal();

}

void Edit::mousePressEvent (QMouseEvent* e){
   
   
   QMultiLineEdit::mousePressEvent(e);
   emit cursorPosition_signal();
   
}

void Edit::mouseMoveEvent (QMouseEvent* e)
{
   
   QMultiLineEdit::mouseMoveEvent(e);
   emit cursorPosition_signal();
   
   
}
   
void Edit::mouseReleaseEvent (QMouseEvent* e){   
   
   
   QMultiLineEdit::mouseReleaseEvent(e);
   emit cursorPosition_signal();
   
}

   
