/**************************************************************************
 * $Id: scriptdlg.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef ScriptDlg_included
#define ScriptDlg_included

#include<stdio.h>
#include<stdlib.h>
#include <qlabel.h>
#include <qdialog.h>
#include <qpushbt.h>
#include <qchkbox.h>
#include <qtimer.h>
//#include <qlcdnum.h>
#include <qpainter.h>
#include <qcombo.h>
//#include <kledlamp.h>
#include <qframe.h>
#include <qlined.h>
#include "scriptlcd.h"
#include "script_all.h"
#include "qwt_thermo.h"
#include "qwt_knob.h"
#include "qwt_slider.h"

class ScriptDlg : public QDialog
{
    Q_OBJECT

public:

    ScriptDlg
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

   virtual ~ScriptDlg();

   void setDlgItem(dlgitem *item){dlg=item;}
   
 protected:
   void closeEvent(QCloseEvent *);
   
public slots:

protected slots:

protected:
   dlgitem *dlg;
   
//   signals:
//   void widgetSignal(int type, char *label);
   
};

class ScriptPushButton : public QPushButton
{
    Q_OBJECT

public:

    ScriptPushButton
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

   virtual ~ScriptPushButton();

   void setWidget(widgetitem *w){widget=w;}
   
public slots:


protected slots:
   void clickedSlot();

protected:
   widgetitem *widget;
   
   signals:
   void widgetSignal(widgetitem *w);
   
};

class ScriptCheckBox : public QCheckBox
{
    Q_OBJECT

public:

    ScriptCheckBox
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

   virtual ~ScriptCheckBox();

   void setValue(double *v){value=v;}   
   void setWidget(widgetitem *w){widget=w;}
 public slots:


protected slots:
   void toggledSlot(bool);
   void clickedSlot();
   void timerSlot();
protected:
   double *value;   
   QTimer *timer;
   widgetitem *widget;
   
   signals:
   void widgetSignal(widgetitem *);
   
};


class ScriptLevel : public QwtThermo
{
    Q_OBJECT

public:

    ScriptLevel
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

   virtual ~ScriptLevel();

   void setVariable(double *v){val=v;}   
 public slots:


protected slots:
   void timerSlot();
protected:
   double *val;   
   QTimer *timer;
   
};

class ScriptKnob : public QwtKnob
{
    Q_OBJECT
public:
    ScriptKnob
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

   virtual ~ScriptKnob();

   void setVariable(double *v){var=v;}   
   void setWidget(widgetitem *w){widget=w;}
 public slots:


protected slots:
   void changedSlot(double);
   void timerSlot();
protected:
   double *var;   
   QTimer *timer;
   widgetitem *widget;
   
   signals:
   void widgetSignal(widgetitem *);
   
};

class ScriptSlider : public QwtSlider
{
    Q_OBJECT
public:
    ScriptSlider
     (
     QWidget* parent = NULL,
     const char* name = NULL,
     Orientation orient = Horizontal,
     ScalePos scalePos = None
      );

   virtual ~ScriptSlider();

   void setVariable(double *v){var=v;}   
   void setWidget(widgetitem *w){widget=w;}
 public slots:


protected slots:
   void changedSlot(double);
   void timerSlot();
protected:
   double *var;   
   QTimer *timer;
   widgetitem *widget;
   
   signals:
   void widgetSignal(widgetitem *);
   
};


/*
class ScriptLED : public KLedLamp
{
    Q_OBJECT

public:

    ScriptLED
    (
        QWidget* parent = NULL
    );

   virtual ~ScriptLED();

   void setValue(double *v){value=v;}   

 public slots:


protected slots:
   void timerSlot();
   
protected:
   double *value;   
   QTimer *timer;
   signals:
   
};
*/



class ScriptLCD : public LCDisplay
{
    Q_OBJECT

public:

    ScriptLCD
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

   virtual ~ScriptLCD();

   void setValue(double *v){val=v;}   
 public slots:


protected slots:
   void timerSlot();
protected:
   double *val;   
   QTimer *timer;
   
   signals:
};



class ScriptLED : public QFrame
{
  Q_OBJECT
public:
   ScriptLED(QWidget *parent=0);
   enum State { On, Off };
   State state() const { return s; }
   void setState(State state) { s= state; paintEvent(0); }
   void toggleState() { if (s == On) s= Off; else if (s == Off) s= On; paintEvent(0); }
   void setValue(double *v){value=v;}   
   virtual ~ScriptLED();
   void setText(const char *s){text=s;}
   void setColor(const char *c){color=QColor(c);}
   
 public slots:
   void toggle() { toggleState(); };
   void on() { setState(On); };
   void off() { setState(Off); };
 
 protected:
   void drawContents(QPainter *);
 
 private:
   const int lwidth;
   const int lheight;
   const int dx;
   State s;

 protected slots:
   void timerSlot();
   
 protected:
   double *value;   
   QTimer *timer;
   QColor color;
   QString text;
   signals:
   
};

class ScriptComboBox : public QComboBox
{
    Q_OBJECT

public:

    ScriptComboBox
    (
        bool, QWidget* parent = NULL,
        const char* name = NULL
    );

   virtual ~ScriptComboBox();

   void setValue(double *v){value=v;}   
   void setWidget(widgetitem *w){widget=w;}
 public slots:


protected slots:
   void selectedSlot(int);
   void timerSlot();
protected:
   double *value;   
   QTimer *timer;
   widgetitem *widget;
   
   signals:
   void widgetSignal(widgetitem *);
   
};

class ScriptLineEdit : public QLineEdit
{
    Q_OBJECT

public:

    ScriptLineEdit
     (
      QWidget* parent = NULL,
      const char* name = NULL
      );

   virtual ~ScriptLineEdit();

   void setPointer(char **p){pointer=p;}   
   void setWidget(widgetitem *w){widget=w;}
 public slots:


protected slots:
   void changedSlot(const char *);
   void timerSlot();
protected:
   char **pointer;   
   QTimer *timer;
   widgetitem *widget;
   
   signals:
   void widgetSignal(widgetitem *);
   
};

class ScriptLabel : public QLabel
{
    Q_OBJECT

public:

    ScriptLabel
     (
      QWidget* parent = NULL,
      const char* name = NULL
      );

   virtual ~ScriptLabel();

   void setPointer(char **p){pointer=p;}   
   void setWidget(widgetitem *w){widget=w;}
 public slots:


protected slots:
   void timerSlot();
protected:
   char **pointer;   
   QTimer *timer;
   widgetitem *widget;
   
   
};

#endif // scriptdlg_included
