%name SamplinScanner
%{

/**************************************************************************
 * $Id: script.flex.l 1.2 Thu, 18 Feb 1999 16:48:37 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include <string.h>

#include "script_all.h"     /* definitions of yabasic */

%}
%header{
#include "script.bison.h"
%}

%define CONSTRUCTOR_CODE parent=ptr;
%define CONSTRUCTOR_PARAM SamplinParser *ptr
%define LEX_PARAM YY_SamplinParser_STYPE *val
%define MEMBERS \
public: \
void switch_to_my_file(FILE *inputfile); /* switches lex input to given file */ \
char *replace(char *string); /* replace \n,\a, etc. */ \
int yylineno; \
SamplinParser *parent; \

NAME [A-Za-z][_A-za-z0-9]*
%x RET

%%
[ \t]* {BEGIN INITIAL;}     /* ignore whitespace */
<RET>[ \t]* {BEGIN INITIAL;} /* still ignore whitespace */

<<EOF>> {return SamplinParser::EOFILE;}
<RET>\n {++yylineno; return SamplinParser::SEP;} /* added ++yylineno */
<RET>[^\n] {BEGIN INITIAL;unput(yytext[0]);}
\n {yylineno++; BEGIN RET; return SamplinParser::SEP;}
: {return SamplinParser::SEP;}

REM.*\n {yylineno++; return SamplinParser::SEP;}  /* comments span 'til end of line */
^#.*\n {yylineno++; return SamplinParser::SEP;} /* '#' can introduce comments too */
REM.* {yylineno++; return SamplinParser::SEP;}  /* comments at end of file */
^#.* {yylineno++; return SamplinParser::SEP;} /* comments at end of file */

FOR return SamplinParser::FOR;
TO return SamplinParser::TO;
STEP return SamplinParser::STEP;
NEXT return SamplinParser::NEXT;
GOTO return SamplinParser::GOTO;
GOSUB return SamplinParser::GOSUB;
ON return SamplinParser::ON;
LABEL return SamplinParser::LABEL;
IF return SamplinParser::IF;
THEN return SamplinParser::THEN;
ELSE return SamplinParser::ELSE;
ENDIF return SamplinParser::ENDIF;
FI return SamplinParser::ENDIF;
OPEN return SamplinParser::OPEN;
CLOSE return SamplinParser::CLOSE;
PRINT return SamplinParser::PRINT;
\? return SamplinParser::PRINT;
INPUT return SamplinParser::INPUT;
RETURN return SamplinParser::RETURN;
DIM return SamplinParser::DIM;
END return SamplinParser::END;
READ return SamplinParser::READ;
DATA return SamplinParser::DATA;
RESTORE return SamplinParser::RESTORE;
AND return SamplinParser::AND;
OR return SamplinParser::OR;
NOT return SamplinParser::NOT;
WAIT return SamplinParser::WAIT;
PAUSE return SamplinParser::WAIT;
BELL return SamplinParser::BELL;
BEEP return SamplinParser::BELL;

SIN return SamplinParser::SIN;
ASIN return SamplinParser::ASIN;
COS return SamplinParser::COS;
ACOS return SamplinParser::ACOS;
TAN return SamplinParser::TAN;
ATAN return SamplinParser::ATAN;
EXP return SamplinParser::EXP;
LOG return SamplinParser::LOG;
SQRT return SamplinParser::SQRT;
INT return SamplinParser::INT;
FRAC return SamplinParser::FRAC;
RAN return SamplinParser::RAN;
"LEFT$" return SamplinParser::LEFT_;
"RIGHT$" return SamplinParser::RIGHT_;
"MID$" return SamplinParser::MID;
LEN return SamplinParser::LEN;
VAL return SamplinParser::VAL;
"STR$" return SamplinParser::STR;
"CHR$" return SamplinParser::CHR;
"INKEY$" return SamplinParser::INKEY;
ASC return SamplinParser::ASC;

DEVOPEN return SamplinParser::DEVOPEN;
DEVCLOSE return SamplinParser::DEVCLOSE;
DEVREAD return SamplinParser::DEVRD;
DEVWRITE return SamplinParser::DEVWR;
DEVCTL return SamplinParser::DEVCTL;
DEVSPOLL return SamplinParser::DEVSPOLL;
MESSAGE return SamplinParser::MESSAGE;
INFO return SamplinParser::M_INFO;
WARNING return SamplinParser::M_WARNING;
ERROR return SamplinParser::M_ERROR;
SLEEP return SamplinParser::SLEEP;

ADDPLOT return SamplinParser::ADDPLOT;
SETPLOTAXES return SamplinParser::SETPLOTAXES;
SETPLOTSTYLE return SamplinParser::SETPLOTSTYLE;
SETPLOTPEN return SamplinParser::SETPLOTPEN;
SETPLOTSYMBOL return SamplinParser::SETPLOTSYMBOL;
SETPLOTDATA return SamplinParser::SETPLOTDATA;
GETPLOTDATA return SamplinParser::GETPLOTDATA;
DELPLOT return SamplinParser::DELPLOT;
SETAXISTITLE return SamplinParser::SETAXISTITLE;
SETAXISFLAGS return SamplinParser::SETAXISFLAGS;
SETAXISSCALE return SamplinParser::SETAXISSCALE;
SETAXISSTYLE return SamplinParser::SETAXISSTYLE;
AUTO return SamplinParser::AUTO;
SYM return SamplinParser::SYM;
INV return SamplinParser::INV;
REF return SamplinParser::REF;
FLT return SamplinParser::FLT;

%LEFT return SamplinParser::LEFT;
%RIGHT return SamplinParser::RIGHT;
%TOP return SamplinParser::TOP;
%BOTTOM return SamplinParser::BOTTOM;

%ADDXPLOT return SamplinParser::ADDXPLOT;
%ADDYPLOT return SamplinParser::ADDYPLOT;
%ADDXYPLOT return SamplinParser::ADDXYPLOT;
%UPDATEXPLOT return SamplinParser::UPDATEXPLOT;
%UPDATEYPLOT return SamplinParser::UPDATEYPLOT;
%UPDATEXYPLOT return SamplinParser::UPDATEXYPLOT;
%DELPLOT return SamplinParser::DELPLOT;
%TITLEGRAPH return SamplinParser::TITLEGRAPH;

SETGRAPHCOLORS return SamplinParser::SETGRAPHCOLORS;
SETGRAPHTITLE return SamplinParser::SETGRAPHTITLE;
SETGRAPHCOMMENT return SamplinParser::SETGRAPHCOMMENT;
SETGRAPHLEGEND return SamplinParser::SETGRAPHLEGEND;
ADDGRAPH return SamplinParser::ADDGRAPH;
DELGRAPH return SamplinParser::DELGRAPH;
SAVEGRAPH return SamplinParser::SAVEGRAPH;
LOADGRAPH return SamplinParser::LOADGRAPH;
EXPORTGRAPH return SamplinParser::EXPORTGRAPH;
PRINTGRAPH return SamplinParser::PRINTGRAPH;

ADDDLG return SamplinParser::ADDDLG;
DELDLG return SamplinParser::DELDLG;
HIDEDLG return SamplinParser::HIDEDLG;
SHOWDLG return SamplinParser::SHOWDLG;
DLGACTIVE return SamplinParser::DLGACTIVE;
PROGRESSDLG return SamplinParser::PROGRESSDLG;
ADDWIDGET return SamplinParser::ADDWIDGET;
TEXT return SamplinParser::TEXT;
BUTTON return SamplinParser::BUTTON;
SWITCH return SamplinParser::SWITCH;
LCD return SamplinParser::LCD;
LED return SamplinParser::LED;
FRAME return SamplinParser::FRAME;
SELECT return SamplinParser::SELECT;
WHEEL return SamplinParser::WHEEL;
GRAPH return SamplinParser::GRAPH;
KNOB return SamplinParser::KNOB;
LEVEL return SamplinParser::LEVEL;
SLIDER return SamplinParser::SLIDER;

MULTI return SamplinParser::MULTI;
OFF return SamplinParser::OFF;
IDLE return SamplinParser::IDLE;

DEVREADY return SamplinParser::DEVREADY;
CURSOR return SamplinParser::CURSOR;
DEFAULT return SamplinParser::DEFAULT;

TIMER return SamplinParser::TIMER;
"DATE$" return SamplinParser::DATE;
"TIME$" return SamplinParser::TIME;

"<>" return SamplinParser::NE;
"<=" return SamplinParser::LE;
">=" return SamplinParser::GE;
"=" return SamplinParser::EQ;
"<" return SamplinParser::LT;
">" return SamplinParser::GT;

[-+*/:(),.;] {return yytext[0];}

(([0-9]+|([0-9]*\.[0-9]*))([eE][-+]?[0-9]+)?) {
  {float f;
  sscanf(yytext,"%f",&f);
  val->number=f;
  return SamplinParser::DECNUMBER;}
}

("0x"[0-9a-f]*) {
  {unsigned long f;
  sscanf(yytext,"%lx",&f);
  val->number=(float)f;
  return SamplinParser::HEXNUMBER;}
}

({NAME}+) {
  val->symbol=(char *)strdup(yytext);
  return SamplinParser::SYMBOL;
}

  /* Symbols with a trailing $-sign are treated special */
({NAME}+"$") {
  val->strsym=(char *)strdup(yytext);
  return SamplinParser::STRSYM;
}

({NAME}+"[]") {
  val->strsym=(char *)strdup(yytext);
  *(val->strsym+strlen(val->strsym)-2)=0;
  return SamplinParser::ARRAYSYM;
}

({NAME}+"$[]") {
  val->strsym=(char *)strdup(yytext);
  *(val->strsym+strlen(val->strsym)-2)=0;
  return SamplinParser::ARRAYSTRSYM;
}

\"([^\"\n]|"\\\"")*\" {
  val->string=(char *)strdup(yytext+1);
  *(val->string+yyleng-2)='\0';
  replace(val->string);
  return SamplinParser::STRING;
}

\"([^\"\n]|"\\\"")*\n {
  if(parent!=NULL)parent->error(ERROR,"String not terminated");
  else fprintf(stderr,"String not terminated\n");
  val->string=(char *)strdup(yytext);
  yylineno++;
  return SamplinParser::STRING;
}

. {return yytext[0];}

%%

void SamplinScanner::switch_to_my_file(FILE *inputfile) /* switches lex input to given file */
{
  YY_BUFFER_STATE my_buffer;

  my_buffer=yy_create_buffer(inputfile,YY_BUF_SIZE);
  yy_switch_to_buffer(my_buffer);
  
  return;
}

char * SamplinScanner::replace(char *string) /* replace \n,\a, etc. */
{
   char *from,*to;
   
   from=to=string;
   while(*from) {
      if (*from=='\\') {
	 from++;
	 switch(*from) {
	  case 'n': *to='\n';break;
	  case 't':     *to='\t';break;
	  case 'v':     *to='\v';break;
	  case 'b':     *to='\b';break;
	  case 'r':     *to='\r';break;
	  case 'f':     *to='\f';break;
	  case 'a':     *to='\a';break;
	  case '\\': *to='\\';break;
	  case '\?': *to='\?';break;
	  case '\'': *to='\'';break;
	  case '\"': *to='\"';break;
	  default:
	    *to='\\';
	    to++;
	    *to=*from;
	 }
      }
      else
	*to=*from;
      from++;
      to++;
   }
   *to='\0';
   return string;
}
