/* newakt.cpp - kurse der aktien aktualisieren
 *
 * Andreas Wst
 *
 */


#include "newakt.moc"

NewAkt::NewAkt( QWidget *parent, const char *name, int anz, Stock *stock [] )
                : QDialog ( parent, name, TRUE), anzahl (anz)

{
  setCaption ("Current Prices");

  gbox = new QGroupBox ("Update prices", this, "gbox" );
  gbox->setGeometry( 10, 10, 780, 95 + 30 * (anzahl / 3) );
  gbox->setFrameStyle( 49 );

  for (int i = 0; i < anzahl; i++)
  {
    s [i] = stock [i];
    debug ("new akt : %s %f", s [i]->getName (), s [i]->getAktKurs ());


    QLabel *l = new QLabel( this, "linfo" );
    l->setGeometry( 15 + 270 * (i % 3), 50 + 30 * (i / 3), 135, 20 );
    l->setText(s [i]->getName ());
    l->setAlignment( 290 );
    l->setMargin( -1 );
    
    le [i] = new QLineEdit (this, "le");
    le [i]->setGeometry (170 + 270 * (i % 3), 50 + 30 * (i / 3), 60, 20);
    char st [10];
    sprintf (st, "%.2f", s [i]->getAktKurs ());
    le [i]->setText (st);
    le [i]->setMaxLength (8);
  }

  ok = new QPushButton ("OK", this, "ok" );
  ok->setGeometry( 710, 120 + 30 * (anzahl / 3), 70, 30 );
  connect (ok, SIGNAL (clicked ()), SLOT (okPressed ()));

  cancel = new QPushButton ("Cancel", this, "cancel" );
  cancel->setGeometry( 600, 120 + 30 * (anzahl / 3), 70, 30 );
  connect (cancel, SIGNAL (clicked ()), SLOT (reject ()));

  setMinimumSize (810, 160 + 30 * (anzahl / 3));
  setMaximumSize (810, 160 + 30 * (anzahl / 3));
}

NewAkt::~NewAkt()
{
}


void NewAkt::okPressed ()
{
  int i;
  double w [30];
  QString st;
  bool ok = TRUE;
  double wert;
  for (i = 0; i < anzahl; i++)
  {
    st = le [i]->text ();
    wert = st.toDouble (&ok);
    w [i] = wert;
  }


  if (ok == FALSE)
  {
    KMsgBox::message (this, "Error", "Input Error !");
    return;
  }

  debug ("vor set akt kurs");

  for (i = 0; i < anzahl; i++)
  {
    s [i]->setAktKurs (w [i]);
  }

  debug ("nach set akt kurs");
  accept ();
}
