/* merge.cpp
 *
 * Andreas Wst
 *
 */


#include "merge.moc"

Merge::Merge( QWidget *parent, const char *name, int anz, Stock *stock [] )
                : QDialog ( parent, name, TRUE)

{
  setCaption ("Merge stocks");

  lbox = new QListBox (this, "lbox" );
  lbox->setGeometry (10, 10, 270, 170 );
  lbox->setFrameStyle (51);
  lbox->setLineWidth (2);
  lbox->setMultiSelection (TRUE);

  for (int i = 0; i < anz; i++)
  {
    s [i] = stock [i];
    lbox->insertItem (s [i]->getName ());
  }

  ok = new QPushButton ("OK", this, "ok" );
  ok->setGeometry( 300, 10, 70, 30 );
  connect (ok, SIGNAL (clicked ()), SLOT (okPressed ()));

  cancel = new QPushButton ("Cancel", this, "cancel" );
  cancel->setGeometry( 300, 50, 70, 30 );
  connect (cancel, SIGNAL (clicked ()), SLOT (reject ()));
  

  setMinimumSize (390, 190);
  setMaximumSize (390, 190);
}

Merge::~Merge()
{
}


void Merge::okPressed ()
{
  int anz = 0;
  int index [30];
  for (unsigned int i = 0; i < lbox->count (); i++)
  {
    if (lbox->isSelected (i) == TRUE)
    {
      index [anz] = i;
      anz++;
      debug ("%d wurde gewhlt %s", i, s [i]->getName ());
    }
  }

  if (anz != 2)
  {
    KMsgBox::message (this, "Error", "You have to select two stocks !");
    return;
  }
  else
  {
    char st [256];
    sprintf (st, "You really want to merge \n%s with %s", 
             s [index [0]]->getName (),
             s [index [1]]->getName ());

    switch (QMessageBox::information (this, "Error", st, "&Cancel", "&Ok"))
    {
      case 0 : // cancel -> nix tun
               return;
               debug ("do nothing");
               break;
      case 1 : // ok -> mergen
               debug ("merge stocks");
               accept ();
               // im highbyte erste aktie, lowbyte zweite aktie               
               setResult ( ( ((index [0] << 8) + (index [1])) + 1) );
               break;
    }

  }
}
