
#ifndef __KSIAGTOOLBAR_H
#define __KSIAGTOOLBAR_H

/**
 * The toolbar recievers.
 */

#include <qobject.h>

#define ID_TB_NEW         0
#define ID_TB_OPEN        1
#define ID_TB_SAVE        2
#define ID_TB_PREVIEW     3
#define ID_TB_PRINT       4
#define ID_TB_PLOT        5
#define ID_TB_SIGMA       6
#define ID_TB_HELP        7
#define ID_TB_GNU         8
#define ID_TB_BORDER      9
#define ID_TB_GRID        10
#define ID_TB_ULINE       11
#define ID_TB_NOGRID      12
#define ID_TB_FWIZ        13
#define ID_TB_BOLD        14
#define ID_TB_ITALIC      15
#define ID_TB_LEFT        16
#define ID_TB_RIGHT       17
#define ID_TB_CENTER      18
#define ID_TB_FONT_COMBO  19
#define ID_TB_SIZE_COMBO  20
#define ID_TB_TYPE_COMBO  21
#define ID_TB_COLOR_COMBO 22
#define ID_TB_LINED       23
#define ID_TB_LABEL	  24
#define ID_TB_ENTER	  25
#define ID_TB_DUMP	  26
#define ID_TB_CUT	  27
#define ID_TB_COPY	  28
#define ID_TB_PASTE	  29

#define ID_FONT_COURIER    0
#define ID_FONT_HELVETICA  1
#define ID_FONT_SCHOOLBOOK 2
#define ID_FONT_TIMES      3

#define ID_SIZE_8  0
#define ID_SIZE_10 1
#define ID_SIZE_12 2
#define ID_SIZE_14 3
#define ID_SIZE_18 4
#define ID_SIZE_24 5
#define ID_SIZE_20 6
#define ID_SIZE_30 7

#define ID_TYPE_DEFAULT    0
#define ID_TYPE_INVISIBLE  1
#define ID_TYPE_INTEGER    2
#define ID_TYPE_SCIENTIFIC 3
#define ID_TYPE_FIXED      4
#define ID_TYPE_DATE       5
#define ID_TYPE_TIME       6
#define ID_TYPE_TIME_DIFF  7
#define ID_TYPE_PERCENT    8
#define ID_TYPE_HEX        9
#define ID_TYPE_CURRENCY   10
#define ID_TYPE_USER1      11
#define ID_TYPE_USER2      12
#define ID_TYPE_USER3      13
#define ID_TYPE_USER4      14
#define ID_TYPE_USER5      15

#define ID_COLOR_BLACK   0
#define ID_COLOR_RED     1
#define ID_COLOR_GREEN   2
#define ID_COLOR_BLUE    3
#define ID_COLOR_YELLOW  4
#define ID_COLOR_MAGENTA 5
#define ID_COLOR_CYAN    6
#define ID_COLOR_WHITE   7

#define ID_STATUS_TYPE 0
#define ID_STATUS_MSG  1


class KSiagToolBarReceiver : public QObject
{
    Q_OBJECT
        
public slots:
    void newFile();
    void open();
    void save();
    void preview();
    void print();
    void plot();
    void sigma();
    void info();
    void borders();
    void grid();
    void underline();
    void none();
    void fwizard();
    
    void cut();
    void copy();
    void paste();

    void bold();
    void italic();
    void leftJustify();
    void centerJustify();
    void rightJustify();
    void fontComboActivated (int i);
    void sizeComboActivated (int i);
    void typeComboActivated (int i);
    void colorComboActivated (int i);

    void lineAccept();
    void lineReject();
    void lineEntered();
signals:
    void update();
};

#endif

