
#ifndef __KSIAG_PLUGIN_H
#define __KSIAG_PLUGIN_H


#include <qobject.h>
#include <X11/Xlib.h>
#include <stdio.h>

class KSiagPlugin : public QObject
{
    Q_OBJECT
public:
    KSiagPlugin(QObject *parent = 0, const char *name=0);
    ~KSiagPlugin();
    void setParentWindow(Window id);
    int start (char *filename);                   
    int load (char *filename);
    int save(char *filename);
    char* help();
    int print(FILE *fp);
    QSize sizeHint();
    int stop();
public slots:
    void show();
    void hide();
    void move(int x, int y);
protected:
    int pluginWrite (char *buffer);
    int pluginRead (char *buffer);
    char **parseCmd(char *cmd, char *filename, char *name);
    
    Window victim, winid;
    pid_t pid;
    unsigned int w, h;
    int pfd[2], qfd[2];
    bool loaded, running, visible;

    
};

#endif
