/*
 * $Id: SendFaxDialog.C,v 1.5 1999/01/05 11:16:52 kulow Exp $
 */

#include <qslider.h>

#include "SendFaxDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qgrpbox.h>
#include <qlabel.h>
#include <qlined.h>
#include <qlistbox.h>
#include <qmlined.h>
#include <qpushbt.h>

#include "error.h"
#include "syscall.h"
#include "filetools.h"
#include "LString.h"
#include "LyXView.h"
#include "klyx.h"
#include "lyx_gui_misc.h" // WriteAlert

#include <stdio.h>
#include <stdlib.h>

extern BufferView* current_view;
extern LString phone_book;

const int LEN_PHONE = 20;
const int LEN_NAME = 25;

SendFaxDialog::SendFaxDialog( LyXView* view, QWidget * parent=0, 
							  const char * name=0, 
							  WFlags f=0 ) :
  QDialog( parent, name, true, f ),
  _view( view )
{
  QGroupBox* destinationGB = new QGroupBox( i18n( "Destination" ), 
											this );
  destinationGB->setGeometry( 10, 10, 370, 140 );

  QLabel* faxnoLA = new QLabel( i18n( "Fax no." ), this );
  faxnoLA->setGeometry( 40, 30, 60, 30 );
  faxnoLA->setAlignment( AlignRight | AlignVCenter );

  faxnoED = new QLineEdit( this );
  faxnoED->setGeometry( 110, 30, 260, 30 );

  QLabel* destnameLA = new QLabel( i18n( "Dest. name" ), this );
  destnameLA->setGeometry( 20, 70, 80, 30 );
  destnameLA->setAlignment( AlignRight | AlignVCenter );

  destnameED = new QLineEdit( this );
  destnameED->setGeometry( 110, 70, 260, 30 );

  QLabel* companyLA = new QLabel( i18n( "Company" ), this );
  companyLA->setGeometry( 30, 110, 70, 30 );
  companyLA->setAlignment( AlignRight | AlignVCenter );

  companyED = new QLineEdit( this );
  companyED->setGeometry( 110, 110, 260, 30 );

  QGroupBox* phonebookGB = new QGroupBox( i18n( "Phone Book" ), 
										  this );
  phonebookGB->setGeometry( 10, 160, 370, 60 );

  QPushButton* selectfromPB = new QPushButton( i18n( "S&elect from" ), 
											   this );
  selectfromPB->setGeometry( 20, 180, 80, 30 );
  QObject::connect( selectfromPB, SIGNAL( clicked() ),
					this, SLOT( selectfromClicked() ) );

  QPushButton* addtoPB = new QPushButton( i18n( "&Add to" ), 
										   this );
  addtoPB->setGeometry( 110, 180, 80, 30 );
  QObject::connect( addtoPB, SIGNAL( clicked() ),
					this, SLOT( addtoClicked() ) );

  QPushButton* deletefromPB = new QPushButton( i18n( "&Delete from" ), 
											   this );
  deletefromPB->setGeometry( 200, 180, 80, 30 );
  QObject::connect( deletefromPB, SIGNAL( clicked() ),
					this, SLOT( deletefromClicked() ) );

  savePB = new QPushButton( i18n( "&Save" ), this );
  savePB->setGeometry( 290, 180, 80, 30 );
  QObject::connect( savePB, SIGNAL( clicked() ),
					this, SLOT( saveClicked() ) );

  QGroupBox* commentGB = new QGroupBox( i18n( "Comment" ), 
										this );
  commentGB->setGeometry( 10, 230, 370, 190 );

  commentML = new QMultiLineEdit( this );
  commentML->setGeometry( 20, 250, 350, 160 );


  QPushButton* okPB = new QPushButton( i18n( "OK" ), this );
  okPB->setGeometry( 60, 440, 100, 30 );
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), SLOT( okClicked() ) );

  QPushButton* cancelPB = new QPushButton( i18n( "Cancel" ), 
										   this );
  cancelPB->setGeometry( 230, 440, 100, 30 );
  connect( cancelPB, SIGNAL( clicked() ), SLOT( reject() ) );

  setCaption( i18n( "Send a fax" ) );
}


void SendFaxDialog::okClicked()
{
  if ( !strlen( faxnoED->text() ) )
	return;
  LString logfile = TmpFileName( OnlyPath( filename.data() ),"FAX" );
  LString cmd = sendcmd.data();
  cmd += " >";
  cmd += logfile + " 2>";
  cmd += logfile;
  cmd.subst( "$$Host", getenv( "FAX_SERVER" ) );
  cmd.subst( "$$Comment", commentML->text().data() );
  cmd.subst( "$$Enterprise", companyED->text() );
  cmd.subst( "$$Name", destnameED->text() );
  cmd.subst( "$$Phone", faxnoED->text() );
  cmd.subst( "$$FName", filename.data() );
  lyxerr.print( "CMD: " + cmd );
  Systemcalls one( Systemcalls::System, cmd );
  if( !logfile.empty() )
	{
	  if( !klyxdialogs->logfile )
		  klyxdialogs->logfile = new Logfile( _view );

	  klyxdialogs->logfile->loadFile( logfile.c_str() );

	  if( klyxdialogs->logfile->isVisible() )
		klyxdialogs->logfile->raise();
	  else
		klyxdialogs->logfile->show();
	}

  remove( logfile.c_str() );

  accept();
}


void SendFaxDialog::selectfromClicked()
{
	(void)klyxdialogs->phonebook->exec();
}


void SendFaxDialog::addtoClicked()
{
  QString name = destnameED->text();
  QString phone = faxnoED->text();
  QString company = companyED->text();
  
  if( phone.isEmpty() )
	return;

  char *buf = new char [50+company.length()];
  
  sprintf(buf,"%-*.*s %-*.*s %s",
		  LEN_PHONE,LEN_PHONE,phone.data(),
		  LEN_NAME,LEN_NAME,name.data(),
		  company.data());

  unsigned int i = 0;
  for( i = 0; i < klyxdialogs->phonebook->listboxLB->count(); i++ )
	{
	  QString line = klyxdialogs->phonebook->listboxLB->text( i );
	  if( line == buf )
		break;
    }

  if( i >= klyxdialogs->phonebook->listboxLB->count() )
	{
	  klyxdialogs->phonebook->listboxLB->insertItem( buf );
	  savePB->setText( i18n( "* Save *" ) );
	}
  delete[] buf;
}


void SendFaxDialog::deletefromClicked()
{
  QString name = destnameED->text();
  QString phone = faxnoED->text();
  QString company = companyED->text();
  
  if( phone.isEmpty() )
	return;

  char *buf = new char [50+company.length()];
  sprintf(buf,"%-*.*s %-*.*s %s",
		  LEN_PHONE,LEN_PHONE,phone.data(),
		  LEN_NAME,LEN_NAME,name.data(),
		  company.data());

  unsigned int i = 0;
  for( i = 0; i < klyxdialogs->phonebook->listboxLB->count(); i++ )
	{
	  QString line = klyxdialogs->phonebook->listboxLB->text( i );
	  if( line == buf )
		break;
    }

  if( i < klyxdialogs->phonebook->listboxLB->count() )
	{
	  klyxdialogs->phonebook->listboxLB->removeItem( i );
	  savePB->setText( i18n( "* Save *" ) );
	}
  delete[] buf;
}


void SendFaxDialog::saveClicked()
{
 QFile file( klyxdialogs->phonebook->getFilename() );

 if( !file.open( IO_WriteOnly | IO_Truncate ) )
   {
	 WriteAlert(i18n("Error!"),klocale->translate("Cannot open phone book: "),phone_book);
	 return;
   }

 QTextStream stream( &file );

 unsigned int i = 0;
 for( i = 0; i < klyxdialogs->phonebook->listboxLB->count(); i++ )
   {
	 QString line = klyxdialogs->phonebook->listboxLB->text( i );
	 stream << line;
   }

 file.close();
 savePB->setText( i18n( "Save" ) );
}


Phonebook::Phonebook( LyXView* view, QWidget * parent=0, 
					  const char * name=0, 
					  WFlags f=0 ) :
  QDialog( parent, name, true, f ),
  _view( view )
{
  listboxLB = new QListBox( this );
  listboxLB->setGeometry( 0, 0, 300, 300 );
  QObject::connect( listboxLB, SIGNAL( selected( int ) ),
					this, SLOT( selected( int ) ) );

  QPushButton* selectPB = new QPushButton( i18n( "Select" ), 
										   this );
  selectPB->setGeometry( 30, 310, 100, 30 );
  QObject::connect( selectPB, SIGNAL( clicked() ), 
					this, SLOT( selectClicked() ) );
 

  QPushButton* closePB = new QPushButton( i18n( "Close" ), 
										  this );
  closePB->setGeometry( 170, 310, 100, 30 );
  QObject::connect( closePB, SIGNAL( clicked() ), 
					this, SLOT( reject() ) );

  setCaption( i18n( "Phonebook" ) );
}


void Phonebook::selected( int i )
{
  QString line = listboxLB->text( i );
  char *buf = new char [strlen(line)+1];

  strcpy(buf,line);
  for(i = LEN_PHONE;(i>0) && (buf[i]==' ');i--)
	;
  buf[i+1] = 0;
  for(i = LEN_PHONE+LEN_NAME+1;(i>LEN_PHONE) && (buf[i]==' ');i--)
	;
  buf[i+1] = 0;

  klyxdialogs->sendfax->setPhone( buf );
  klyxdialogs->sendfax->setName( buf+LEN_PHONE+1 );
  klyxdialogs->sendfax->setCompany( buf+LEN_PHONE+LEN_NAME+2 );
  delete [] buf;

  accept();
}


void Phonebook::selectClicked()
{
  selected( listboxLB->currentItem() );
}



void Phonebook::loadFile( const char* _filename )
{
  filename = _filename;

  listboxLB->clear();

  QFile file( filename );
  if( file.open( IO_ReadOnly ) )
	{
	  QTextStream stream( &file );
	  while( !stream.eof() )
		listboxLB->insertItem( stream.readLine() );

	  file.close();
	}
}


Logfile::Logfile( LyXView* view, QWidget * parent=0, 
				  const char * name=0, 
				  WFlags f=0 ) :
  QDialog( parent, name, false, f ),
  _view( view )
{
  listboxLB = new QListBox( this );
  listboxLB->setGeometry( 0, 0, 300, 300 );

  QPushButton* closePB = new QPushButton( i18n( "Close" ), 
										  this );
  closePB->setGeometry( 150, 310, 100, 30 );
  QObject::connect( closePB, SIGNAL( clicked() ), 
					this, SLOT( hide() ) );

  setCaption( i18n( "Message View" ) );
}


void Logfile::loadFile( const char* _filename )
{
  listboxLB->clear();

  QFile file( _filename );
  if( file.open( IO_ReadOnly ) )
	{
	  QTextStream stream( &file );
	  listboxLB->insertItem( stream.readLine() );

	  file.close();
	}
}


/*
 * $Log: SendFaxDialog.C,v $
 * Revision 1.5  1999/01/05 11:16:52  kulow
 * s/klocale->translate/i18n
 * updated po files with the newly i18ned file dialogs
 *
 * Revision 1.4  1998/03/15 07:11:18  kalle
 * More Qt-ified
 *
 * Revision 1.3  1998/03/03 22:36:26  kulow
 * removed all those ->show(), they make me crazy
 *
 * Revision 1.2  1998/01/27 23:09:54  kalle
 * The first part of the monster commit. Perhaps not everything
 * compiles yet...
 * The ViewLogfile dialog is in, but not yet tested.
 *
 * Revision 1.1  1998/01/13 22:10:32  kalle
 * Fax sending, phonebook and logfile
 * (not really functional yet)
 *
 */
