/* This file is part of
* ======================================================
*
*           LyX, the High Level Word Processor
*           KLyX, the KDE Document Processor
*
*           Copyright (C) 1995 1996 Matthias Ettrich
*           and the LyX Team.
*           Copyright (C) 1997-1999 KLyX team
*
*======================================================*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <qprinter.h>

#include "drag.h"
#include "klyx.h"
#include "KLyXMenu.h"
#include "KLyXToolBar.h"
#include "knewpanner.h"

#include "LyXView.h"
#include "lyx_main.h"
#include "minibuffer.h"
#include "lyxfunc.h"
#include "error.h"
#include "intl.h"
#include "lyxrc.h"
#include "lyxscreen.h"
#include "filetools.h"        // OnlyFilename()
#include "layout.h"
#include "lyxtext.h"
#include "FontLoader.h"

#include "bufferlist.h"

#include "ParagraphDialog.h"
#include "InsertTableDialog.h"
#include "InsertFigureDialog.h"
#include "DocumentLayoutDialog.h"
#include "CharacterStyleDialog.h"
#include "ScreenOptionsTabDialog.h"
#include "ScreenFontsDialog.h"
#include "ScreenToolbarsDialog.h"
#include "SpellcheckerOptionsDialog.h"
#include "MathSpacingDialog.h"
#include "MathMatrixDialog.h"
#include "MathBrowsers.h"
#include "MathDelimiterDialog.h"
#include "SendFaxDialog.h"
#include "TableOfContentsDialog.h"
#include "ExportCustomDialog.h"
#include "TableOfContentsDialog.h"
#include "FindReplaceDialog.h"
#include "ViewLogfileDialog.h"
#include "BulletShapeDialog.h"
#include "InsertLabelDialog.h"
#include "InsertIndexEntryDialog.h"
#include "InsertCrossReferenceDialog.h"
#include "InsertCitationReferenceDialog.h"
#include "LaTeXOptionsDialog.h"
#include "LaTeXPreambleDialog.h"
#include "QuotesDialog.h"
#include "PaperFormatDialog.h"
#include "InsertBibitemDialog.h"
#include "InsertIncludeDialog.h"
#include "CreditsDialog.h"
#include "InsertErrorDialog.h"
#include "InsertInfoDialog.h"
#include "VCLogDialog.h"

#include <kcombo.h>
#include <kconfig.h>
#include <ktopwidget.h>
#include <kiconloader.h>
#include <ktoolbar.h>
#include <kwm.h>



extern BufferList bufferlist;

extern void AutoSave();
extern void QuitLyX();
extern void checkchildren();

// This is very temporary
BufferView *current_view = 0;

// global toolbar settings
ScreenToolbarsDialogData global_toolbar_visibilities;

LyXView::LyXView(int width, int height)
{
	lyxerr.debug("Initializing LyXFunc");
	lyxfunc = new LyXFunc(this);
	intl = new Intl;

	fontloader = new FontLoader;
	_klyxprinter = new QPrinter;

	_k_tlw = new KLyXToplevelWidget(this, "klyx");
	_k_tlw->setCaption("KLyX is coming!");
	KWM::setIcon(_k_tlw->winId(), ICON("lyx.xpm"));
	KWM::setMiniIcon(_k_tlw->winId(), kapp->getIconLoader()->loadMiniIcon("lyx.xpm"));

	_menureceiver = new KLyXMenuReceiver( this );

	// 'toolbarreceiver' is now a private data member of LyXView,
	// so now it is known as '_toolbarreceiver'
	// Rocher 981201
	_toolbarreceiver = new KLyXToolBarReceiver( this );

	KIconLoader* loader = kapp->getIconLoader();
	/* standard toolbar */
	toolbar = new KToolBar( _k_tlw, "toolbar" );
	toolbar->insertCombo( "", TOOLBAR_LAYOUT_COMBO, false, SIGNAL( activated( int ) ),
			      _toolbarreceiver, SLOT( layoutComboActivated( int ) ),
			      true, i18n( "Choose paragraph environment" ), 150 );
	_layoutcombo = toolbar->getCombo( TOOLBAR_LAYOUT_COMBO );
	_layoutcombo->setEnabled( false ); // be on the safe side for starters
	_layoutcombo->setFocusPolicy(QWidget::NoFocus);
	toolbar->insertButton( loader->loadIcon( "filenew.xpm" ), TOOLBAR_FILENEW, SIGNAL( clicked() ),
			       _toolbarreceiver, SLOT( fileNew() ), true, i18n( "New" ) );
	toolbar->insertButton( loader->loadIcon( "filenewtmplt.xpm" ), TOOLBAR_FILENEWTMPLT, // Rocher 981124
						   SIGNAL( clicked() ),
						   _toolbarreceiver, SLOT( fileNewTmplt() ), true,
						   i18n( "New From Template" ) );
	toolbar->insertButton( loader->loadIcon( "fileopen.xpm" ), TOOLBAR_OPEN,
						   SIGNAL( clicked() ),
						   _toolbarreceiver, SLOT( open() ), true,
						   i18n( "Open" ) );
	toolbar->insertButton( loader->loadIcon( "filefloppy.xpm" ), TOOLBAR_WRITE,
						   SIGNAL( clicked() ),
						   _toolbarreceiver, SLOT( write() ), true,
						   i18n( "Save" ) );
	toolbar->insertButton( loader->loadIcon( "preview.xpm" ), TOOLBAR_PREVIEWCUSTOM, // Rocher 981124
						   SIGNAL( clicked() ),
						   _toolbarreceiver, SLOT( previewCustom() ), true,
						   i18n( "Preview" ) );
	toolbar->insertButton( loader->loadIcon( "update.xpm" ), TOOLBAR_PREVIEWUPDATE, // Rocher 981124
						   SIGNAL( clicked() ),
						   _toolbarreceiver, SLOT( previewUpdate() ), true,
						   i18n( "Update Preview" ) );
	toolbar->insertButton( loader->loadIcon( "fileprint.xpm" ), TOOLBAR_PRINT,
						   SIGNAL( clicked() ),
						   _toolbarreceiver, SLOT( print() ), true,
						   i18n( "Print" ) );
	toolbar->insertSeparator();
	toolbar->insertButton( loader->loadIcon( "editcut.xpm" ), TOOLBAR_CUT,
						   SIGNAL( clicked() ),
						   _toolbarreceiver, SLOT( cut() ), true,
						   i18n( "Cut" ) );
	toolbar->insertButton( loader->loadIcon( "editcopy.xpm" ), TOOLBAR_COPY,
						   SIGNAL( clicked() ),
						   _toolbarreceiver, SLOT( copy() ), true,
						   i18n( "Copy" ) );
	toolbar->insertButton( loader->loadIcon( "editpaste.xpm" ), TOOLBAR_PASTE,
						   SIGNAL( clicked() ),
						   _toolbarreceiver, SLOT( paste() ), true,
						   i18n( "Paste" ) );
	toolbar->insertSeparator();
	toolbar->insertButton( loader->loadIcon( "emph.xpm" ), TOOLBAR_EMPH,
						   SIGNAL( clicked() ),
						   _toolbarreceiver, SLOT( emph() ), true,
						   i18n( "Toggle emphasize" ) );
	toolbar->insertButton( loader->loadIcon( "noun.xpm" ), TOOLBAR_NOUN,
						   SIGNAL( clicked() ),
						   _toolbarreceiver, SLOT( noun() ), true,
						   i18n( "Toggle noun style" ) );
	toolbar->insertButton( loader->loadIcon( "free.xpm" ), TOOLBAR_FREE,
						   SIGNAL( clicked() ),
						   _toolbarreceiver, SLOT( free() ), true,
						   i18n( "Toggle user defined style" ) );
	toolbar->insertSeparator();
	toolbar->insertButton( loader->loadIcon( "foot.xpm" ), TOOLBAR_FOOTMELT,
						   SIGNAL( clicked() ),
						   _toolbarreceiver, SLOT( footmelt() ), true,
						   i18n( "Insert footnote" ) );
	toolbar->insertButton( loader->loadIcon( "margin.xpm" ), TOOLBAR_MARGINMELT,
						   SIGNAL( clicked() ),
						   _toolbarreceiver, SLOT( marginmelt() ), true,
						   i18n( "Insert margin note" ) );
	toolbar->insertButton( loader->loadIcon( "depth.xpm" ), TOOLBAR_DEPTH,
						   SIGNAL( clicked() ),
						   _toolbarreceiver, SLOT( depth() ), true,
						   i18n( "Change environment depth" ) );
	toolbar->insertSeparator();
	toolbar->insertButton( loader->loadIcon( "tex.xpm" ), TOOLBAR_TEX, SIGNAL( clicked() ),
						   _toolbarreceiver, SLOT( tex() ), true,
						   i18n( "Toggle TeX style" ) );
	toolbar->insertButton( loader->loadIcon( "math.xpm" ), TOOLBAR_MATHMODE,
						   SIGNAL( clicked() ),
						   _toolbarreceiver, SLOT( mathmode() ), true,
						   i18n( "Math mode" ) );
	toolbar->insertSeparator();
	toolbar->insertButton( loader->loadIcon( "tab.xpm" ), TOOLBAR_FIGURE,
						   SIGNAL( clicked() ),
						   _toolbarreceiver, SLOT( table() ), true,
						   i18n( "Insert table" ) );
	toolbar->insertButton( loader->loadIcon( "fig.xpm" ), TOOLBAR_TABLE,
						   SIGNAL( clicked() ),
						   _toolbarreceiver, SLOT( figure() ), true,
						   i18n( "Insert figure" ) );
	_k_tlw->addToolBar( toolbar, STANDARDTOOLBAR );

	/* math toolbar */
	mathtoolbar = new KToolBar( _k_tlw, "mathtoolbar" );
	mathtoolbar->insertButton( loader->loadIcon( "sqrt.xpm" ),
							   MATHTOOLBAR_SQUAREROOT, SIGNAL( clicked() ),
							   _toolbarreceiver, SLOT( squareroot() ), true,
							   i18n( "Square root" ) );
	mathtoolbar->insertButton( loader->loadIcon( "frac.xpm" ),
							   MATHTOOLBAR_FRACTION, SIGNAL( clicked() ),
							   _toolbarreceiver, SLOT( fraction() ), true,
							   i18n( "Fraction" ) );
	mathtoolbar->insertSeparator();
	mathtoolbar->insertButton( loader->loadIcon( "sum.xpm" ),
							   MATHTOOLBAR_SUM, SIGNAL( clicked() ),
							   _toolbarreceiver, SLOT( sum() ), true,
							   i18n( "Sum" ) );
	mathtoolbar->insertButton( loader->loadIcon( "integral.xpm" ),
							   MATHTOOLBAR_INTEGRAL, SIGNAL( clicked() ),
							   _toolbarreceiver, SLOT( integral() ), true,
							   i18n( "Integral" ) );
	mathtoolbar->insertButton( loader->loadIcon( "exponent.xpm" ),
							   MATHTOOLBAR_EXPONENT, SIGNAL( clicked() ),
							   _toolbarreceiver, SLOT( exponent() ), true,
							   i18n( "Exponent" ) );
	mathtoolbar->insertButton( loader->loadIcon( "index.xpm" ),
							   MATHTOOLBAR_INDEX, SIGNAL( clicked() ),
							   _toolbarreceiver, SLOT( index() ), true,
							   i18n( "Index" ) );
	mathtoolbar->insertSeparator();
	mathtoolbar->insertButton( loader->loadIcon( "delim.xpm" ),
							   MATHTOOLBAR_DELIMITER, SIGNAL( clicked() ),
							   _toolbarreceiver, SLOT( delimiter() ), true,
							   i18n( "Delimiter" ) );
	mathtoolbar->insertButton( loader->loadIcon( "deco.xpm" ),
							   MATHTOOLBAR_DECORATION, SIGNAL( pressed() ),
							   _toolbarreceiver, SLOT( decoration() ), true,
							   i18n( "Decoration" ) );
	mathtoolbar->insertButton( loader->loadIcon( "space.xpm" ),
							   MATHTOOLBAR_SPACING, SIGNAL( clicked() ),
							   _toolbarreceiver, SLOT( spacing() ), true,
							   i18n( "Spacing" ) );
	mathtoolbar->insertButton( loader->loadIcon( "matrix.xpm" ),
							   MATHTOOLBAR_MATRIX, SIGNAL( clicked() ),
							   _toolbarreceiver, SLOT( matrix() ), true,
							   i18n( "Matrix" ) );
	mathtoolbar->insertButton( loader->loadIcon( "equation.xpm" ),
							   MATHTOOLBAR_EQUATION, SIGNAL( clicked() ),
							   _toolbarreceiver, SLOT( equation() ), true,
							   i18n( "Equation" ) );
	mathtoolbar->insertSeparator();
	mathtoolbar->insertButton( loader->loadIcon( "toolbar_greek.xpm" ),
							   MATHTOOLBAR_GREEK, SIGNAL( pressed() ),
							   _toolbarreceiver, SLOT( greek() ), true,
							   i18n( "Greek characters" ) );
	mathtoolbar->insertButton( loader->loadIcon( "toolbar_boperators.xpm" ),
							   MATHTOOLBAR_BOPERATOR, SIGNAL( pressed() ),
							   _toolbarreceiver, SLOT( boperators() ), true,
							   i18n( "Binary operators" ) );
	mathtoolbar->insertButton( loader->loadIcon( "toolbar_brelations.xpm" ),
							   MATHTOOLBAR_BRELATION, SIGNAL( pressed() ),
							   _toolbarreceiver, SLOT( brelations() ), true,
							   i18n( "Binary relations" ) );
	mathtoolbar->insertButton( loader->loadIcon( "toolbar_arrows.xpm" ),
							   MATHTOOLBAR_ARROW, SIGNAL( pressed() ),
							   _toolbarreceiver, SLOT( arrows() ), true,
							   i18n( "Arrows" ) );
	mathtoolbar->insertButton( loader->loadIcon( "toolbar_varsize.xpm" ),
							   MATHTOOLBAR_VARSIZE, SIGNAL( pressed() ),
							   _toolbarreceiver, SLOT( varsize() ), true,
							   i18n( "Variably-sized symbols" ) );
	mathtoolbar->insertButton( loader->loadIcon( "toolbar_function.xpm" ),
							   MATHTOOLBAR_FUNCTION, SIGNAL( pressed() ),
							   _toolbarreceiver, SLOT( function() ), true,
							   i18n( "Functions" ) );
	mathtoolbar->insertButton( loader->loadIcon( "toolbar_misc.xpm" ),
							   MATHTOOLBAR_MISC, SIGNAL( pressed() ),
							   _toolbarreceiver, SLOT( misc() ), true,
							   i18n( "Miscellaneous" ) );
	_k_tlw->addToolBar( mathtoolbar, MATHTOOLBAR );


	/* table toolbar */
	tabletoolbar = new KToolBar( _k_tlw, "tabletoolbar" );
	tabletoolbar->insertCombo( (char*)(0), TABLETOOLBAR_STYLE_COMBO,
				   false, SIGNAL( activated( int ) ),
				   _toolbarreceiver, SLOT( tableStyleComboActivated( int ) ),
				   true, i18n( "Table style" ),
				   105 );
	KCombo* tmpcombo = tabletoolbar->getCombo(TABLETOOLBAR_STYLE_COMBO);
	tmpcombo->insertItem( i18n( "Portrait" ));
	tmpcombo->insertItem( i18n( "Landscape" ));
	tmpcombo->insertItem( i18n( "Long" ));

	tmpcombo->setFocusPolicy(QWidget::NoFocus);
	tabletoolbar->insertButton( loader->loadIcon( "borderleft.xpm" ),
				    TABLETOOLBAR_BORDER_LEFT,
				    true,
				    i18n( "Left Border" ) );
	tabletoolbar->setToggle(TABLETOOLBAR_BORDER_LEFT);

	tabletoolbar->insertButton( loader->loadIcon( "borderright.xpm" ),
				    TABLETOOLBAR_BORDER_RIGHT,
				    true,
				    i18n( "Right Border" ) );
	tabletoolbar->setToggle(TABLETOOLBAR_BORDER_RIGHT);

	tabletoolbar->insertButton( loader->loadIcon( "bordertop.xpm" ),
				    TABLETOOLBAR_BORDER_TOP,
				    true,
				    i18n( "Top Border" ) );
	tabletoolbar->setToggle(TABLETOOLBAR_BORDER_TOP);

	tabletoolbar->insertButton( loader->loadIcon( "borderbottom.xpm" ),
				    TABLETOOLBAR_BORDER_BOTTOM,
				    true,
				    i18n( "Bottom Border" ) );
	tabletoolbar->setToggle(TABLETOOLBAR_BORDER_BOTTOM);

	tabletoolbar->insertSeparator();

	tabletoolbar->insertButton( loader->loadIcon( "addrow.xpm" ),
				    TABLETOOLBAR_APPEND_ROW,
				    true,
				    i18n( "Add Row" ) );

	tabletoolbar->insertButton( loader->loadIcon( "deleterow.xpm" ),
				    TABLETOOLBAR_DELETE_ROW,
				    true,
				    i18n( "Delete Row" ) );

	tabletoolbar->insertButton( loader->loadIcon( "addcolumn.xpm" ),
				    TABLETOOLBAR_APPEND_COLUMN,
				    true,
				    i18n( "Add Column" ) );

	tabletoolbar->insertButton( loader->loadIcon( "deletecolumn.xpm" ),
				    TABLETOOLBAR_DELETE_COLUMN,
				    true,
				    i18n( "Delete Column" ) );

	tabletoolbar->insertSeparator();

	tabletoolbar->insertButton( loader->loadIcon( "alignleft.xpm" ),
				    TABLETOOLBAR_ALIGN_LEFT,
				    true,
				    i18n( "Align Left" ) );
	tabletoolbar->setToggle(TABLETOOLBAR_ALIGN_LEFT);

	tabletoolbar->insertButton( loader->loadIcon( "aligncenter.xpm" ),
				    TABLETOOLBAR_ALIGN_CENTER,
				    true,
				    i18n( "Align Center" ) );
	tabletoolbar->setToggle(TABLETOOLBAR_ALIGN_CENTER);

	tabletoolbar->insertButton( loader->loadIcon( "alignright.xpm" ),
				    TABLETOOLBAR_ALIGN_RIGHT,
				    true,
				    i18n( "Align Right" ) );
	tabletoolbar->setToggle(TABLETOOLBAR_ALIGN_RIGHT);


	tabletoolbar->insertSeparator();


	tabletoolbar->insertButton( loader->loadIcon( "multicolumn.xpm" ),
				    TABLETOOLBAR_MULTICOLUMN,
				    true,
				    i18n( "Multicolumn" ) );
	tabletoolbar->setToggle(TABLETOOLBAR_MULTICOLUMN);

	tabletoolbar->insertButton( loader->loadIcon( "rotatecell.xpm" ),
				    TABLETOOLBAR_ROTATE_CELL,
				    true,
				    i18n( "Rotate Cell" ) );
	tabletoolbar->setToggle(TABLETOOLBAR_ROTATE_CELL);

	tabletoolbar->insertButton( loader->loadIcon( "widthofcolumn.xpm" ),
				    TABLETOOLBAR_WIDTH_OF_COLUMN,
				    true,
				    i18n( "Width of Column" ) );
	tabletoolbar->setToggle(TABLETOOLBAR_WIDTH_OF_COLUMN);

	tabletoolbar->insertSeparator();

	tabletoolbar->insertCombo( (char*)(0), TABLETOOLBAR_LONG_COMBO,
				   false, SIGNAL( activated( int ) ),
				   _toolbarreceiver, SLOT( tableLongComboActivated( int ) ),
				   true, i18n( "Special flags for long tables" ),
				   105 );
	tmpcombo = tabletoolbar->getCombo(TABLETOOLBAR_LONG_COMBO);
	tmpcombo->setEnabled( false );
	tmpcombo->setFocusPolicy(QWidget::NoFocus);
	tmpcombo->insertItem( i18n( "Normal" ));
	tmpcombo->insertItem( i18n( "First head" ));
	tmpcombo->insertItem( i18n( "Head" ));
	tmpcombo->insertItem( i18n( "Foot" ));
	tmpcombo->insertItem( i18n( "Last foot" ));
	tmpcombo->insertItem( i18n( "New page" ));

	tabletoolbar->insertSeparator();

	tabletoolbar->insertButton( loader->loadIcon( "deletetable.xpm" ),
				    TABLETOOLBAR_DELETE_TABLE,
				    true,
				    i18n( "Delete Table" ) );





	_toolbarreceiver->connect(tabletoolbar, SIGNAL( clicked(int) ),
				 SLOT( tableUpdate(int) ));

	_k_tlw->addToolBar( tabletoolbar, TABLETOOLBAR );





	chartoolbar = new KToolBar( _k_tlw, "chartoolbar" );
	KCombo* combo;

	chartoolbar->insertCombo( (char*)(0), CHARTOOLBAR_FAMILY, false,
				  SIGNAL( activated( int ) ),
				  _toolbarreceiver, SLOT( charComboIgnore( int ) ),
				  true,
				  i18n( "Family" ),
				  145 );

	combo = chartoolbar->getCombo( CHARTOOLBAR_FAMILY );
// 	combo->setEnabled( false ); // be on the safe side for starters
	combo->setFocusPolicy(QWidget::NoFocus);

	combo->insertItem( i18n( "Family::Keep" ),
			   CharacterStyleDialogData::FamilyNoChange );
	combo->insertItem( i18n( "Family::Roman" ),
			   CharacterStyleDialogData::Roman );
	combo->insertItem( i18n( "Family::SansSerif" ),
			   CharacterStyleDialogData::SansSerif );
	combo->insertItem( i18n( "Family::Typewriter" ),
			   CharacterStyleDialogData::Typewriter );
	combo->insertItem( i18n( "Family::Reset" ),
			   CharacterStyleDialogData::FamilyReset );

	combo->setSizeLimit(combo->count());



	chartoolbar->insertCombo( (char*)(0), CHARTOOLBAR_SERIES, false,
				  SIGNAL( activated( int ) ),
				  _toolbarreceiver, SLOT( charComboIgnore( int ) ),
				  true,
				  i18n( "Series" ),
				  145 );

	combo = chartoolbar->getCombo( CHARTOOLBAR_SERIES );
// 	combo->setEnabled( false ); // be on the safe side for starters
	combo->setFocusPolicy(QWidget::NoFocus);
	combo->insertItem( i18n( "Series::Keep" ),
			   CharacterStyleDialogData::SeriesNoChange );
	combo->insertItem( i18n( "Series::Medium" ),
			   CharacterStyleDialogData::Medium );
	combo->insertItem( i18n( "Series::Bold" ),
			   CharacterStyleDialogData::Bold );
	combo->insertItem( i18n( "Series::Reset" ),
			   CharacterStyleDialogData::SeriesReset );

	combo->setSizeLimit(combo->count());





	chartoolbar->insertCombo( (char*)(0), CHARTOOLBAR_SHAPE, false,
				  SIGNAL( activated( int ) ),
				  _toolbarreceiver, SLOT( charComboIgnore( int ) ),
				  true,
				  i18n( "Shape" ),
				  145 );

	combo = chartoolbar->getCombo( CHARTOOLBAR_SHAPE );
// 	combo->setEnabled( false ); // be on the safe side for starters
	combo->setFocusPolicy(QWidget::NoFocus);


	combo->insertItem( i18n( "Shape::Keep" ),
			   CharacterStyleDialogData::ShapeNoChange );
	combo->insertItem( i18n( "Shape::Upright" ),
			   CharacterStyleDialogData::Upright );
	combo->insertItem( i18n( "Shape::Italic" ),
			   CharacterStyleDialogData::Italic );
	combo->insertItem( i18n( "Shape::Slanted" ),
			   CharacterStyleDialogData::Slanted );
	combo->insertItem( i18n( "Shape::SmallCaps" ),
			   CharacterStyleDialogData::SmallCaps );
	combo->insertItem( i18n( "Shape::Reset" ),
			   CharacterStyleDialogData::ShapeReset );

	combo->setSizeLimit(combo->count());


	chartoolbar->insertCombo( (char*)(0), CHARTOOLBAR_SIZE, false,
				  SIGNAL( activated( int ) ),
				  _toolbarreceiver, SLOT( charComboIgnore( int ) ),
				  true,
				  i18n( "Size" ),
				  125 );


	combo = chartoolbar->getCombo( CHARTOOLBAR_SIZE );
// 	combo->setEnabled( false ); // be on the safe side for starters
	combo->setFocusPolicy(QWidget::NoFocus);
	combo->insertItem( i18n( "Size::Keep" ),
			    CharacterStyleDialogData::SizeNoChange );
	combo->insertItem( i18n( "Size::Tiny" ),
			   CharacterStyleDialogData::Tiny );
	combo->insertItem( i18n( "Size::Smallest" ),
			   CharacterStyleDialogData::Smallest );
	combo->insertItem( i18n( "Size::Smaller" ),
			   CharacterStyleDialogData::Smaller );
	combo->insertItem( i18n( "Size::Small" ),
			   CharacterStyleDialogData::Small );
	combo->insertItem( i18n( "Size::Normal" ),
			   CharacterStyleDialogData::Normal );
	combo->insertItem( i18n( "Size::Large" ),
			   CharacterStyleDialogData::Large );
	combo->insertItem( i18n( "Size::Larger" ),
			   CharacterStyleDialogData::Larger );
	combo->insertItem( i18n( "Size::Largest" ),
			   CharacterStyleDialogData::Largest );
	combo->insertItem( i18n( "Size::Huge" ),
			   CharacterStyleDialogData::Huge );
	combo->insertItem( i18n( "Size::Huger" ),
			   CharacterStyleDialogData::Huger );
	combo->insertItem( i18n( "Size::Increase" ),
			   CharacterStyleDialogData::Increase );
	combo->insertItem( i18n( "Size::Decrease" ),
			   CharacterStyleDialogData::Decrease );
	combo->insertItem( i18n( "Size::Reset" ),
			   CharacterStyleDialogData::SizeReset );
        combo->setSizeLimit(combo->count());

	chartoolbar->insertCombo( (char*)(0), CHARTOOLBAR_MISC, false,
				  SIGNAL( activated( int ) ),
				  _toolbarreceiver, SLOT( charComboIgnore( int ) ),
				  true,
				  i18n( "Misc" ),
				  125 );

	combo = chartoolbar->getCombo( CHARTOOLBAR_MISC );
// 	combo->setEnabled( false ); // be on the safe side for starters
	combo->setFocusPolicy(QWidget::NoFocus);







	combo->insertItem( i18n( "Misc::Keep" ),
			   CharacterStyleDialogData::MiscNoChange );
	combo->insertItem( i18n( "Misc::Emph" ),
			   CharacterStyleDialogData::Emph );
	combo->insertItem( i18n( "Misc::Underbar" ),
			   CharacterStyleDialogData::Underbar );
	combo->insertItem( i18n( "Misc::Noun" ),
			   CharacterStyleDialogData::Noun );
	combo->insertItem( i18n( "Misc::LaTeX" ),
			   CharacterStyleDialogData::LaTeXMode );
	combo->insertItem( i18n( "Misc::Reset" ),
					  CharacterStyleDialogData::MiscReset );
        combo->setSizeLimit(combo->count());
	chartoolbar->insertCombo( (char*)(0), CHARTOOLBAR_COLOR, false,
				  SIGNAL( activated( int ) ),
				  _toolbarreceiver, SLOT( charComboIgnore( int ) ),
				  true,
				  i18n( "Color" ),
				  125 );

	combo = chartoolbar->getCombo( CHARTOOLBAR_COLOR );
// 	combo->setEnabled( false ); // be on the safe side for starters
	combo->setFocusPolicy(QWidget::NoFocus);

	combo->insertItem( i18n( "Color::Keep" ),
			   CharacterStyleDialogData::ColorNoChange );
	combo->insertItem( i18n( "Color::None" ),
			   CharacterStyleDialogData::NoColor );
	combo->insertItem( i18n( "Color::Black" ),
			   CharacterStyleDialogData::Black );
	combo->insertItem( i18n( "Color::White" ),
			   CharacterStyleDialogData::White );
	combo->insertItem( i18n( "Color::Red" ),
			   CharacterStyleDialogData::Red );
	combo->insertItem( i18n( "Color::Green" ),
			   CharacterStyleDialogData::Green );
	combo->insertItem( i18n( "Color::Blue" ),
			   CharacterStyleDialogData::Blue );
	combo->insertItem( i18n( "Color::Cyan" ),
			   CharacterStyleDialogData::Cyan );
	combo->insertItem( i18n( "Color::Magenta" ),
			   CharacterStyleDialogData::Magenta );
	combo->insertItem( i18n( "Color::Yellow" ),
			   CharacterStyleDialogData::Yellow );
	combo->insertItem( i18n( "Color::Reset" ),
			   CharacterStyleDialogData::ColorReset );
        combo->setSizeLimit(combo->count());
	
	chartoolbar->insertButton( loader->loadIcon( "free.xpm" ), TOOLBAR_FREE,
				   SIGNAL( clicked() ),
				   _toolbarreceiver, SLOT( charUpdate() ), true,
				   i18n( "Toggle user defined style" ) );

	_k_tlw->addToolBar( chartoolbar, CHARTOOLBAR );




	::current_view = bufferview = 0;

	k_frame = new K_Frame(_k_tlw);
	k_mini = new QLineEdit(k_frame);
	k_mini->setFrame(false);


	k_panner = 0;

	// TODO

	::current_view = bufferview = new BufferView(this, k_frame);

	bufferview_one = bufferview;
	bufferview_two = 0;

	k_frame->setWidgets(bufferview->getKCanvas(), k_mini);
	


	//
	// MINIBUFFER
	//

	minibuffer = new MiniBuffer(this);

	_k_tlw->setFrameBorderWidth( 2 );
	_k_tlw->setView( k_frame, true );

	// *** session management ***
	// restore geometry from last session
	KConfig *config = kapp->getConfig();
	config->setGroup( "SessionManagement" );
	chartoolbar->setBarPos( static_cast< KToolBar::BarPosition >( config->readNumEntry( "CharToolBar", KToolBar::Top ) ) );
	mathtoolbar->setBarPos( static_cast< KToolBar::BarPosition >( config->readNumEntry( "MathToolBar", KToolBar::Top ) ) );
	tabletoolbar->setBarPos( static_cast< KToolBar::BarPosition >( config->readNumEntry( "TableToolBar", KToolBar::Top ) ) );
	toolbar->setBarPos( static_cast< KToolBar::BarPosition >( config->readNumEntry( "CharToolBar", KToolBar::Top ) ) );
	_k_tlw->resize( config->readNumEntry( "width", 600 ), config->readNumEntry( "height", 400 ) );
	_k_tlw->show();

	// Drag and Drop
	dropzone = new KDNDDropZone( k_frame, DndURL );
	QObject::connect( dropzone, SIGNAL( dropAction( KDNDDropZone* ) ),
			  this, SLOT( dropActionSlot( KDNDDropZone* ) ) );
	bufferview->getKCanvas()->takeFocus();
}


LyXView::~LyXView()
{
    debug("LyXView destroyed");
    
    // *** session management ***
    // save geometry for next session
    KConfig *config = kapp->getConfig();
    config->setGroup( "SessionManagement" );
    config->writeEntry( "CharToolBar", static_cast< int >( chartoolbar->barPos() ) );
    config->writeEntry( "MathToolBar", static_cast< int >( mathtoolbar->barPos() ) );
    config->writeEntry( "TableToolBar", static_cast< int >( tabletoolbar->barPos() ) );
    config->writeEntry( "ToolBar", static_cast< int >( toolbar->barPos() ) );
    config->writeEntry( "height", _k_tlw->height() );
    config->writeEntry( "width", _k_tlw->width() );

  delete minibuffer;
  delete lyxfunc;
  delete intl;
  // delete dropzone; //already destroyed (child of window!)
  delete _menureceiver;
  delete bufferview_one;
  delete bufferview_two;

   // delete dialogs
  delete dialogs()->paragraphreceiver;
  delete dialogs()->paragraph;
  delete dialogs()->insertfigure;
  delete dialogs()->inserttable;
  delete dialogs()->documentreceiver;
  delete dialogs()->document;
  delete dialogs()->character;
  delete dialogs()->screenoptions;
  delete dialogs()->spelloptions;
  delete dialogs()->sendfax;
  delete dialogs()->phonebook;
  delete dialogs()->logfile;
  delete dialogs()->exportcustom;
  delete dialogs()->toc;
  delete dialogs()->findreplace;
  delete dialogs()->viewlogfile;
  delete dialogs()->bulletshape;
  delete dialogs()->insertlabel;
  delete dialogs()->insertindex;
  delete dialogs()->insertxref;
  delete dialogs()->insertcitationref;
  delete dialogs()->latexoptions;
  delete dialogs()->latexpreamble;
  delete dialogs()->quotes;
  delete dialogs()->paper;
  delete dialogs()->bibitem;
  delete dialogs()->insertinclude;
  delete dialogs()->credits;
  delete dialogs()->inserterror;
  delete dialogs()->insertinfo;
  delete dialogs()->vclog;

  delete dialogs()->mathspacing;
  delete dialogs()->mathdecobrowser;
  delete dialogs()->mathgreekbrowser;
  delete dialogs()->mathbinrelbrowser;
  delete dialogs()->mathbinopbrowser;
  delete dialogs()->mathvarsizebrowser;
  delete dialogs()->mathmiscbrowser;
  delete dialogs()->mathmatrix;
  delete dialogs()->mathdelimiter;

}


BufferView *LyXView::currentView(){
  current_view = bufferview;
  return bufferview;
}


/// Redraw the main form.
void LyXView::redraw() {
}


// // Callback for autosave timer
// void LyXView::AutosaveTimerCB(FL_OBJECT *, long)
// {
// 	lyxerr.debug("Running AutoSave()");
// 	AutoSave();
// }


// /// Reset autosave timer
// void LyXView::resetAutosaveTimer()
// {
// 	if (lyxrc->autosave)
// 		fl_set_timer(_form_main->timer_autosave, lyxrc->autosave);
// }



void LyXView::splitView(KNewPanner::Orientation style){
  if (k_panner)
    return; //view already splitted

  k_panner = new KNewPanner(k_frame, 0, style);	// Rocher 981130
  Buffer* buffer = currentBuffer();
  delete bufferview_one;
  bufferview_one = 0;

  bufferview_two = new BufferView(this, k_panner);
  ::current_view = bufferview = bufferview_one = new BufferView(this, k_panner);

  k_panner->activate(bufferview_one->getKCanvas(), bufferview_two->getKCanvas());

  k_frame->setWidgets(k_panner, k_mini);

  k_panner->show();

  bufferview_two->setBuffer(buffer);
  bufferview_one->setBuffer(buffer);
  bufferview_one->getKCanvas()->setFocus();
  if (buffer) {						// Rocher 981123
    bufferview_one_cursor = bufferview_one->currentBuffer()->text->cursor;
    bufferview_two_cursor = bufferview_two->currentBuffer()->text->cursor;
  }
}

void LyXView::unsplitView(){
  if (!k_panner)
    return; //view already unsplitted
  Buffer* buffer = currentBuffer();
  delete bufferview_one;
  bufferview_one = 0;
  delete bufferview_two;
  bufferview_two = 0;
  k_panner->close();
  k_panner = 0;
  ::current_view = bufferview = bufferview_one = new BufferView(this, k_frame);
  k_frame->setWidgets(bufferview->getKCanvas(), k_mini);
  bufferview_one->getKCanvas()->show();
  bufferview_one->setBuffer(buffer);
  bufferview_one->getKCanvas()->setFocus();
}

void LyXView::unsplitViewOther() {	// Rocher 981123
   if (!isSplitted())
      return;
   else {
      changeView();
      unsplitView();
   }
}

void LyXView::changeView() {			// Rocher 981123
   if (!isSplitted())
      return;
   if (bufferview_one->getKCanvas()->hasFocus()) {
      bufferview_one_cursor = bufferview_one->currentBuffer()->text->cursor;
      bufferview_two->getKCanvas()->setFocus();
      bufferview_two->currentBuffer()->text->SetCursor(bufferview_two_cursor.par,bufferview_two_cursor.pos);
   }
   else {
      bufferview_two_cursor = bufferview_two->currentBuffer()->text->cursor;
      bufferview_one->getKCanvas()->setFocus();
      bufferview_one->currentBuffer()->text->SetCursor(bufferview_one_cursor.par,bufferview_one_cursor.pos);
   }
}

bool LyXView::isSplitted(){
  return bufferview_two != 0;
}


//void LyXView::setPosition(int x, int y)
//{
//#warning Do we still need this? Kalle
//}


void LyXView::init()
{
	// Set the textclass choice
	invalidateLayoutChoice();
	updateToolbars();
	UpdateDocumentClassChoice();
	
// 	// Start autosave timer
// 	if (lyxrc->autosave)
// 		fl_set_timer(_form_main->timer_autosave, lyxrc->autosave);
	
	
        intl->InitKeyMapper(lyxrc->use_kbmap);
}


void LyXView::invalidateLayoutChoice()
{
	last_textclass = -1;
}


void LyXView::updateToolbars()
{
    if( ScreenToolbarsDialog::ALWAYS_VISIBLE == global_toolbar_visibilities.tables_toolbar
	&& ! tabletoolbar->isVisible() )
	_k_tlw->enableToolBar(KToolBar::Show, TABLETOOLBAR);
    if( global_toolbar_visibilities.tables_toolbar == ScreenToolbarsDialog::NEVER_VISIBLE
	&& tabletoolbar->isVisible() )
	_k_tlw->enableToolBar(KToolBar::Hide, TABLETOOLBAR);

    if (global_toolbar_visibilities.character_toolbar == ScreenToolbarsDialog::ALWAYS_VISIBLE
	&& !chartoolbar->isVisible())
	_k_tlw->enableToolBar(KToolBar::Show, CHARTOOLBAR);
    if (global_toolbar_visibilities.character_toolbar == ScreenToolbarsDialog::NEVER_VISIBLE
	&& chartoolbar->isVisible())
	_k_tlw->enableToolBar(KToolBar::Hide, CHARTOOLBAR);

    if (global_toolbar_visibilities.general_toolbar == ScreenToolbarsDialog::ALWAYS_VISIBLE
	&& !toolbar->isVisible())
	_k_tlw->enableToolBar(KToolBar::Show, STANDARDTOOLBAR);
    if (global_toolbar_visibilities.general_toolbar == ScreenToolbarsDialog::NEVER_VISIBLE
	&& toolbar->isVisible())
	_k_tlw->enableToolBar(KToolBar::Hide, STANDARDTOOLBAR);

    if (global_toolbar_visibilities.math_toolbar == ScreenToolbarsDialog::ALWAYS_VISIBLE
	&& !mathtoolbar->isVisible())
	_k_tlw->enableToolBar(KToolBar::Show, MATHTOOLBAR);
    if (global_toolbar_visibilities.math_toolbar == ScreenToolbarsDialog::NEVER_VISIBLE
	&& mathtoolbar->isVisible())
	_k_tlw->enableToolBar(KToolBar::Hide, MATHTOOLBAR);

    // this has a bi-effect that the layouts are not showed when no
    // document is loaded.
    if ( bufferview==0 || bufferview->currentBuffer()==0 ) {
	_layoutcombo->clear();
	_layoutcombo->setEnabled( false ); // no entry left
	return;	
    }

    // If textclass is different, we need to update the list
    if ( !_layoutcombo->count() || ( last_textclass != currentBuffer()->params.textclass ) ) {
	_layoutcombo->clear();
	_layoutcombo->setEnabled( false );
	for (int i = 0; lyxstyle.NameOfLayout( currentBuffer()-> params.textclass, i) !="@@end@@"; i++) {
	    LyXLayout *layout = lyxstyle.
		Style(currentBuffer()->params.textclass, i);
	    if ( layout->obsoleted_by.empty() )
		_layoutcombo->insertItem( layout->name.c_str() );
	    else
		_layoutcombo->insertItem( (layout->name).c_str() );
	    _layoutcombo->setEnabled( true ); // there is at least one item now
	}
	last_textclass = currentBuffer()->params.textclass;
    }
	
    char layout = currentBuffer()->text->cursor.par->GetLayout();
	
    if ( layout != _layoutcombo->currentItem() ) {
	_layoutcombo->setCurrentItem( layout );
    }


    // maybe we are in a table?

    LyXTable *table = current_view->currentBuffer()->text->cursor.par->table;

    if (global_toolbar_visibilities.tables_toolbar == ScreenToolbarsDialog::AUTOMATIC){
	if ((tabletoolbar->isVisible() && !table)
	    || (!tabletoolbar->isVisible() && table)){
	    currentView()->getScreen()->HideCursor();
	    _k_tlw->enableToolBar(KToolBar::Toggle, TABLETOOLBAR);
	}
    }

    if (table){
	int
	    align,
	    cell,
	    column,row;
	LString
	    pwidth;

	cell = currentBuffer()->text->
	    NumberOfCell(currentBuffer()->text->cursor.par,
			 currentBuffer()->text->cursor.pos);
	column = table->column_of_cell(cell)+1;
	row = table->row_of_cell(cell)+1;
	align = table->GetAlignment(cell);
	pwidth = table->GetPWidth(cell);


	if (table->LeftLine(cell)
	    != tabletoolbar->isButtonOn(TABLETOOLBAR_BORDER_LEFT))
	    tabletoolbar->setButton(TABLETOOLBAR_BORDER_LEFT,
				    table->LeftLine(cell));
	if (table->RightLine(cell)
	    != tabletoolbar->isButtonOn(TABLETOOLBAR_BORDER_RIGHT))
	    tabletoolbar->setButton(TABLETOOLBAR_BORDER_RIGHT,
				    table->RightLine(cell));
	if (table->TopLine(cell)
	    != tabletoolbar->isButtonOn(TABLETOOLBAR_BORDER_TOP))
	    tabletoolbar->setButton(TABLETOOLBAR_BORDER_TOP,
				    table->TopLine(cell));
	if (table->BottomLine(cell)
	    != tabletoolbar->isButtonOn(TABLETOOLBAR_BORDER_BOTTOM))
	    tabletoolbar->setButton(TABLETOOLBAR_BORDER_BOTTOM,
				    table->BottomLine(cell));

	if (table->IsMultiColumn(cell)
	    != tabletoolbar->isButtonOn(TABLETOOLBAR_MULTICOLUMN))
	    tabletoolbar->setButton(TABLETOOLBAR_MULTICOLUMN,
				    table->IsMultiColumn(cell));

	if (align == LYX_ALIGN_LEFT &&
	    !tabletoolbar->isButtonOn(TABLETOOLBAR_ALIGN_LEFT)){
	    tabletoolbar->setButton(TABLETOOLBAR_ALIGN_LEFT, true);
	    tabletoolbar->setButton(TABLETOOLBAR_ALIGN_RIGHT, false);
	    tabletoolbar->setButton(TABLETOOLBAR_ALIGN_CENTER, false);
	}
	if (align == LYX_ALIGN_RIGHT &&
	    !tabletoolbar->isButtonOn(TABLETOOLBAR_ALIGN_RIGHT)){
	    tabletoolbar->setButton(TABLETOOLBAR_ALIGN_LEFT, false);
	    tabletoolbar->setButton(TABLETOOLBAR_ALIGN_RIGHT, true);
	    tabletoolbar->setButton(TABLETOOLBAR_ALIGN_CENTER, false);
	}
	if (align == LYX_ALIGN_CENTER &&
	    !tabletoolbar->isButtonOn(TABLETOOLBAR_ALIGN_CENTER)){
	    tabletoolbar->setButton(TABLETOOLBAR_ALIGN_LEFT, false);
	    tabletoolbar->setButton(TABLETOOLBAR_ALIGN_RIGHT, false);
	    tabletoolbar->setButton(TABLETOOLBAR_ALIGN_CENTER, true);
	}
	if (table->RotateCell(cell)
	    != tabletoolbar->isButtonOn(TABLETOOLBAR_ROTATE_CELL))
	    tabletoolbar->setButton(TABLETOOLBAR_ROTATE_CELL,
				    table->RotateCell(cell));

	if (!pwidth.empty()
	    != tabletoolbar->isButtonOn(TABLETOOLBAR_WIDTH_OF_COLUMN))
	    tabletoolbar->setButton(TABLETOOLBAR_WIDTH_OF_COLUMN,
				    !pwidth.empty());

	int tstyle = tabletoolbar->getCombo(TABLETOOLBAR_STYLE_COMBO)->currentItem();

	int tstylenew = 0;
	if (table->IsLongTable())
	    tstylenew = TABLE_STYLE_LONG;
	else if (table->RotateTable())
	    tstylenew = TABLE_STYLE_ROTATE;
	else
	    tstylenew = TABLE_STYLE_NORMAL;

	if (tstylenew != tstyle){
	    tstyle = tstylenew;
	    tabletoolbar->getCombo(TABLETOOLBAR_STYLE_COMBO)->setCurrentItem(tstyle);
	}

	int tlitem = TABLE_LONG_NORMAL;
	if ((tstyle == TABLE_STYLE_LONG) !=
	    tabletoolbar->getCombo(TABLETOOLBAR_LONG_COMBO)->isEnabled())
	    tabletoolbar->getCombo(TABLETOOLBAR_LONG_COMBO)
		->setEnabled(tstyle == TABLE_STYLE_LONG);
	if (tstyle == TABLE_STYLE_LONG){
	    if (table->RowOfLTFirstHead(cell))
		tlitem = TABLE_LONG_FIRST_HEAD;
	    else if (table->RowOfLTHead(cell))
		tlitem = TABLE_LONG_HEAD;
	    else if (table->RowOfLTFoot(cell))
		tlitem = TABLE_LONG_FOOT;
	    else if (table->RowOfLTLastFoot(cell))
		tlitem = TABLE_LONG_LAST_FOOT;
	    else if (table->LTNewPage(cell))
		tlitem = TABLE_LONG_NEW_PAGE;
	}

	if (tabletoolbar->getCombo(TABLETOOLBAR_LONG_COMBO)->currentItem()
	    != tlitem)
	    tabletoolbar->getCombo(TABLETOOLBAR_LONG_COMBO)->setCurrentItem(tlitem);
    }

    if( ScreenToolbarsDialog::AUTOMATIC == global_toolbar_visibilities.math_toolbar ){
	bool math =  (currentView()->currentBuffer()->the_locking_inset != 0);
	if ((mathtoolbar->isVisible() && !math)
	    || (!mathtoolbar->isVisible() && math)){
	    currentView()->getScreen()->HideCursor();
	    _k_tlw->enableToolBar(KToolBar::Toggle, MATHTOOLBAR);
	}
    }

}


void LyXView::UpdateDocumentClassChoice()
{
  /* update the document class display in the document form */
  int i;
  if( dialogs()->document == 0 )
    {
      // it would be nicer if the parent was k_tlw, but this won't work
      // with modeless dialogs (Kalle, 27.11.97)
      dialogs()->document = new DocumentLayoutDialog(toplevelWidget() );
      dialogs()->documentreceiver = new DocumentLayoutDialogReceiver(dialogs()->document);
    }

  dialogs()->document->classCombo()->clear();
  for (i = 0; lyxstyle.DescOfClass (i)!="@@end@@"; i++) {
    dialogs()->document->classCombo()->insertItem( lyxstyle.DescOfClass(i).c_str());
  }
}


void LyXView::updateWindowTitle()
    // Updates the title of the window with the filename of the current document
{
    LString title = "KLyX";

    if( currentView()->available() ) {
	LString cur_title = currentBuffer()->getFileName();
	if( ! cur_title.empty() ){
	    title += ": " + OnlyFilename( cur_title );
	    if( ! currentBuffer()->isLyxClean() )
		title += i18n( " (Changed)" );
	    else if( currentBuffer()->isReadonly() )
		title += i18n( " (read only)" );
	}
    }
    // Don't update title if it's the same as last time
    if( title != (const char*) _k_tlw->caption() ) {
	_k_tlw->setCaption( title.c_str() );
    }
}


void LyXView::dropActionSlot( KDNDDropZone* _dropzone )
{
fprintf( stderr, "LyXView::dropActionSlot()\n" );
  QStrList urls = _dropzone->getURLList();

  char* url = urls.first();
  while( url )
	{
	  QString urlstring( url );
#warning Make this work with all URLs when file loading is switched to kfm	
	  if( urlstring.left( 5 ) == "file:" )
		{
		  QString filename = urlstring.right( urlstring.length() - 5 );
		  fprintf( stderr, "Opening %s\n", filename.data() );
		  // loads document
		  getMiniBuffer()->Set(i18n("Opening document"),
							   MakeDisplayPath(filename.data()), "...");
		  Buffer * openbuf = bufferlist.loadLyXFile(LString(filename.data()),true);
		  if (openbuf) {
			currentView()->setBuffer(openbuf);
			getMiniBuffer()->Set(i18n("Document"),
								 MakeDisplayPath(filename.data()),
								 i18n("opened."));
		  } else {
			getMiniBuffer()->Set(i18n("Could not open document"),
								 MakeDisplayPath(filename.data()));
		  }
		}
	  url = urls.next();
	};
}



QPrinter * LyXView::klyxPrinter()
{
    return _klyxprinter;
};



// Local Variables:
// mode: C++
// c-file-style: "Stroustrup"
// End:
