/* -*- mode:C++; c-file-style: "Stroustrup" -*-
 *
 * $Id: KLyXToolBar.C,v 1.30 1999/01/29 12:57:10 kuepper Exp $ 
 */

#include <kapp.h>
#include <klocale.h>

#include "KLyXToolBar.h"
#include "error.h"
#include "commandtags.h"
#include "LyXView.h"
#include "lyxfunc.h"
#include "lyxrc.h"
#include "klyx.h"
#include "MathBrowsers.h"
#include "MathDelimiterDialog.h"
#include "MathMatrixDialog.h"
#include "MathSpacingDialog.h"
#include "CharacterStyleDialog.h"
#include "minibuffer.h"
#include "TableDialog.h"
#include "lyx_gui_misc.h"

extern LyXRC* lyxrc;

/* Latex code for those bitmaps */
static char const *latex_greek[] =  {
   "Gamma", "Delta", "Theta", "Lambda", "Xi", "Pi",
   "Sigma", "Upsilon", "Phi", "Psi", "Omega", "",
   "alpha", "beta", "gamma", "delta", "epsilon", "varepsilon", "zeta",
   "eta", "theta", "vartheta", "iota", "kappa", "lambda", "mu",
   "nu", "xi", "pi", "varpi", "rho", "sigma", "varsigma",
   "tau", "upsilon", "phi", "varphi", "chi", "psi", "omega"
};

static char const *latex_brel[] = {
  "leq", "geq", "equiv", "models", 
  "prec", "succ", "sim", "perp", 
  "preceq", "succeq", "simeq", "mid", 
  "ll", "gg", "asymp", "parallel", 
  "subset", "supset", "approx", "smile", 
  "subseteq", "supseteq", "cong", "frown", 
  "sqsubseteq", "sqsupseteq", "doteq", "neq", 
  "in", "ni", "propto", "notin", 
  "vdash", "dashv", "bowtie"
};

static char const *latex_bop[] = {
  "pm", "mp", "setminus", "cdot", "times", "star", "diamond",
  "circ", "bullet", "div", "cap", "cup", "uplus", "sqcap", 
  "sqcup", "triangleleft", "triangleright", "wr", "bigcirc", "bigtriangleup",
  "bigtriangledown",
  "vee", "wedge", "oplus", "ominus", "otimes", "oslash", "odot",
  "dagger", "ddagger", "amalg"
};

static char const *latex_arrows[] = {
  "leftarrow", "rightarrow", "uparrow", "downarrow",
  "Leftarrow", "Rightarrow", "Uparrow", "Downarrow",
  "updownarrow", "leftrightarrow", "Updownarrow", "Leftrightarrow",
  "leftharpoonup", "rightharpoonup", "leftharpoondown", "rightharpoondown",
  "hookleftarrow", "hookrightarrow", "rightleftharpoons", "mapsto"
};


static char const *latex_varsz[] = {
  "sum", "prod", "coprod", "int", "oint",
  "bigcap", "bigcup", "bigwedge", "bigvee", "bigsqcup",
  "bigotimes", "bigodot", "bigoplus", "biguplus"
};


static char const *latex_misc[] = {
  "nabla", "partial", "infty", "prime", "ell",
  "emptyset", "exists", "forall", "imath", "jmath",
  "Re", "Im", "aleph", "wp", "hbar",
  "angle", "top", "bot", "Vert", "neg",
  "flat", "natural", "sharp", "surd", "triangle",
  "clubsuit", "spadesuit", "heartsuit", "diamondsuit"
};

static char const *func_code[] = {
    "arccos", "arcsin", "arctan", "arg", "bmod",
    "cos", "cosh", "cot", "coth", "csc", "deg",
    "det", "dim", "exp", "gcd", "hom", "inf", "ker",
    "lg", "lim", "liminf", "limsup", "ln", "log",
    "max", "min", "sec", "sin", "sinh", "sup",
    "tan", "tanh"
};

void KLyXToolBarReceiver::fileNew()		// Rocher 981124
{
  LString res = _view->getLyXFunc()->Dispatch( LFUN_MENUNEW );
  if(!res.empty())
	lyxerr.print(res); 
}

void KLyXToolBarReceiver::fileNewTmplt()	// Rocher 981124
{
  LString res = _view->getLyXFunc()->Dispatch( LFUN_MENUNEWTMPLT );
  if(!res.empty())
	lyxerr.print(res); 
}

void KLyXToolBarReceiver::open()
{
  LString res = _view->getLyXFunc()->Dispatch( LFUN_MENUOPEN );
  if(!res.empty())
	lyxerr.print(res); 
}

void KLyXToolBarReceiver::write()
{
  LString res = _view->getLyXFunc()->Dispatch( LFUN_MENUWRITE );
  if(!res.empty())
	lyxerr.print(res); 
}

void KLyXToolBarReceiver::previewCustom()	// Rocher 981124
{
  LString res = _view->getLyXFunc()->Dispatch( LFUN_PREVIEWCUSTOM );
  if(!res.empty())
	lyxerr.print(res); 
}

void KLyXToolBarReceiver::previewUpdate()	// Rocher 981124
{
  LString res = _view->getLyXFunc()->Dispatch( LFUN_PREVIEWUPDATE );
  if(!res.empty())
	lyxerr.print(res); 
}

void KLyXToolBarReceiver::print()
{
  LString res = _view->getLyXFunc()->Dispatch( LFUN_MENUPRINT );
  if(!res.empty())
	lyxerr.print(res); 
}

void KLyXToolBarReceiver::cut()
{
  LString res = _view->getLyXFunc()->Dispatch( LFUN_CUT );
  if(!res.empty())
	lyxerr.print(res); 
}

void KLyXToolBarReceiver::copy()
{
  LString res = _view->getLyXFunc()->Dispatch( LFUN_COPY );
  if(!res.empty())
	lyxerr.print(res); 
}

void KLyXToolBarReceiver::paste()
{
  LString res = _view->getLyXFunc()->Dispatch( LFUN_PASTE );
  if(!res.empty())
	lyxerr.print(res); 
}

void KLyXToolBarReceiver::emph()
{
  LString res = _view->getLyXFunc()->Dispatch( LFUN_EMPH );
  if(!res.empty())
	lyxerr.print(res); 
}

void KLyXToolBarReceiver::noun()
{
  LString res = _view->getLyXFunc()->Dispatch( LFUN_NOUN );
  if(!res.empty())
	lyxerr.print(res); 
}

void KLyXToolBarReceiver::free()
{
  LString res = _view->getLyXFunc()->Dispatch( LFUN_FREE );
  if(!res.empty())
	lyxerr.print(res); 
}

void KLyXToolBarReceiver::footmelt()
{
  LString res = _view->getLyXFunc()->Dispatch( LFUN_FOOTMELT );
  if(!res.empty())
	lyxerr.print(res); 
}

void KLyXToolBarReceiver::marginmelt()
{
  LString res = _view->getLyXFunc()->Dispatch( LFUN_MARGINMELT );
  if(!res.empty())
	lyxerr.print(res); 
}

void KLyXToolBarReceiver::depth()
{
  LString res = _view->getLyXFunc()->Dispatch( LFUN_DEPTH );
  if(!res.empty())
	lyxerr.print(res); 
}

void KLyXToolBarReceiver::tex()
{
  LString res = _view->getLyXFunc()->Dispatch( LFUN_TEX );
  if(!res.empty())
	lyxerr.print(res); 
}

void KLyXToolBarReceiver::mathmode()
{
  LString res = _view->getLyXFunc()->Dispatch( LFUN_MATH_MODE );
  if(!res.empty())
	lyxerr.print(res); 
}

void KLyXToolBarReceiver::figure()
{
  LString res = _view->getLyXFunc()->Dispatch( LFUN_FIGURE );
  if(!res.empty())
	lyxerr.print(res); 
}

void KLyXToolBarReceiver::table()
{
  LString res = _view->getLyXFunc()->Dispatch( LFUN_TABLE );
  if(!res.empty())
	lyxerr.print(res); 
}

void KLyXToolBarReceiver::layoutComboActivated( int item )
{
  LString tmp;
  tmp += item + 1;
  
  char layout = -1;
  if (_view->currentBuffer()->text)
    layout = _view->currentBuffer()->text->cursor.par->GetLayout();

  if (item != layout)
    _view->getLyXFunc()->Dispatch( LFUN_LAYOUTNO,
				   tmp.c_str() );
}


void KLyXToolBarReceiver::squareroot()
{
  _view->getLyXFunc()->Dispatch( LFUN_INSERT_MATH, "sqrt" );
}


void KLyXToolBarReceiver::fraction()
{
  _view->getLyXFunc()->Dispatch( LFUN_INSERT_MATH, "frac" );
}


void KLyXToolBarReceiver::sum()
{
  _view->getLyXFunc()->Dispatch( LFUN_INSERT_MATH, "sum" );
}

void KLyXToolBarReceiver::integral()
{
  _view->getLyXFunc()->Dispatch( LFUN_INSERT_MATH, "int" );
}

void KLyXToolBarReceiver::exponent()
{
  _view->getLyXFunc()->Dispatch( LFUN_INSERT_MATH, "^" );
}

void KLyXToolBarReceiver::index()
{
  _view->getLyXFunc()->Dispatch( LFUN_INSERT_MATH, "_" );
}


void KLyXToolBarReceiver::delimiter()
{
	if( !_view->dialogs()->mathdelimiter )
		_view->dialogs()->mathdelimiter = new MathDelimiterDialog( _view, NULL );

	if( !_view->dialogs()->mathdelimiter->isVisible() )
		_view->dialogs()->mathdelimiter->show();
}


void KLyXToolBarReceiver::decoration()
{
  if( !_view->dialogs()->mathdecobrowser )
	_view->dialogs()->mathdecobrowser = new MathDecoBrowser();

  QWidget* trigger = _view->getMathToolbar()->getButton( MATHTOOLBAR_DECORATION );
  int ret = _view->dialogs()->mathdecobrowser->exec( trigger );
  QEvent ev( Event_Leave );
  QMouseEvent mev ( Event_MouseButtonRelease, 
					QCursor::pos(), LeftButton, LeftButton );
  QApplication::sendEvent( trigger, &ev );
  QApplication::sendEvent( trigger, &mev );
  switch( ret )
	{
	case 0:
	  _view->getLyXFunc()->Dispatch( LFUN_INSERT_MATH, "widehat" );
	  break;
	case 1:
	  _view->getLyXFunc()->Dispatch( LFUN_INSERT_MATH, "widetilde" );
	  break;
	case 2:
	  _view->getLyXFunc()->Dispatch( LFUN_INSERT_MATH, "overbrace" );
	  break;
	case 3:
	  _view->getLyXFunc()->Dispatch( LFUN_INSERT_MATH, "overleftarrow" );
	  break;
	case 4:
	  _view->getLyXFunc()->Dispatch( LFUN_INSERT_MATH, "overrightarrow" );
	  break;
	case 5:
	  _view->getLyXFunc()->Dispatch( LFUN_INSERT_MATH, "overline" );
	  break;
	case 6:
	  _view->getLyXFunc()->Dispatch( LFUN_INSERT_MATH, "underbrace" );
	  break;
	case 7:
	  _view->getLyXFunc()->Dispatch( LFUN_INSERT_MATH, "underline" );
	  break;
	};
}


void KLyXToolBarReceiver::function()
{
    if( !_view->dialogs()->mathfuncbrowser )
	_view->dialogs()->mathfuncbrowser = new MathFunctionBrowser();

    QWidget* trigger = _view->getMathToolbar()->getButton( MATHTOOLBAR_FUNCTION );
    int ret = _view->dialogs()->mathfuncbrowser->exec( trigger );
    QEvent ev( Event_Leave );
    QMouseEvent mev( Event_MouseButtonRelease, QCursor::pos(), LeftButton, LeftButton );
    QApplication::sendEvent( trigger, &ev );
    QApplication::sendEvent( trigger, &mev );
    if( ret >= 0 )
	_view->getLyXFunc()->Dispatch( LFUN_INSERT_MATH, func_code[ ret ] );
}




void KLyXToolBarReceiver::spacing()
{
	if( !_view->dialogs()->mathspacing )
		_view->dialogs()->mathspacing = new MathSpacingDialog( _view, NULL );

	if( !_view->dialogs()->mathspacing->isVisible() )
		_view->dialogs()->mathspacing->show();
}


void KLyXToolBarReceiver::matrix()
{
	if( !_view->dialogs()->mathmatrix )
	  _view->dialogs()->mathmatrix = new MathMatrixDialog( _view, 
							       _view->toplevelWidget());

  MathMatrixDialog* mathmatrix = _view->dialogs()->mathmatrix;
  int ret = _view->dialogs()->mathmatrix->exec();
  _view->dialogs()->mathmatrix = mathmatrix;

  if( ret == QDialog::Accepted )
	{
	  int nx, ny;
	  static char v_align_c[] = "tcb";

	  MathMatrixDialogData *dlg_data = _view->dialogs()->mathmatrix->data();
	  char s[80];
	  char c = v_align_c[(int)dlg_data->vert_align];
	  char const *sh = dlg_data->horz_align;
	  nx = (int)(dlg_data->num_cols+0.5);
	  ny = (int)(dlg_data->num_rows+0.5);
	  sprintf(s, "%d %d %c%s", nx, ny, c, sh);      
	  _view->getLyXFunc()->Dispatch(LFUN_INSERT_MATRIX, s);
	}
}


void KLyXToolBarReceiver::equation()
{
  _view->getLyXFunc()->Dispatch( LFUN_MATH_DISPLAY, "frac" );
}


void KLyXToolBarReceiver::greek()
{
  if( !_view->dialogs()->mathgreekbrowser )
	_view->dialogs()->mathgreekbrowser = new MathGreekBrowser();

  QWidget* trigger = _view->getMathToolbar()->getButton( MATHTOOLBAR_GREEK );
  int ret = _view->dialogs()->mathgreekbrowser->exec( trigger );
  QEvent ev( Event_Leave );
  QMouseEvent mev ( Event_MouseButtonRelease, 
					QCursor::pos(), LeftButton, LeftButton );
  QApplication::sendEvent( trigger, &ev );
  QApplication::sendEvent( trigger, &mev );

  if( ret != -1 && ret != 11 && ret <= 39 ) // skip unused fields
	{
	  char const *s = 0;
	  s = latex_greek[ ret ]; 

	  if (s)  {
	        if (_view->currentView()->available() && lyxrc->display_shortcuts) {
		  _view->getMiniBuffer()->Set("Inserting symbol ", s );
		}
		_view->getLyXFunc()->Dispatch(LFUN_INSERT_MATH, s);
	  }      
	}
}


void KLyXToolBarReceiver::boperators()
{
  if( !_view->dialogs()->mathbinopbrowser )
	_view->dialogs()->mathbinopbrowser = new MathBinOpBrowser();

  QWidget* trigger = _view->getMathToolbar()->getButton( MATHTOOLBAR_BOPERATOR );
  int ret = _view->dialogs()->mathbinopbrowser->exec( trigger );
  QEvent ev( Event_Leave );
  QMouseEvent mev ( Event_MouseButtonRelease, 
					QCursor::pos(), LeftButton, LeftButton );
  QApplication::sendEvent( trigger, &ev );
  QApplication::sendEvent( trigger, &mev );

  if( ret != -1 && ret < 31 )
	{
	  char const *s = 0;
	  s = latex_bop[ ret ]; 

	  if (s)  {
		if (_view->currentView()->available() && lyxrc->display_shortcuts) {
		  _view->getMiniBuffer()->Set("Inserting symbol ", s );
		}
		_view->getLyXFunc()->Dispatch(LFUN_INSERT_MATH, s);
	  }      
	}
}


void KLyXToolBarReceiver::brelations()
{
  if( !_view->dialogs()->mathbinrelbrowser )
	_view->dialogs()->mathbinrelbrowser = new MathBinRelBrowser();

  QWidget* trigger = _view->getMathToolbar()->getButton( MATHTOOLBAR_BRELATION );
  int ret = _view->dialogs()->mathbinrelbrowser->exec( trigger );
  QEvent ev( Event_Leave );
  QMouseEvent mev ( Event_MouseButtonRelease, 
					QCursor::pos(), LeftButton, LeftButton );
  QApplication::sendEvent( trigger, &ev );
  QApplication::sendEvent( trigger, &mev );

  if( ret != -1 )
	{
	  char const *s = 0;
	  s = latex_brel[ ret ]; 

	  if (s)  {
		if (_view->currentView()->available() && lyxrc->display_shortcuts) {
		  _view->getMiniBuffer()->Set("Inserting symbol ", s );
		}
		_view->getLyXFunc()->Dispatch(LFUN_INSERT_MATH, s);
	  }      
	}
}


void KLyXToolBarReceiver::arrows()
{
  if( !_view->dialogs()->matharrowbrowser )
	_view->dialogs()->matharrowbrowser = new MathArrowBrowser();

  QWidget* trigger = _view->getMathToolbar()->getButton( MATHTOOLBAR_ARROW );
  int ret = _view->dialogs()->matharrowbrowser->exec( trigger );
  QEvent ev( Event_Leave );
  QMouseEvent mev ( Event_MouseButtonRelease, 
					QCursor::pos(), LeftButton, LeftButton );
  QApplication::sendEvent( trigger, &ev );
  QApplication::sendEvent( trigger, &mev );

  if( ret != -1 )
	{
	  char const *s = 0;
	  s = latex_arrows[ ret ]; 

	  if (s)  {
		if (_view->currentView()->available() && lyxrc->display_shortcuts) {
		  _view->getMiniBuffer()->Set("Inserting symbol ", s );
		}
		_view->getLyXFunc()->Dispatch(LFUN_INSERT_MATH, s);
	  }      
	}
}


void KLyXToolBarReceiver::varsize()
{
  if( !_view->dialogs()->mathvarsizebrowser )
	_view->dialogs()->mathvarsizebrowser = new MathVarSizeBrowser();

  QWidget* trigger = _view->getMathToolbar()->getButton( MATHTOOLBAR_VARSIZE );
  int ret = _view->dialogs()->mathvarsizebrowser->exec( trigger );
  QEvent ev( Event_Leave );
  QMouseEvent mev ( Event_MouseButtonRelease, 
					QCursor::pos(), LeftButton, LeftButton );
  QApplication::sendEvent( trigger, &ev );
  QApplication::sendEvent( trigger, &mev );

  if( ret != -1 && ret != 14 )
	{
	  char const *s = 0;
	  s = latex_varsz[ ret ]; 

	  if (s)  {
		if (_view->currentView()->available() && lyxrc->display_shortcuts) {
		  _view->getMiniBuffer()->Set("Inserting symbol ", s );
		}
		_view->getLyXFunc()->Dispatch(LFUN_INSERT_MATH, s);
	  }      
	}
}


void KLyXToolBarReceiver::misc()
{
  if( !_view->dialogs()->mathmiscbrowser )
	_view->dialogs()->mathmiscbrowser = new MathMiscBrowser();

  QWidget* trigger = _view->getMathToolbar()->getButton( MATHTOOLBAR_MISC );
  int ret = _view->dialogs()->mathmiscbrowser->exec( trigger );
  QEvent ev( Event_Leave );
  QMouseEvent mev ( Event_MouseButtonRelease, 
					QCursor::pos(), LeftButton, LeftButton );
  QApplication::sendEvent( trigger, &ev );
  QApplication::sendEvent( trigger, &mev );

  if( ret != -1 && ret != 29 )
	{
	  char const *s = 0;
	  s = latex_misc[ ret ]; 

	  if (s)  {
		if (_view->currentView()->available() && lyxrc->display_shortcuts) {
		  _view->getMiniBuffer()->Set("Inserting symbol ", s );
		}
		_view->getLyXFunc()->Dispatch(LFUN_INSERT_MATH, s);
	  }      
	}
}


void KLyXToolBarReceiver::tableStyleComboActivated(int arg){
  if (arg == TABLE_STYLE_NORMAL)
    tableUpdate(TABLETOOLBAR_NORMAL_TABLE);
  else if (arg == TABLE_STYLE_LONG)
    tableUpdate(TABLETOOLBAR_LONG_TABLE);
  else if (arg == TABLE_STYLE_ROTATE)
    tableUpdate(TABLETOOLBAR_ROTATE_TABLE);
  _view->updateToolbars();
}

void KLyXToolBarReceiver::tableLongComboActivated(int arg){
  switch (arg){
  case TABLE_LONG_NORMAL:
    tableUpdate(TABLETOOLBAR_LONG_NORMAL);
    break;
  case TABLE_LONG_FIRST_HEAD:
    tableUpdate(TABLETOOLBAR_LONG_FIRST_HEAD);
    break;
  case TABLE_LONG_HEAD:
    tableUpdate(TABLETOOLBAR_LONG_HEAD);
    break;
  case TABLE_LONG_FOOT:
    tableUpdate(TABLETOOLBAR_LONG_FOOT);
    break;
  case TABLE_LONG_LAST_FOOT:
    tableUpdate(TABLETOOLBAR_LONG_LAST_FOOT);
    break;
  case TABLE_LONG_NEW_PAGE:
    tableUpdate(TABLETOOLBAR_LONG_NEW_PAGE);
    break;
  }
}

void KLyXToolBarReceiver::tableUpdate(int arg){
  LyXTable *table = 0;

  if (_view->currentBuffer())
    table = _view->currentBuffer()->text->cursor.par->table;
  if (table){
    int
      align,
      cell,
      column,row,
      num = 0;
    LString
      pwidth;
    
    cell = _view->currentBuffer()->text->
      NumberOfCell(_view->currentBuffer()->text->cursor.par, 
		   _view->currentBuffer()->text->cursor.pos);
    column = table->column_of_cell(cell)+1;
    row = table->row_of_cell(cell)+1;
    align = table->GetAlignment(cell);
    pwidth = table->GetPWidth(cell);
    
    KToolBar* tabletoolbar = _view->getTableToolbar();
    
    switch (arg) {
    case TABLETOOLBAR_MULTICOLUMN:
      num = LyXTable::MULTICOLUMN;
      break;
    case TABLETOOLBAR_BORDER_LEFT:
      num = LyXTable::TOGGLE_LINE_LEFT;
      break;
    case TABLETOOLBAR_BORDER_RIGHT:
      num = LyXTable::TOGGLE_LINE_RIGHT;
      break;
    case TABLETOOLBAR_BORDER_TOP:
      num = LyXTable::TOGGLE_LINE_TOP;
      break;
    case TABLETOOLBAR_BORDER_BOTTOM:
      num = LyXTable::TOGGLE_LINE_BOTTOM;
      break;
    case TABLETOOLBAR_APPEND_ROW:
      num = LyXTable::APPEND_ROW;
      break;
    case TABLETOOLBAR_APPEND_COLUMN:
      num = LyXTable::APPEND_COLUMN;
      break;
    case TABLETOOLBAR_DELETE_ROW:
      num = LyXTable::DELETE_ROW;
      break;
    case TABLETOOLBAR_DELETE_COLUMN:
      num = LyXTable::DELETE_COLUMN;
      break;
    case TABLETOOLBAR_DELETE_TABLE:
      num = LyXTable::DELETE_TABLE;
      break;
    case TABLETOOLBAR_ALIGN_LEFT:
      tabletoolbar->setButton(TABLETOOLBAR_ALIGN_RIGHT, false);
      tabletoolbar->setButton(TABLETOOLBAR_ALIGN_CENTER, false);
      num = LyXTable::ALIGN_LEFT;
      break;
    case TABLETOOLBAR_ALIGN_RIGHT:
      if (!pwidth.empty() && !table->IsMultiColumn(cell)) {
	tabletoolbar->setButton(TABLETOOLBAR_ALIGN_RIGHT, false);
	WriteAlert(i18n("Wrong Alignment."), 
		   i18n("Non multicolumn cells with fixed width can only\nbe left aligned in LaTeX."), 
		   i18n("sorry.")); 
	return;
      }

      tabletoolbar->setButton(TABLETOOLBAR_ALIGN_LEFT, false);
      tabletoolbar->setButton(TABLETOOLBAR_ALIGN_CENTER, false);
      num = LyXTable::ALIGN_RIGHT;
      break;
    case TABLETOOLBAR_ALIGN_CENTER:
      if (!pwidth.empty() && !table->IsMultiColumn(cell)) {
	tabletoolbar->setButton(TABLETOOLBAR_ALIGN_CENTER, false);
	WriteAlert(i18n("Wrong Alignment."), 
		   i18n("Non multicolumn cells with fixed width can only\nbe left aligned in LaTeX."), 
		   i18n("sorry.")); 
	return;
      }
      tabletoolbar->setButton(TABLETOOLBAR_ALIGN_RIGHT, false);
      tabletoolbar->setButton(TABLETOOLBAR_ALIGN_LEFT, false);
      num = LyXTable::ALIGN_CENTER;
      break;
    case TABLETOOLBAR_ROTATE_CELL:
      if (tabletoolbar->isButtonOn(TABLETOOLBAR_ROTATE_CELL))
	num = LyXTable::SET_ROTATE_CELL;
      else
	num = LyXTable::UNSET_ROTATE_CELL;
      break;
    case TABLETOOLBAR_ROTATE_TABLE:
      num = LyXTable::SET_ROTATE_TABLE;
      break;
    case TABLETOOLBAR_LONG_TABLE:
      num = LyXTable::SET_LONGTABLE;
      break;
    case TABLETOOLBAR_NORMAL_TABLE:
      num = LyXTable::SET_NORMALTABLE;
      break;
    case TABLETOOLBAR_WIDTH_OF_COLUMN:
      if (tabletoolbar->isButtonOn(TABLETOOLBAR_WIDTH_OF_COLUMN)){
	LabelInput* labelinput = new LabelInput(_view->toplevelWidget(),
						i18n("Width of Column"));
	const char* s = labelinput->getString(i18n("Width of Column:"),
					      pwidth.c_str());
	
	if (s){
	  LString str = s;
	  if (str.empty()){
	    tabletoolbar->setButton(TABLETOOLBAR_WIDTH_OF_COLUMN, false);
	  } else if (!isValidLength(str)){
	    WriteAlert(i18n("You entered an invalid Length:"), 
		       s,
		       i18n("A valid example is \"25mm\"")); 
	    return;
	  }
	  if (_view->currentView()->available()){
	    _view->currentView()->getScreen()->HideCursor();
	    _view->currentView()->currentBuffer()->updateFull(false);
	    _view->currentView()->currentBuffer()
	      ->text->TableFeatures(LyXTable::SET_PWIDTH, str);
	    _view->currentView()->currentBuffer()->updateFull();
	  }
	}
      }
      return;
      break;
    case TABLETOOLBAR_LONG_NORMAL:
      num = LyXTable::SET_LTNORMAL;
      break;
    case TABLETOOLBAR_LONG_FIRST_HEAD:
      num = LyXTable::SET_LTFIRSTHEAD;
      break;
    case TABLETOOLBAR_LONG_HEAD:
      num = LyXTable::SET_LTHEAD;
      break;
    case TABLETOOLBAR_LONG_FOOT:
      num = LyXTable::SET_LTFOOT;
      break;
    case TABLETOOLBAR_LONG_LAST_FOOT:
      num = LyXTable::SET_LTLASTFOOT;
      break;
    case TABLETOOLBAR_LONG_NEW_PAGE:
      num = LyXTable::SET_LTNEWPAGE;
      break;
    default:
      return;
    }

    if (_view->currentView()->available()){
      _view->currentView()->getScreen()->HideCursor();
      _view->currentView()->currentBuffer()->updateFull(false);
      _view->currentView()->currentBuffer()->text->TableFeatures(num);
      _view->currentView()->currentBuffer()->updateFull();
    }

  }
}

void KLyXToolBarReceiver::charComboIgnore(int){
}

void KLyXToolBarReceiver::charUpdate(){
  CharacterStyleDialogData tempdata;
  if(_view->currentView()->available()) {
    tempdata.family = (CharacterStyleDialogData::Family)
      _view->getCharToolbar()->getCombo(CHARTOOLBAR_FAMILY)->currentItem();
    tempdata.series = (CharacterStyleDialogData::Series)
      _view->getCharToolbar()->getCombo(CHARTOOLBAR_SERIES)->currentItem();
    tempdata.shape = (CharacterStyleDialogData::Shape)
      _view->getCharToolbar()->getCombo(CHARTOOLBAR_SHAPE)->currentItem();
    tempdata.size = (CharacterStyleDialogData::Size)
      _view->getCharToolbar()->getCombo(CHARTOOLBAR_SIZE)->currentItem();
    tempdata.misc = (CharacterStyleDialogData::Misc)
      _view->getCharToolbar()->getCombo(CHARTOOLBAR_MISC)->currentItem();
    tempdata.color = (CharacterStyleDialogData::Color)
      _view->getCharToolbar()->getCombo(CHARTOOLBAR_COLOR)->currentItem();
    // If the mask is completely neutral, tell user
    if (tempdata.font() == LyXFont(LyXFont::ALL_IGNORE)){
      _view->getMiniBuffer()->Set(i18n("No font change defined. You may want to "
					 "set some properties in the combo boxes..."));
      return;
    }
    
    _view->currentView()->getScreen()->HideCursor();
    _view->currentView()->currentBuffer()->updateFull(false);
    _view->currentView()->currentBuffer()->text->ToggleFree(tempdata.font());
    _view->currentView()->currentBuffer()->updateFull();
  }
}
