// -*- C++ -*-
/* This file is part of
 * ======================================================
 * 
 *           LyX, the High Level Word Processor
 *	     Copyright (C) 1995 Matthias Ettrich
 *        
 *           This file is Copyright (C) 1996, 1997
 *           Lars Gullik Bjnnes
 *
 * ======================================================
 */

#ifndef _DEP_TABLE_H
#define _DEP_TABLE_H

#include "LString.h"
#include <stdio.h>

class LString;

///
class DepTable {
public:
	///
	DepTable();
	///
	DepTable(LString const &f,
		 unsigned long one,
		 unsigned long two);
	///
	/** This one is a little bit harder since we need the absolute
	  filename. Should we insert files with .sty .cls etc as
	  extension? */
	void insert(LString const &f,
		    unsigned long one=0,
		    unsigned long two=0);
	///
	void update();

	///
	void write(LString const &f);
	///
	void read(LString const &f);
	/// returns true if any of the files has changed
	bool sumchange();
	///
	bool haschanged(LString const &fil);
private:
	///
	LString file;
	/// The files new checksum
	unsigned long new_sum;
	/// The files old checksum
	unsigned long old_sum;
	///
	DepTable *next;
		
	///
	void write(FILE *f);
};

#endif
