// -*- c++ -*-
/* Copyright (C) 1999 Claus Wilke <claus.wilke@gmx.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef KBIBLIODOC_H
#define KBIBLIODOC_H

#include <qdom.h>
#include <qobject.h>
#include <qdict.h>
#include <qstringlist.h>

class QString;
class QTextStream;


class BibEntryFieldType
{
public:
    enum DataType { AUTHORLIST, STRING, TEXT, NOTHING };

    BibEntryFieldType();
    BibEntryFieldType( const DataType &type, const QString &name,
		       const QString &description, bool editable = true );
    BibEntryFieldType( const BibEntryFieldType &ef );

    ~BibEntryFieldType();

    bool operator==( const BibEntryFieldType &ef2 ) const;

    bool operator!=( const BibEntryFieldType &ef2 ) const;

    DataType dataType() const;
    QString name() const;
    QString description() const;
    bool isEditable() const;

    void setEditable( bool editable = true );

private:
    DataType mType;
    QString mName;
    QString mDescription;
    bool mEditable;
};


class BibEntryType
{
public:
    BibEntryType( const QStringList &fieldsList, const QString &name, const QString &description );
    BibEntryType( const QString *fields, const QString &name, const QString &description );
    ~BibEntryType();

    bool operator==( const BibEntryType &entryType ) const;

    bool operator!=( const BibEntryType &entryType ) const;

    QString name() const;
    QString description() const;
    QStringList fieldTypesNames() const;

private:
    QStringList *mFieldsList;
    QString mName;
    QString mDescription;
};



class KBiblioDoc : public QObject
{
    Q_OBJECT
public:
    KBiblioDoc();
    ~KBiblioDoc();

    QDomDocument domDocument() const;

    QDomNode entryListNode() const;
    QDomElement firstEntry() const;

    void setContent( const QString &text );
    void setEmptyDoc();
    void addEntry( QDomElement entry );
    void removeEntry( QDomElement entry );
    void replaceEntry( QDomElement oldEntry, QDomElement newEntry );

    BibEntryFieldType* lookupEntryFieldType( const QString &name );
    BibEntryType* lookupEntryType( const QString &name );
    QStringList* lookupCompletionsList( const QString &fieldName );
    
    QStringList entryTypesNames();
    QStringList fieldTypesNames( const QString &entryName );
    QStringList allFieldTypesNames();

    void save( QTextStream &t ) const;

    bool edited() const;
    void setEdited( bool edited );

protected:
    void setupEntryFieldTypeDict();
    void setupEntryTypeDict();
    void setupCompletionsListDict();
    
private:
    bool mEdited;
    QStringList mEntryTypesNames;
    QStringList mFieldTypesNames;

    QDict<BibEntryFieldType> *mEntryFieldTypeDict;
    QDict<BibEntryType> *mEntryTypeDict;
    QDict<QStringList> *mCompletionsListDict;

    QDomDocument mDomDocument;
};





#endif
