/* Implementation of a very simple KabAPI application. Displays the
 * AddressBook widget it creates as its own main view. 
 * 
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998 1999
 * license:    GNU Public License, Version 2
 * mail to:    Mirko Sucker <mirko.sucker@unibw-hamburg.de>
 * requires:   recent C++-compiler, at least Qt 1.4, STL
 * $Revision: 1.3 $
 */

#include <addressbook.h>
#include <kdatanavigator.h>
#include <kapp.h>
#include <qstrlist.h>
#include <iostream.h>

int main(int argc, char** argv)
{
  KApplication app(argc, argv);
  KDataNavigator nav;
  /*
    AddressBook ab; // loads the users standard file by default
    AddressBook::Entry entry;
    KabKey key;
    // -----
    cout << "Size of AddressBook::Entry is " << sizeof(AddressBook::Entry)
    << endl;
    ab.resize(320, 200);
    if(ab.getKey(0, key)!=AddressBook::NoError)
    {
    cout << "No entries!" << endl;
    } else {
    if(ab.getEntry(key, entry)==AddressBook::NoError)
    {
    ab.displayEntry(entry, 0); // display first entry
    } else {
    return -1; // this is an error, as there has to be a first entry
    }
    }
    app.setMainWidget(&ab);
    ab.show();
    switch(ab.configureFile())
    {
    case AddressBook::Rejected:
    cout << "Configuration rejected." << endl;
    break;
    case AddressBook::PermDenied:
    cout << "Cannot save local configuration (permission denied)!" << endl;
    break;
    case AddressBook::NoError:
    cout << "Saved local configuration." << endl;
    break;
    default:
    cout << "Cannot save local configuration (unknown error)!" << endl;
    }
  */
  app.setMainWidget(&nav);
  // nav.setText("Hallo Mirko");
  // nav.setIndexMode(0, 4, 0);
  // nav.setIndexMode(0, 0, 0);
  QStrList l;
  l.append("eins"); l.append("zwei"); l.append("drei");
  l.append("vier"); l.append("fnf"); l.append("siebenhundert");
  nav.setMode(KDataNavigator::List);
  nav.setList(&l);
  nav.showButtonNew(false);
  nav.setFixedSize(nav.sizeHint());
  nav.show();
  return app.exec();
}

