/* -*- C++ -*-
 * This file declares the dialog that is used to set file specific
 * information.
 * 
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998, 1999
 * license:    GNU Public License, Version 2
 * mail to:    Mirko Sucker <mirko.sucker@unibw-hamburg.de>
 * requires:   recent C++-compiler, at least Qt 1.4, STL
 * $Revision: 1.3 $
 */
  
#ifndef CONFIGUREFILE_H
#define CONFIGUREFILE_H

#include "addressbook.h" // we use the ErrorCodes here
#include <ktabctl.h>

class QConfigDB;
class QLineEdit;
class QLabel;

/** This class is used in the dialog where the user may configure the file
 *  specific settings for the loaded kab address database.
 *  It is used as a \e "main widget"  for a DialogBase object. */

class KabFileConfigWidget : public KTabCtl
{
  // ############################################################################
  Q_OBJECT
  // ----------------------------------------------------------------------------
public:
  /** The Qt standard constructor. Gets the open file. */
  KabFileConfigWidget(QConfigDB* data, QWidget* parent, const char* name);
  ~KabFileConfigWidget(); /**< The destructor. */
  AddressBook::ErrorCode saveSettings(); /**< Save the settings to the file. */
  // ----------------------------------------------------------------------------
protected:
  QConfigDB *data; /**< The configuration database object. */
  QWidget *userFields; /**< Tab for configuring the user fields. */
  QLineEdit *userField1; /**< The name of the first user field. */
  QLabel *userLabel1; /**< The label for the first user field. */
  QLineEdit *userField2; /**< The name of the second user field. */
  QLabel *userLabel2; /**< The label for the second user field. */
  QLineEdit *userField3; /**< The name of the third user field. */
  QLabel *userLabel3; /**< The label for the third user field. */
  QLineEdit *userField4; /**< The name of the fourth user field. */
  QLabel *userLabel4; /**< The label for the fourth user field. */
  static const int Border; /**< The border width inside the dialog. */
  void setValues(); /**< Fill the dialog with the old values. */
public slots:
  void initializeGeometry(); /**< (Re)Calculate minimum size. */
  // ############################################################################
};



#endif // CONFIGUREFILE_H
