/* -*- C++ -*-
 * This file implements the dialog that is used to set file specific
 * information.
 * 
 * the KDE addressbook
 * copyright:  (C) Mirko Sucker, 1998 1999
 * license:    GNU Public License, Version 2
 * mail to:    Mirko Sucker <mirko.sucker@unibw-hamburg.de>
 * requires:   recent C++-compiler, at least Qt 1.4, STL
 * $Revision: 1.3 $
 */

#include "configurefile.h"
#include <ktabctl.h>
#include "qconfigDB.h"
#include <qlineedit.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qmessagebox.h>
#include "debug.h"
#include <kapp.h>

// #############################################################################
// MOC OUTPUT FILES:
#include "configurefile.moc"
// #############################################################################

const int KabFileConfigWidget::Border=2;

KabFileConfigWidget::KabFileConfigWidget(QConfigDB* db,
					 QWidget* parent,
					 const char* name)
  : KTabCtl(parent, name),
    data(db)
{
  // ###########################################################################
  const int Rows=4; // set to maximum number of rows in one tab
  QGridLayout *layout;
  // ----- create local objects:
  userFields=new QWidget(this);
  if(userFields!=0)
    {
      userField1=new QLineEdit(userFields);
      userLabel1=new QLabel(userFields);
      userField2=new QLineEdit(userFields);
      userLabel2=new QLabel(userFields);
      userField3=new QLineEdit(userFields);
      userLabel3=new QLabel(userFields);
      userField4=new QLineEdit(userFields);
      userLabel4=new QLabel(userFields);
    }
  if(userFields==0 || db==0 ||
     userField1==0 || userField2==0 || userField3==0 || userField4==0 ||
     userLabel1==0 || userLabel2==0 || userLabel3==0 || userLabel4==0)
    {
      QMessageBox::critical
	(this, i18n("kab: Out of memory"),
	 i18n("Cannot initialize local variables."));
      kapp->quit(); // It is critical, but will possibly never happen. 
    }
  // ----- set the labels:
  userLabel1->setText(i18n("User field 1:"));
  userLabel2->setText(i18n("User field 2:"));
  userLabel3->setText(i18n("User field 3:"));
  userLabel4->setText(i18n("User field 4:"));
  // ----- setup the user fields tab:
  layout=new QGridLayout(userFields, Rows, 2, Border);
  if(layout==0)
    {
      QMessageBox::critical
	(this, i18n("kab: Out of memory"),
	 i18n("Cannot initialize local variables."));
      kapp->quit(); // It is critical, but will possibly never happen. 
    }    
  layout->setColStretch(0, 1);
  layout->setColStretch(1, 2);
  layout->addWidget(userLabel1, 0, 0);
  layout->addWidget(userField1, 0, 1);
  layout->addWidget(userLabel2, 1, 0);
  layout->addWidget(userField2, 1, 1);
  layout->addWidget(userLabel3, 2, 0);
  layout->addWidget(userField3, 2, 1);
  layout->addWidget(userLabel4, 3, 0);
  layout->addWidget(userField4, 3, 1);
  layout->activate();
  addTab(userFields, i18n("User fields"));
  // ----- prepare geometry management:
  connect(kapp, SIGNAL(appearanceChanged()), SLOT(initializeGeometry()));
  initializeGeometry();
  // ----- set the old values:
  setValues();
  // ###########################################################################
}

KabFileConfigWidget::~KabFileConfigWidget()
{
  // ###########################################################################
  // ###########################################################################
}

void
KabFileConfigWidget::setValues()
{
  // ###########################################################################
  const char* UserFields[]= {
    "user_1", "user_2", "user_3", "user_4"
  };
  QLineEdit* UserLEs[]= {
    userField1, userField2, userField3, userField4
  };
  const int Size=sizeof(UserFields)/sizeof(UserFields[0]);
  Section *config;
  KeyValueMap *keys;
  QString temp;
  int count;
  // -----
  if(!data->get("config", config))
    {
      L("KabFileConfigWidget::setValues: no config section.\n");
      return;
    }
  keys=config->getKeys();
  // -----
  for(count=0; count<Size; ++count)
    {
      if(keys->get(UserFields[count], temp))
	{
	  UserLEs[count]->setText(temp);
	} else {
	  L("KabFileConfigWidget::setValues: no value for %s.\n",
	    UserFields[count]);
	}
    }
  // ###########################################################################
}

void
KabFileConfigWidget::initializeGeometry()
{
  // ###########################################################################
  int x, y;
  // ----- fix size of user fields tab:
  x=3*userLabel4->sizeHint().width()+3*Border;
  y=4*userLabel4->sizeHint().height()+5*Border;
  userFields->setMinimumSize(x, y);
  // ----- remove this when sizeHint of KTabCtl is available:
  setMinimumSize(x+16, y+64);
  // ###########################################################################
}

AddressBook::ErrorCode
KabFileConfigWidget::saveSettings()
{
  REQUIRE(data!=0);
  // ###########################################################################
  Section *config;
  KeyValueMap *keys;
  // ----- get the local configuration section:
  if(!data->get("config", config))
    { // ----- possibly there is no file loaded:
      L("KabFileConfigWidget::saveSettings: no configuration section.\n");
      return AddressBook::InternError;
    }
  // ----- get the keys:
  keys=config->getKeys();
  // ----- insert all values:
  if(!keys->insert("user_1", userField1->text(), true) ||
     !keys->insert("user_2", userField2->text(), true) ||
     !keys->insert("user_3", userField3->text(), true) ||
     !keys->insert("user_4", userField4->text(), true))
    {
      QMessageBox::information
	(this, i18n("kab: File error"),
	 i18n("Cannot save your settings."
	      "Possibly you do not have permissions to write to this file."));
      return AddressBook::PermDenied;
    } else {
      return AddressBook::NoError;
    }
  // ###########################################################################
}
