/***************************************************************************
                          FILENAME  -  description
                             -------------------
    begin                : DATE
    copyright            : (C) YEAR by AUTHOR
    email                : EMAIL
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "newserverdlg.h"
#include "dlgloader/kdlgldr.h"
#include <krestrictedline.h>
#include <ksimpleconfig.h>
#include <kmsgbox.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qdialog.h>
#include <qpushbt.h>

NewServerDlg::NewServerDlg():QObject(0)
{
    QDialog *d=new QDialog(0,0,true);
    QString path=(KApplication::kde_datadir()+"/newkrn/dialogs/serverprop.kdevdlg");
    KDlgLoader *l=new KDlgLoader(d);
    l->openDialog(path);

    profname=(QLineEdit *)(l->getItemPtrVarName("profname"));

    servname=(QLineEdit *)(l->getItemPtrVarName("servname"));

    portnumber=(KRestrictedLine *)(l->getItemPtrVarName("portnumber"));
    portnumber->setValidChars("0123456789");
    portnumber->setText("119");

    auth=(QCheckBox *)(l->getItemPtrVarName("auth"));
    auth->setChecked(false);
    QObject::connect(auth,SIGNAL(clicked()),this,SLOT(authChanged()));

    username=(QLineEdit *)(l->getItemPtrVarName("username"));
    username->setEnabled(false);

    password=(QLineEdit *)(l->getItemPtrVarName("password"));
    password->setEchoMode (QLineEdit::Password);
    password->setEnabled(false);

    QPushButton *ok=(QPushButton *)(l->getItemPtrVarName("ok"));
    ok->setDefault(true);
    QPushButton *cancel=(QPushButton *)(l->getItemPtrVarName("cancel"));
    QPushButton *test=(QPushButton *)(l->getItemPtrVarName("test"));
    QObject::connect(ok,SIGNAL(clicked()),d,SLOT(accept()));
    QObject::connect(cancel,SIGNAL(clicked()),d,SLOT(reject()));

    while (1)
    {
        int res=d->exec();
        if (!res)
            return;
        QString profilename=profname->text();
        QString path=(KApplication::localkdedir()+"/share/apps/newkrn/servers/")+profilename;
        if (profilename.isEmpty())
        {
            KMsgBox::message(0,"Error","You must enter a profile name",0,"OK");
            continue;
        }
        else if (QFile::exists(path))
        {
            int res=KMsgBox::yesNo(0,"Warning","You already have a profile by that name\nDo you want to overwrite it?",0,"Yes","No");
            if (res==2)
                continue;
        }
        QString servername=servname->text();
        if (servername.isEmpty())
        {
            KMsgBox::message(0,"Error","You must enter a server name",0,"OK");
            continue;
        }
        QString port=portnumber->text();
        if (port.isEmpty())
        {
            KMsgBox::message(0,"Error","You must enter a port number",0,"OK");
            continue;
        }
        KSimpleConfig conf(path);
        conf.setGroup("ServerOptions");
        conf.writeEntry("name",servername);
        conf.writeEntry("port",port);
        conf.writeEntry("auth",auth->isChecked());
        if (auth->isChecked())
        {
            conf.writeEntry("username",username->text());
            conf.writeEntry("password",password->text());
        }
        else
        {
            conf.deleteEntry("username",false);
            conf.deleteEntry("password",false);
        }
        conf.sync();
        break;
    }
    delete l;
    delete d;
}
NewServerDlg::~NewServerDlg(){
}

void NewServerDlg::authChanged()
{
    username->setEnabled(auth->isChecked());
    password->setEnabled(auth->isChecked());
}







