
#include <qlabel.h>
#include <qgrpbox.h>
#include <qbttngrp.h>
#include <kapp.h>
#include "optionsdlg.h"
#include "optionsdlg.moc"
#include "kpropdlg/kproptext.h"
#include "kpropdlg/kpropgroup.h"
#include "kpropdlg/kpropcombo.h"
#include "kpropdlg/kpropcolor.h"
#include "kpropdlg/kpropcheck.h"
#include "kpropdlg/kpropspin.h"
#include "kpropdlg/kpropfont.h"

#include "kpropmledit.h"

///////////////////////////////////////////////////////////////////////////////

OptionsDialog::OptionsDialog( const char *title, QWidget *parent, char *name )
        : KPropDlg( KPropDlg::TREE, KPropDlg::OK | KPropDlg::APPLY | KPropDlg::CANCEL , title, 0, name )
{
    setupTabs();

    resize( 475, 450 );
    setMinimumSize( 475, 450 );

    emit getConfig();
    showPage( 0 );
}

///////////////////////////////////////////////////////////////////////////////

OptionsDialog::~OptionsDialog()
{
}

///////////////////////////////////////////////////////////////////////////////

void OptionsDialog::setupTabs()
{
    KPropText *textbox;

    // Personal
    QFrame *personalFrame = addPage( -1, "User" );

    QVBoxLayout *layout = new QVBoxLayout( personalFrame, 10 );

    KPropGroup *group = new KPropGroup( personalFrame, "Personal info" );
    layout->addWidget( group );

    textbox = new KPropText( group, i18n( "First name:" ), 60, "UserFirstname", "Personal Settings" );
    connectConfig( textbox );
    group->addWidget( textbox );
    textbox = new KPropText( group, i18n( "Last name:" ), 60, "UserLastname", "Personal Settings" );
    connectConfig( textbox );
    group->addWidget( textbox );
    textbox = new KPropText( group, i18n( "Email address:" ), 60, "UserEmail", "Personal Settings" );
    connectConfig( textbox );
    group->addWidget( textbox );

    group = new KPropGroup( personalFrame, "Personal ICQ settings" );
    layout->addWidget( group );

    textbox = new KPropText( group, i18n( "UIN:" ), 60, "UserUIN", "Personal Settings" );
    connectConfig( textbox );
    group->addWidget( textbox );
    textbox = new KPropText( group, i18n( "ICQ Nick:" ), 60, "UserNick", "Personal Settings" );
    connectConfig( textbox );
    group->addWidget( textbox );
    textbox = new KPropText( group, i18n( "Password :)" ), 60, "UserPassword", "Personal Settings" );
    textbox->getLineEdit()->setEchoMode( QLineEdit::Password );
    connectConfig( textbox );
    group->addWidget( textbox );

    layout->addStretch();

    // Server frame
    QFrame *serverFrame = addPage( -1,  i18n("Server" ));

    layout = new QVBoxLayout( serverFrame, 10 );

    group = new KPropGroup( serverFrame,  "ICQ Server" );
    layout->addWidget( group );

    KPropCombo *combo = new KPropCombo( group,  i18n("Server address:"), 60, "ServerAddress", "Server" );
    QComboBox *cbox = combo->getCombo();
    cbox->setInsertionPolicy( QComboBox::NoInsertion );

    cbox->insertItem( "icq.mirabilis.com" );
    cbox->insertItem( "icq1.mirabilis.com" );
    cbox->insertItem( "icq2.mirabilis.com" );
    cbox->insertItem( "icq3.mirabilis.com" );
    cbox->insertItem( "icq4.mirabilis.com" );
    cbox->insertItem( "icq5.mirabilis.com" );
    cbox->setCurrentItem( 0 );

    connectConfig( combo );
    group->addWidget( combo );

    textbox = new KPropText( group, i18n( "Port:" ), 60, "ServerPort", "Server" );

    if ( !strcmp( textbox->text(), "" ) )
        textbox->setText( "4000" );
    connectConfig( textbox );
    group->addWidget( textbox );

    // Startup
    group = new KPropGroup( serverFrame,  "Startup Options" );
    layout->addWidget( group );

    combo = new KPropCombo( group,  i18n("Status:"), 60, "StartupStatus", "Startup" );
    cbox = combo->getCombo();
    cbox->setInsertionPolicy( QComboBox::NoInsertion );

    cbox->insertItem( "Available" );
    cbox->insertItem( "Away" );
    cbox->insertItem( "DND" );
    cbox->insertItem( "N/A" );
    cbox->insertItem( "Occupied" );
    cbox->insertItem( "Free for Chat" );
    cbox->insertItem( "Invisible" );
    cbox->setCurrentItem( 0 );

    connectConfig( combo );
    group->addWidget( combo );

    KPropCheck *check = new KPropCheck( group,  i18n("Auto connect"), "AutoConnect", "Startup" );
    connectConfig( check );
    group->addWidget( check );

    check = new KPropCheck( group,  i18n("Save Geometry on Exit"), "saveGeometry", "Startup" );
    connectConfig( check );
    group->addWidget( check );
    
    
    // and fill up
    layout->addStretch();

    // Message settings
    QFrame *msgFrame = addPage( -1,  i18n("Messages" ));

    layout = new QVBoxLayout( msgFrame, 10 );

    group = new KPropGroup( msgFrame,  "Message Options" );
    layout->addWidget( group );

    combo = new KPropCombo( group,  i18n("Browser:"), 60, "Browser", "Message Settings" );
    cbox = combo->getCombo();
    cbox->setInsertionPolicy( QComboBox::NoInsertion );

    cbox->insertItem( "kfmclient %u" );
    cbox->insertItem( "netscape %u" );
    cbox->setCurrentItem( 0 );

    connectConfig( combo );
    group->addWidget( combo );

    check = new KPropCheck( group,  i18n("Show new message first"), "ShowlastUnread", "Message Settings" );
    connectConfig( check );
    group->addWidget( check );

    layout->addStretch();

    group = new KPropGroup( msgFrame,  "Message Sound Options" );
    layout->addWidget( group );


    check = new KPropCheck( group,  i18n("Beep on received message"), "MessageBeep", "Message Settings" );
    connectConfig( check );
    group->addWidget( check );

    check = new KPropCheck( group,  i18n("Beep even when Away etc."), "MessageBeepWhenAway", "Message Settings" );
    connectConfig( check );
    group->addWidget( check );
    check = new KPropCheck( group,  i18n("Play WAV file on received message"), "PlayWavFile", "Message Settings" );
    connectConfig( check );
    group->addWidget( check );

    layout->addStretch();

    QFrame *appFrame = addPage( -1,  i18n("Appearance") );

    layout = new QVBoxLayout( appFrame, 10 );

    group = new KPropGroup( appFrame,  "Docking options" );
    layout->addWidget( group );

    check = new KPropCheck( group,  i18n("Show Docking"), "ShowDocking", "Docking Settings" );
    connectConfig( check );
    group->addWidget( check );
    check = new KPropCheck( group,  i18n("WindowMaker Dock.app"), "WindowMaker Dock", "Docking Settings" );
    connectConfig( check );
    group->addWidget( check );

    check = new KPropCheck( group,  i18n("Hide Window when connected/connecting"), "HideWindow", "Docking Settings" );
    connectConfig( check );
    group->addWidget( check );

    check = new KPropCheck( group,  i18n("Use KDE mouse behavoure style"), "KDEStyle", "Docking Settings" );
    connectConfig( check );
    group->addWidget( check );

    check = new KPropCheck( group,  i18n("Blink Icons on new Message"), "Blink Icon", "Docking Settings" );
    connectConfig( check );
    group->addWidget( check );

    
    group = new KPropGroup( appFrame,  "Web Presence" );
    layout->addWidget( group );

    check = new KPropCheck( group,  i18n("View current status on web"), "Web Presence", "Web Settings" );
    connectConfig( check );
    group->addWidget( check );

    
    group = new KPropGroup( appFrame,  "Send messages color" );
    layout->addWidget( group );
    KPropColor *color = new KPropColor( group, i18n( "Text" ), 50, "Send Message Text Color", "User View Settings" );
    connectConfig( color );
    group->addWidget( color );
    color = new KPropColor( group, i18n( "Background" ), 50, "Send Message Background Color", "User View Settings" );
    connectConfig( color );
    group->addWidget( color );

    
    
    layout->addStretch();

    QFrame *awayFrame = addPage( -1,  i18n("Change Status") );

    layout = new QVBoxLayout( awayFrame, 10 );

    group = new KPropGroup( awayFrame,  "Auto Away options" );
    layout->addWidget( group );

    check = new KPropCheck( group,  i18n("Turn Auto Away on"), "autoAway", "AutoAway Settings" );
    connectConfig( check );
    group->addWidget( check );
    

    KPropSpin *spin = new KPropSpin( awayFrame,  i18n("Set away after x minutes"), 30, "awayTime", "AutoAway Settings" );
    connectConfig( spin );
    group->addWidget( spin );

    spin = new KPropSpin( awayFrame,  i18n("Set N/A after x minutes"), 30, "naTime", "AutoAway Settings" );
    connectConfig( spin );
    group->addWidget( spin );

    check = new KPropCheck( group,  i18n("Auto Available after Away"), "autoUnAway", "AutoAway Settings" );
    connectConfig( check );
    group->addWidget( check );
    

    group = new KPropGroup( awayFrame, "Away options" );
    layout->addWidget( group );

    check = new KPropCheck( group,  i18n("Ask for Away Message"), "askAway", "AutoAway Settings" );
    connectConfig( check );
    group->addWidget( check );

    KPropGroup *gr2 = new KPropGroup( group,  "Away message" );
    group->addWidget( gr2 );

    KPropMLEdit *mle = new KPropMLEdit( gr2, "", 100, 5, "awayMsg", "AutoAway Settings" );
    connectConfig( mle );
    gr2->addWidget( mle );

    // and fill up
    layout->addStretch();


    QFrame *chatFrame = addPage( -1,  i18n("Chat") );

    layout = new QVBoxLayout( chatFrame, 10 );

    group = new KPropGroup( chatFrame,  "Chat options" );
    layout->addWidget( group );

    check = new KPropCheck( group,  i18n("Auto Raise Chat window"), "autoraise", "Chat Settings" );
    connectConfig( check );
    group->addWidget( check );

    layout->addStretch();


    QFrame *usersFrame = addPage( -1,  i18n("Users View" ));
    layout = new QVBoxLayout( usersFrame, 10 );

    group = new KPropGroup( usersFrame,  "Appearance" );
    layout->addWidget( group );

    check = new KPropCheck( group,  i18n("Show the Status icon on the right"), "Show Status Right", "User View Settings" );
    connectConfig( check );
    group->addWidget( check );
    check = new KPropCheck( group,  i18n("Show the UIN"), "Show UIN", "User View Settings" );
    connectConfig( check );
    group->addWidget( check );
    check = new KPropCheck( group,  i18n("Show the status also as Text"), "Show Status as Text", "User View Settings" );
    connectConfig( check );
    group->addWidget( check );
    check = new KPropCheck( group,  i18n("Use small view"), "Small View", "User View Settings" );
    connectConfig( check );
    group->addWidget( check );

    layout->addStretch();

    QFrame *fontFrame = addPage( -1, i18n( "Fonts" ) );
    layout = new QVBoxLayout( fontFrame, 10 );


    group = new KPropGroup( fontFrame,  "Users View"  );
    layout->addWidget( group );
    KPropFont *font = new KPropFont( group, i18n( "Nick" ), "Online nicks", 50, "Online Font", "User View Settings" );
    connectConfig( font );
    group->addWidget( font );

    font = new KPropFont( group, i18n( "Nick" ), "Offline nicks", 50, "Offline Font", "User View Settings" );
    connectConfig( font );
    group->addWidget( font );

    font = new KPropFont( group, i18n( "123456" ), "UIN/Status font", 50, "UIN Font", "User View Settings" );
    connectConfig( font );
    group->addWidget( font );

    layout->addStretch();

    QFrame *colorFrame = addPage( -1, i18n( "Colors" ) );
    layout = new QVBoxLayout( colorFrame, 10 );

    group = new KPropGroup( colorFrame,  "Online Users"  );
    layout->addWidget( group );

    color = new KPropColor( group, i18n( "Text" ), 50, "Online Text Color", "User View Settings" );
    connectConfig( color );
    group->addWidget( color );
    color = new KPropColor( group, i18n( "Background" ), 50, "Online Background Color", "User View Settings" );
    connectConfig( color );
    group->addWidget( color );

    color = new KPropColor( group, i18n( "Selected text" ), 50, "Online Select Text Color", "User View Settings" );
    connectConfig( color );
    group->addWidget( color );
    color = new KPropColor( group, i18n( "Selected background" ), 50, "Online Select Background Color", "User View Settings" );
    connectConfig( color );
    group->addWidget( color );


    group = new KPropGroup( colorFrame,  "Offline Users"  );
    layout->addWidget( group );


    color = new KPropColor( group, i18n( "Text" ), 50, "Offline Text Color", "User View Settings" );
    connectConfig( color );
    group->addWidget( color );
    color = new KPropColor( group, i18n( "Background" ), 50, "Offline Background Color", "User View Settings" );
    connectConfig( color );
    group->addWidget( color );

    color = new KPropColor( group, i18n( "Selected text" ), 50, "Offline Select Text Color", "User View Settings" );
    connectConfig( color );
    group->addWidget( color );
    color = new KPropColor( group, i18n( "Selected background" ), 50, "Offline Select Background Color", "User View Settings" );
    connectConfig( color );
    group->addWidget( color );


    layout->addStretch();
}

