/**************************************************************************
* libXicq - Originally written by tnc (xtrophy@it.dk)                     *
*'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''*
* misc.cc                                                                 *
* Misc functions - Logging etc                                            *
**************************************************************************/


#include "misc.h"
#include <netinet/in.h>


/*
**
** Make a log entry
*/
void misc_log( char *string )
{
    cout << "libXicq: " << string << endl;
}


/*
**
** Returns the command of a packet
*/
int misc_packet2cmd( ICQ_PACKET *packet )
{
    unsigned short int * cmd;

    cmd = ( unsigned short int * ) ( packet->data + 2 );

    return *cmd;
}


/*
**
** Returns the sequence of a packet
*/
int misc_packet2seq( ICQ_PACKET *packet )
{
    unsigned short int * sequence;

    sequence = ( unsigned short int * ) ( packet->data + 4 );

    return *sequence;
}


/*
**
** Dumps the packet to the screen
*/
void misc_printPacket( ICQ_PACKET *packet )
{
    if ( KXDEBUG )
    {
        printf( "[%04X]    [%04X]   [%04X]\n ", packet->command, packet->sequence, packet->length );

        for ( int i = 0; i < packet->length; i++ )
        {
            printf( "%02X ", packet->data[ i ] );

            if ( ( i + 1 ) % 8 == 0 && i != 0 )
                printf( "\n " );
        }

        printf( "\n" );
    }
}



