#ifndef KWVDIALCONFIG_H 
#define KWVDIALCONFIG_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qtabdialog.h>
#include <qmessagebox.h>

#include "wvmodemscan.h"
#include "configfile/wvconf.h"

class QComboBox;
class QPushButton;
class QCheckBox;
class QSlider;
class QLineEdit;

class KwvdialConfig : public QTabDialog
{
	Q_OBJECT
public:
	KwvdialConfig(QWidget *parent, const char *name,WvConf &_cfg);
	virtual ~KwvdialConfig();
	
private slots:
	void apply();
	void setup();
        void newprofclick();
        void delprofclick();
        void wvautoconf();
        void chgdsp(int id);

private:
    // Profile
    QComboBox 	*profile;
    QLineEdit	*newsection;
    QPushButton *newprofile;
    QPushButton *delprofile;
    
    // Dialing 
    QCheckBox	*callwtg;
    QCheckBox	*dialtone;
    QCheckBox	*dialasld;
    QCheckBox	*pulsetone;
    QLineEdit 	*areacode;
    QLineEdit 	*telephone;
    
    // User Information
    QLineEdit 	*username;
    QLineEdit 	*pwd;
    
    // Modem
    QCheckBox   *stupidmode;
    QCheckBox   *newpppd;
    QCheckBox	*autoredial;
    QSlider     *volume;
    QLineEdit   *baudrate;
    QPushButton *detect;
    
    WvConf	&cfg;
    void changedisplay(WvString sect);
};

#endif // KWVDIALCONFIG_H 
