/***************************************************************************
                          commands.cpp  -  	Commands used by the toolbars
																					  and menus
                             -------------------                                         
    begin                : Thu Jun 10 1999                                           
    copyright            : (C) 1999 by Eric Banker                         
    email                : ebanker@gmu.edu                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qfiledlg.h>
#include <qfile.h>
#include <kapp.h>
#include <ktoolbar.h>
#include <kmenubar.h>
#include <kiconloader.h>
#include <qmsgbox.h>
#include <qstring.h>
#include "edit.h"

void Edit::commandCallback(int id_)
{
  QString name;

  switch(id_) {

// These are for the file menu

// Create a new file with template but make sure we don't loose work!

	case ID_NEW:

	if (!modified)
		{
    	view->clear();

			/* Place the template */
			int line, column;

  		view->getCursorPosition(&line,&column);
  		view->insertAt("<!-- Created with KWebDev v0.3 By Eric Banker -->\n<HTML>\n<Head>\n	<Title>Insert Title Here</Title>\n</Head>\n<Body bgcolor=\"Black\" text=\"White\" link=\"Red\" vlink=\"Red\" alink=\"Blue\">\n\n<!-- Insert the Page Text Here -->\n\n</Body>\n</html>",line,column);

			/* Reset the File Name */
    	filename_= "";
			modified = FALSE;
			view->setCursorPosition(0, 0, false);
      statusbar->changeItem("Untitled.html", ID_HINTTEXT);
  	}
		else
		{
    	if (QMessageBox::warning(this, klocale->translate("Unsaved Changes"),
			      "You have unsaved changes, you will loose them "
			      "if you open a new file now.",
			      "OK", "Cancel", 0, 1, 1)){
				view->deselect();
			}
    	else{
        view->clear();

				/* Place the template */
				int line, column;

  			view->getCursorPosition(&line,&column);
  			view->insertAt("<!-- Created with KWebDev v0.3 By Eric Banker -->\n<HTML>\n<Head>\n	<Title>Insert Title Here</Title>\n</Head>\n<Body bgcolor=\"Black\" text=\"White\" link=\"Red\" vlink=\"Red\" alink=\"Blue\">\n\n<!-- Insert the Page Text Here -->\n\n</Body>\n</html>",line,column);

				/* Reset the File Name */
    		filename_= "";
				modified = FALSE;
				view->setCursorPosition(0, 0, false);
        statusbar->changeItem("Untitled.html", ID_HINTTEXT);
			}
		}
    break;

// Close the current file but make sure they don't loose work!

	case ID_CLOSEWINDOW:
   closefile();
	 break;

// open the file but check to make sure it's not overwriting previous work

	case ID_OPEN:
		if (!modified)
		{
    	name= QFileDialog::getOpenFileName();
    	if (!name.isEmpty())
      	load(name);
        statusbar->changeItem(name, ID_HINTTEXT);
  	}
		else
		{
    	if (QMessageBox::warning(this, klocale->translate("Unsaved Changes"),
			      "You have unsaved changes, you will loose them "
			      "if you open a new file now.",
			      "GK", "Cancel", 0, 1, 1)){
					view->deselect();
			}
    	else{
    			name= QFileDialog::getOpenFileName();
    			if (!name.isEmpty())
      			load(name);
            statusbar->changeItem(name, ID_HINTTEXT);
			}
		}
    break;

//just save the file

	case ID_SAVE:
    if (!filename_.isEmpty())
      saveAs(filename_);
    else {
      name= QFileDialog::getSaveFileName();
      if (!name.isEmpty())
        saveAs(name);
				statusbar->changeItem(name, ID_HINTTEXT);
    }
    break;

// Invoke save as dialog and save file

	case ID_SAVEAS:
    name= QFileDialog::getSaveFileName();
    if (!name.isEmpty())
      saveAs(name);
			statusbar->changeItem(name, ID_HINTTEXT);
    break;

	case ID_PRINT:
		Print();
		break;

	case ID_NEW_WINDOW:
		Edit *toplevel;
		toplevel= new Edit();
		toplevel->show();
		break;

	// these are for the edit stuff

	case ID_CUT:
		cut();
		break;

	case ID_COPY:
		copy();
		break;
	
	case ID_PASTE:
		paste();
		break;

// These are for the HTML stuff
	
	case ID_HTMLBODY:
		InsertBody();
		break;

	case ID_HTMLBOLD:
		InsertBold();
		break;
		
	case ID_HTMLITALIC:
		InsertItalic();
		break;

	case ID_HTMLHR:
		InsertHRrule();
		break;

	case ID_HTMLCENTER:
		InsertCenter();
		break;

	case ID_HTMLRIGHT:
		InsertRight();
		break;

	case ID_HTMLIMAGE:
		InsertImage();
		break;

	case ID_HTMLLINK:
		InsertLink();
		break;

	case ID_HTMLULINE:
		InsertUline();
		break;

	case ID_HTMLPARA:
		InsertParagraph();
		break;
		
	case ID_HTMLBR:
		InsertBR();
		break;

	case ID_HTMLNBS:
		InsertNbs();
		break;

// This is for the font stuff

	case ID_FONTH1:
		InsertH1();
		break;

	case ID_FONTH2:
		InsertH2();
		break;

	case ID_FONTH3:
		InsertH3();
		break;

	case ID_FONTFP:
		Insertfontp();
		break;

	case ID_FONTFM:
		Insertfontm();
		break;

	case ID_FONTSUPER:
		InsertfontSuper();
		break;

	case ID_FONTSUB:
		InsertfontSub();
		break;

	case ID_FONTPRE:
		InsertfontPre();
		break;
	
	case ID_FONTSTRONG:
		InsertfontStrong();
		break;

// This is for Table Stuff

	case ID_TABLE:
		InsertTableHeader();
		InsertTableFooter();
		break;

	case ID_TABLE_TR:
		InsertTableTR();
		break;
	
	case ID_TABLE_TD:
		InsertTableTD();
		break;

// This is for Form Stuff

	case ID_FORM:
		InsertFormH();
		InsertFormF();
		break;

	case ID_FORM_TEXTBOX:
		InsertTextB();
		break;
	
	case ID_FORM_TEXTAREA:
		InsertTextF();
		break;

	case ID_FORM_LIST:
		InsertListB();
		break;
	
	case ID_FORM_CHECK:
		InsertCheck();
		break;

	case ID_FORM_RADIO:
		InsertRadio();
		break;
	
	case ID_FORM_RESET:
		InsertReset();
		break;

	case ID_FORM_SUBMIT:
		InsertSubmit();
		break;

// This is for Special Toolbar Stuff

	case ID_Special1:
    Special1();
		break;

	case ID_Special2:
    Special2();
		break;

	case ID_Special3:
    Special3();
		break;

	case ID_Special4:
    Special4();
		break;

	case ID_Special5:
    Special5();
		break;

	case ID_Special6:
    Special6();
		break;

	case ID_Special7:
    Special7();
		break;

	case ID_Special8:
    Special8();
		break;

	case ID_Special9:
    Special9();
		break;
	case ID_Special10:
    Special10();
		break;

	case ID_Special11:
    Special11();
		break;

	case ID_Special12:
    Special12();
		break;

// This is for List Stuff

	case ID_LIST_OL:
		InsertOL();
		break;

	case ID_LIST_UL:
		InsertUL();
		break;
	
	case ID_LIST_LI:
		InsertLI();
		break;

// These are the help stuff

	case ID_HELPCONTENTS:
    help();
    break;

	case ID_ABOUT:
    aboutkwebdev();
    break;

	case ID_ABOUTKDE:
		aboutkde();
    break;

// Well this exits the app

	case ID_EXIT:
    if (exit())
      ::exit(0);
    break;
  }
}




















