/***************************************************************************
                          optionsdia.cpp  -  description                              
                             -------------------                                         
    begin                : Sat Sep 18 1999                                           
    copyright            : (C) 1999 by Andrea Rizzi                         
    email                : rizzi@kde.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "optionsdia.h"
#include <qapp.h>
#include <qtooltip.h>
#include <ksimpleconfig.h>
OptionsDia::OptionsDia(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
  app=KApplication::getKApplication();
  config=app->getConfig();
  config->setGroup("Host List");
  for(int va=1;va<=config->readNumEntry("NumHost");va++)
      {
	      QString sstr;
        sstr.sprintf("Host%d",va);
	      QListBox_1->insertItem(config->readEntry(sstr));
      }
  config->setGroup("Options");
  QCheckBox_1->setChecked(config->readBoolEntry("AutoSave") );
//  QCheckBox_2->setChecked(config->readBoolEntry("UsePort") );
  QCheckBox_4->setChecked(config->readBoolEntry("UseHostSettings") );
  QCheckBox_3->setChecked(config->readBoolEntry("SaveHostSettings") );

  QLineEdit_2->setText(config->readEntry("SshCommand"));
  QLineEdit_3->setText(config->readEntry("Terminal"));
  connect(QPushButton_6,SIGNAL(clicked()),SLOT(quit()));
  connect(QPushButton_5,SIGNAL(clicked()),SLOT(save()));
  connect(QPushButton_1,SIGNAL(clicked()),SLOT(add()));
  connect(QLineEdit_1,SIGNAL(returnPressed()),SLOT(add()));
  connect(QPushButton_2,SIGNAL(clicked()),SLOT(remove()));
  connect(QPushButton_3,SIGNAL(clicked()),SLOT(moveUp()));
  connect(QPushButton_4,SIGNAL(clicked()),SLOT(moveDown()));
  QToolTip::add(QPushButton_1,i18n("Add the hostname into the list"));
  QToolTip::add(QPushButton_2,i18n("Remove the host name from the list"));
  QToolTip::add(QPushButton_3,i18n("Move up the host name "));
  QToolTip::add(QPushButton_4,i18n("Move down the host name "));
  QToolTip::add(QPushButton_5,i18n("Save options and exit"));
  QToolTip::add(QPushButton_6,i18n("Quit without saving"));
  QToolTip::add(QLineEdit_1,i18n("Host name you want to add to the list"));
  QToolTip::add(QLineEdit_2,i18n("Secure Shell command, without arguments"));
  QToolTip::add(QLineEdit_3,i18n("Terminal command, without arguments"));
  QToolTip::add(QCheckBox_1,i18n("Save hostname into the list on \"connect\""));
  QToolTip::add(QCheckBox_3,i18n("Save per host settings (port,username)"));
  QToolTip::add(QCheckBox_4,i18n("Load saved settings (port,username) of selected host"));
show();
}

OptionsDia::~OptionsDia()
{
}

void OptionsDia::save()
{
  config->setGroup("Host List");
  config->writeEntry("NumHost",QListBox_1->count());
  int va;
  for(va=0;va<QListBox_1->count();va++)
      {
	      QString sstr;
        sstr.sprintf("Host%d",va+1);
	      config->writeEntry(sstr,QListBox_1->text(va));
      }
  config->setGroup("Options");
  config->writeEntry("AutoSave",QCheckBox_1->isChecked() );
//  config->writeEntry("UsePort",QCheckBox_2->isChecked());
  config->writeEntry("SaveHostSettings",QCheckBox_3->isChecked() );
  config->writeEntry("UseHostSettings",QCheckBox_4->isChecked());

  config->writeEntry("SshCommand",QLineEdit_2->text());
  config->writeEntry("Terminal",QLineEdit_3->text());
  config->sync();
close();
}

void OptionsDia::add()
{
QListBox_1->insertItem(QLineEdit_1->text(),QListBox_1->currentItem()+1);
}

void OptionsDia::moveUp()
{
int c=QListBox_1->currentItem();
QString theHost(QListBox_1->text(c));
QListBox_1->removeItem(c);
QListBox_1->insertItem(theHost,c-1);
QListBox_1->setCurrentItem(c-1);
}

void OptionsDia::moveDown()
{
int c=QListBox_1->currentItem();
QString theHost(QListBox_1->text(c));
QListBox_1->removeItem(c);
if (c+1 <= QListBox_1->count())
  {
    QListBox_1->insertItem(theHost,c+1);
    QListBox_1->setCurrentItem(c+1);
  }
 else
  {
		QListBox_1->insertItem(theHost,0);
   	QListBox_1->setCurrentItem(0);
  }

}

void OptionsDia::remove()
{
QListBox_1->removeItem(QListBox_1->currentItem());
}
void OptionsDia::quit()
{
close();
}
























