#include "secondgrlist.h"

#include <qlistbox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <kapp.h>
#include <kseparator.h>

SecondGrList::SecondGrList () : QDialog (0,0,FALSE)
{
    setCaption (i18n("Search results"));

    QVBoxLayout *l=new QVBoxLayout (this);

    QLabel *lab=new QLabel(this);
    lab->setText (i18n("\nEnter group name (you can use wildcards)\n"));
    lab->setFixedSize(lab->sizeHint());
    l->addWidget(lab,0);

    key=new QLineEdit(this);
    key->setMinimumSize(key->sizeHint());

    l->addWidget(key,0);

    KSeparator *sep=new KSeparator(this);
    sep->setMinimumHeight(10);
    l->addWidget(sep,10);

    QHBoxLayout *l2=new QHBoxLayout();
    l->addLayout(l2,0);
    search= new QPushButton (i18n("&Search"),this);
    search->setFixedSize(search->sizeHint());
    l2->addStretch(10);
    l2->addWidget(search,0);

    l2->addStretch(100);
    close= new QPushButton (i18n("&Close"),this);
    close->setFixedSize(close->sizeHint());
    l2->addWidget(close,0);
    l2->addStretch(10);

    lab=new QLabel(this);
    lab->setText (i18n("\nSearch results (subscribed first)\n"));
    lab->setFixedSize(lab->sizeHint());
    l->addWidget(lab,0);


    list=new QListBox(this);
    list->setMaximumHeight(0);
    l->addSpacing(5);
    l->addWidget(list,100);

    l->activate();
    connect (search,SIGNAL(clicked()),this,SLOT(gotKey()));
    connect (close,SIGNAL(clicked()),this,SLOT(reject()));
    connect (key,SIGNAL(returnPressed()),search,SIGNAL(clicked()));

    key->setFocus();
    resize (0,0);

}
void SecondGrList::gotResults(QStrList &matches)
{
    list->clear();
    list->insertStrList(&matches);
    list->setMinimumHeight(6*(list->fontMetrics().height()+1));
}

void SecondGrList::gotKey()
{
    emit doSearch((char *)(key->text()));
}

