#include "article.h"

////////////////////////////////////////////////////////////////////
// Article class. Represents an article
// Real docs soon.
////////////////////////////////////////////////////////////////////

#ifndef KRNCONVERT
#include <kfm.h>
#include <NNTP.h>
#include "articleitem.h"
#include "kmmessage.h"
#include "artcontainers.h"
extern QList <Rule> ruleList;
#endif

#include "gigabase/gigabase.h"

extern dbDatabase db;


long artcounter=0;

REGISTER(Article);
REGISTER(group);

#ifndef KRNCONVERT
extern dbCursor <Article> cursor;
void QStringSplit (const QString &data,char sep,QStrList &splitted);
QString noRe(QString subject);

int Article::score()
{
    int sc=0;
    for (Rule *rule=ruleList.first();rule!=0;rule=ruleList.next())
    {
        if (rule->match(*this))
        {
            sc+=rule->value;
        }
    }
    return sc;
}

KMMessage *Article::createMessage ()
{
    KMMessage *m=new KMMessage();
    return m;
}

void Article::lookupAltavista()
{
    QString IDs(ID);
    QString buffer(2048);
    QString urldata("http://ww2.altavista.digital.com/cgi-bin/news.cgi?id@");
    urldata+=IDs.mid(1,IDs.length()-2);
    KFM fm;
    fm.openURL(urldata);
    return;
}

QListViewItem *Article::item(QListView *list)
{
    assert (list);
    return new ArticleItem(list,this);
}

QListViewItem *Article::item(QListViewItem *parent)
{
    assert (parent);
    return new ArticleItem(parent,this);
}

bool Article::cached()
{
    return (NNTP::isCached(ID)==PART_ALL);
}

#endif



Article::Article (const char *_ID)
{
    int l=strlen(_ID)+1;
    ID=new char[l];
    strncpy(ID,_ID,l);
    From=new char[1];
    Subject=new char[1];
    Ref=new char[1];
    Lines=0;
    isread=false;
    expire=true;  // robert's cache stuff
    ismarked=false;
    isavail=true;
    desperate=new char[1];
    load();
    artcounter++;
}

Article::Article (Article *art)
{
    ID=new char[strlen(art->ID)+1];
    strcpy (ID,art->ID);
    From=new char[strlen(art->From)+1];
    strcpy(From,art->From);
    Subject=new char[strlen(art->Subject)+1];
    strcpy(Subject,art->Subject);
    Ref=new char[strlen(art->Ref)+1];
    strcpy(Ref,art->Ref);
    desperate=new char[strlen(art->desperate)+1];
    strcpy(desperate,art->desperate);
    Lines=art->Lines;
    isread=art->isread;
    expire=art->expire;
    ismarked=art->ismarked;
    isavail=art->isavail;
    Date=art->Date;
    int l=art->lists.length();
    for (int i=0;i<l;i++)
    {
        lists.append(art->lists[i]);
    }
    artcounter++;
}


Article::Article(void)
{
    artcounter++;
    ID=new char[1];
    From=new char[1];
    Subject=new char[1];
    Ref=new char[1];
    desperate=new char[1];
    Lines=0;
    isread=false;
    expire=true;  // robert's cache stuff
    ismarked=false;
    isavail=true;
}

extern bool strictdelete;

Article::~Article()
{
#warning ugly, but for some reason it crashes in solaris if I dont do it!
    if (strictdelete)
    {
        delete [] desperate;
        delete [] Subject;
        delete [] From;
        delete [] ID;
        delete [] Ref;
    }
    lists.clear();
    artcounter--;
    //    debug ("artcount-->%d",artcounter);
}


void Article::save(bool commit)
//stores the article info and data into the cache
{
    dbQuery q;
    q="ID=",ID;
    //    dbCursor <Article> *cursor=new dbCursor <Article> (dbCursorForUpdate);
    dbCursor <Article> *cursor=&::cursor;
    if (cursor->select(q)>0)
    {
        (*cursor)->isread=isread;
        (*cursor)->Subject=Subject;
        (*cursor)->ID=ID;
        (*cursor)->Lines=Lines;
        (*cursor)->From=From;
        (*cursor)->Date=Date;
        (*cursor)->desperate=desperate;
        (*cursor)->expire=expire;
        (*cursor)->ismarked=ismarked;
        (*cursor)->lists.clear();
        int l=lists.length();
        for (int i=0;i<l;i++)
        {
            (*cursor)->lists.append(lists[i]);
        }
        cursor->update();
    }
    else
    {
        dbReference<Article> ref;
        dbDescriptor.getDatabase()->insert (&dbDescriptor,&ref,(void *)this);
    }
    if (commit)
        db.commit();
    /*    strictdelete=false;
     delete cursor;
     strictdelete=true;*/
}
bool Article::load()
//gets the article info and data from the cache
{
    dbQuery q;
    q="ID=",ID;
    if (cursor.select(q)>0)
    {
        delete [] desperate;
        delete [] Subject;
        delete [] From;
        delete [] ID;
        delete [] Ref;
        int l;

        l=strlen(cursor->ID)+1;
        ID=new char[l];
        strncpy(ID,cursor->ID,l);

        l=strlen(cursor->desperate)+1;
        desperate=new char[l];
        strncpy(desperate,cursor->desperate,l);

        l=strlen(cursor->Ref)+1;
        Ref=new char[l];
        strncpy(Ref,cursor->Ref,l);

        l=strlen(cursor->From)+1;
        From=new char[l];
        strncpy(From,cursor->From,l);

        l=strlen(cursor->Subject)+1;
        Subject=new char[l];
        strncpy(Subject,cursor->Subject,l);

        Lines=cursor->Lines;
        Date=cursor->Date;
        if (Date.stamp==-1)
            fprintf (stderr,"Invalid date on load()!\n");

        expire=cursor->expire;
        ismarked=cursor->ismarked;
        isread=cursor->isread;
        l=cursor->lists.length();
        for (int i=0;i<l;i++)
        {
            lists.append(cursor->lists[i]);
        }
    }
    else
    {
        //This doesn't really return at all if it fails
        throw (1);
        return false;
    }
    return true;
}


void Article::setRead(bool b,bool commit)
{
    if (isread !=b)
    {
        isread = b;
        save(commit);
    }
}

void Article::setAvailable(bool b)
{
    if (isavail != b)
    {
        isavail = b;
        save();
    }
}

bool Article::canExpire()  // robert's cache stuff
{
    return(expire);
}

void Article::setExpire(bool b,bool commit)   // robert's cache stuff
{
    if (expire !=b )
    {
        expire = b;
        save(commit);
    }
}


void Article::toggleExpire(bool commit)   // robert's cache stuff
{
    if(expire)
        expire = false;
    else
        expire = true;
    save(commit);
}

void Article::setMarked(bool b,bool commit)
{
    if (ismarked !=b)
    {
        ismarked = b;
        save(commit);
    }
}

#ifndef KRNCONVERT

////////////////////////////////////////////////////////////////////
// ArtList class. Represents a list of articles
// Real docs soon.
////////////////////////////////////////////////////////////////////


ArtTreeNodeList *ArticleList::threaded()
{
    QDict <ArtTreeNode> artdict;
    artdict.setAutoDelete(false);
    ArtTreeNodeList *atnl=new ArtTreeNodeList;
    QListIterator <Article> it(*this);
    int tot=count();
    int count=0;
    for (;it.current();++it)
    {
        QString curSubj=it.current()->Subject;
        count++;
        if (!(count % 20))
        {
            debug ("Threaded %d/%d",count,tot);
        }
        //See if there is a place reserved for this article
        ArtTreeNode *n=artdict.find(it.current()->ID);
        if (n)
        {
            n->art=it.current();
            n->subject=it.current()->Subject;
            continue;
        }
        else //have to add a subthread
        {
            //First get a list of references, oldest first
            QStrList refs;
            QStringSplit(it.current()->Ref,' ',refs);
            //Create a node for the article
            ArtTreeNode *atn=new ArtTreeNode();
            atn->art=it.current();
            atn->subject=it.current()->Subject;
            atn->ID=it.current()->ID;
            //Take note of the node
            artdict.insert(it.current()->ID,atn);

            //For each reference, starting with the new ones, try to
            //attach to the reference tree
            QStrListIterator refit (refs);
            for (refit.toLast();refit.current();--refit)
            {
                //Empty references cause loops. There's probably some looping
                //remaining, though, in cases of malicious headers.
                if (!strlen(refit.current()))
                {
                    continue;
                }
                ArtTreeNode *n=artdict.find(refit.current());
                if (n) //Found the tree
                {
                    //Mark the subthread as child of that node
                    //and that's it
                    n->children.append(atn);
                    atn->parent=n;

                    //Now, keep backtracking... as long as it doesn't
                    //introduce incoherent threading information.
                    //Basically create a thread, *forward* from my
                    //oldest reference, until meeting the tree again
                    //This may create a slightly not correct tree, but
                    //always a tree :-)
                    atn=0;
                    for (refit.toFirst();refit.current();++refit)
                    {
                        ArtTreeNode *n2=artdict.find(refit.current());
                        if (n2) //it's there, mark it as child of this
                            //subthread, and leave
                        {
                            if (n2->parent) //uh? It already has a parent
                            {
                                while (atn) //delete this thread because it's incoherent
                                {
                                    ArtTreeNode *tmp=atn->parent;
                                    //This is because it may have been inserted
                                    //multiple times (which I should fix!
                                    while (artdict.find(atn->ID.data()))
                                        artdict.remove(atn->ID.data());
                                    delete atn;
                                    atn=tmp;
                                }

                            }
                            else //it doesn't have a parent
                            {
                                if (atn) //If I have a subthread created
                                {
                                    n2->parent=atn;
                                    atn->children.append(n2);
                                }
                            }
                            //and leave
                            break;
                        }
                        else //This node doesn't exist yet. Create it.
                        {
                            ArtTreeNode *atnolder=atn;
                            atn=new ArtTreeNode;
                            atn->art=0;
                            atn->parent=atnolder;
                            atn->ID=refit.current();
                            artdict.insert(refit.current(),atn);
                            atn->subject=curSubj;
                            if (atnolder) //I mean, if not 0
                            {
                                atn->subject=atnolder->subject;
                                atnolder->children.append(atn);
                            }
                        }
                    }
                    break;
                }
                else //have to keep backtracking
                {

                    ArtTreeNode *atnolder=new ArtTreeNode();
                    atnolder->children.append(atn);
                    atnolder->subject=atn->subject;
                    atnolder->ID=refit.current();
                    atn->parent=atnolder;
                    atn=atnolder;
                    //take note of the placeholding node
                    artdict.insert(refit.current(),atn);

                }
            }
        }
    }

    QDict <ArtTreeNode> subjDict;

    QDictIterator <ArtTreeNode> dit(artdict);
    // All placeholder items
    // should be made roots with no children (dead)
    // and promote their children
    // up one level
    for (dit.toFirst();dit.current();++dit)
    {
        if (0==(dit.current()->art)) //placeholder
        {
//            if (0!=(dit.current()->parent)) //not root
//            {
                if (dit.current()->parent)
                {
                    QListIterator <ArtTreeNode> lit(dit.current()->children);
                    for (lit.toFirst();lit.current();++lit)
                    {
                        dit.current()->parent->children.append(lit.current());
                        lit.current()->parent=dit.current()->parent;
                    }
                    dit.current()->parent->children.removeRef(dit.current());
                    dit.current()->parent=0;
                }
                else
                {
                    QListIterator <ArtTreeNode> lit(dit.current()->children);
                    for (lit.toFirst();lit.current();++lit)
                    {
                        lit.current()->parent=0;
                    }
                }
                dit.current()->children.clear();
//            }
        }
    }

    //Now join all roots by simplified subject.
    ArtTreeNode *subj=0;
    for (dit.toFirst();dit.current();++dit)
    {
        if (0==(dit.current()->parent)) //root
        {
            //Is this is just a dead one?
            if (dit.current()->art==0)
                if (dit.current()->children.count()==0)
                    continue;
            //If not a dead one
            QString nsubj=noRe(dit.current()->subject);
            if (nsubj.isEmpty()) //Yes, it happens :-P
            {
                nsubj=" ";
            }
            subj=subjDict.find(nsubj.data());
            if (!subj) //The first time it appears
            {
                subj=new ArtTreeNode;
                subj->subject=nsubj;
                subjDict.insert(nsubj.data(),subj);
                debug ("root for -->%s<--",nsubj.data());
            }
            subj->children.append(dit.current());
            dit.current()->parent=subj;
        }
    }

    //Turn the dict into a list
    dit=QDictIterator <ArtTreeNode> (subjDict);
    for (dit.toFirst();dit.current();++dit)
    {
        ArtTreeNode *a=dit.current();
        if (a->art == 0) //it is a placeholder
        {
            //just one child
            if (a->children.count()==1)
            {
                a=a->children.first();
            }
        }
        if (a)
            atnl->append(a);
    }

    return atnl;
}

ArticleList::ArticleList()
{
}

ArticleList::~ArticleList()
{
    clear();
}

#endif