/* ------------------------------------------------------------- 

    view.cpp (part of K News Grabber)

    (C) 1999 by Cengiz Tuztas

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Cengiz.Tuztas@uni-essen.de

    $Id: view.cpp,v 1.9 1999/05/19 20:45:04 ctuztas Exp $

   ------------------------------------------------------------- */


#include <view.h>
#include <kng.h>
#include <kngicvs.h>
#include <qscrollview.h>

QWidget *MView = 0;

View::View(QWidget *parent)
  :QWidget(parent)
{
  if ( MView )
    {
      debug ( "Main View exists !" );
      kapp->quit();
    }
  MView = this;

  config = kapp->getConfig();
  mainLayout = new QVBoxLayout( this );
  grplist = new KNGListBox( this, NULL, 3);
  sview = new QScrollView( this );
  sview->setResizePolicy( QScrollView::AutoOne );
  sview->setHScrollBarMode( QScrollView::AlwaysOn );
  sview->setVScrollBarMode( QScrollView::AlwaysOn );

  //  sview->setBackgroundColor( backgroundColor() );

  grplist->setColumn( 0, i18n( "NewsGroup" ),290 );
  grplist->setColumn( 1, i18n( "Articles" ),60 );
  grplist->setColumn( 2, i18n( "Status" ),60,KTabListBox::MixedColumn );
  grplist->readConfig();

  mainLayout->addWidget( grplist );
  mainLayout->addSpacing(20);
  mainLayout->addWidget( sview );
  mainLayout->activate();
  optdialog = new KNGOptionDialog( 0 );
  
  lwidth = lheight = 10;

}

View::~View()
{
  delete grplist;
  delete sview;
  delete mainLayout;
} 

void View::writeConfig()
{
  grplist->writeConfig();
}

void View::newgrp()
{
  KNGDialog x( this ,"K News Grabber", i18n( "Add a new Newsgroup" ) );

  if ( x.exec() )
    {
      QString str = x.getEntry();
      if ( str.isEmpty() )
	return;
      const char *tmp = Connect->initGroup( str );
      grplist->insertItem( tmp );
      //free ( tmp );
      delete tmp;
    }
}

void View::delgrp()
{
  int item = grplist->currentItem();
  if ( grplist->isMarked( item ) )
    grplist->removeItem( item );
  else
    QMessageBox::warning( this, "K News Grabber", i18n( "No item selected" ) );
}

void View::modgrp()
{
  int idx = grplist->currentItem();
  QString str;

  if ( grplist->isMarked( idx ) )
    {
      KNGDialog x( this, "K News Grabber", i18n( "Modify Newsgroup name" ) );
      str = grplist->text( idx, 0 );
      x.setEntry( str );
      if ( x.exec() )
	{
	  str = x.getEntry();
	  if ( str.isEmpty() )
	    return;
	  const char *tmp = Connect->initGroup( str );
	  grplist->removeItem( idx );
	  grplist->insertItem( tmp, idx );
	  //free ( tmp );
	  delete tmp;
	}
    } 
  else 
    {
      QMessageBox::warning( this, "K News Grabber", i18n( "No item selected" ) );
    }
}

void View::prcgrp()
{
  //  QMessageBox::information( this, "K News Grabber", "Not implemented" );
  QString str;
  int idx = grplist->currentItem();

  
  if ( grplist->isMarked( idx ) )
    {
      str = grplist->text( idx, 0 );
      Connect->procGroup( str, this );
    }
  else
    QMessageBox::warning( this, "K News Grabber", i18n( "No item selected" ) );
}

void View::prcall()
{
  QStrList strlist;
  for( uint i = 0; i < grplist->count(); i++)
    {
      strlist.append( grplist->text( i, 0 ) );
    }
  Connect->procGroups( strlist, this );
  // QMessageBox::information( this, "K News Grabber", "Not implemented" );
}

void View::schedule()
{
  QStrList *strlist = new QStrList();
  for( uint i = 0; i < grplist->count(); i++)
    strlist->append( grplist->text( i, 0 ) );
  optdialog->showTab(2, strlist);
//  delete strlist;
} 

void View::settings()
{
  optdialog->showTab(1);
}

void 
View::deletehash()
{
  Connect->deletehash();
}


void 
View::insertImg(DwString binChars, const char *filename )
{
  if ( config->readEntry( "tmbview", "false" ) == "false" )
    {
      debug( "NO THUMBNAILS" );
      return;
    }

  int cwidth = 640;
  //  sview->setBackgroundColor( backgroundColor() );
  QImage i;
  
  debug( "cwidth=%d, lwidth=%d, lheight=%d", cwidth, lwidth, lheight );

  KNGICVS *nimage = new KNGICVS( binChars, filename );
  
  if ( nimage )
    {
      sview->addChild( nimage, lwidth, lheight );
      sview->showChild( nimage );
      sview->ensureVisible( lwidth + 160, lheight + 102 );

      if ( ( cwidth - lwidth ) < 170 )
	{
	  lwidth = 10;
	  lheight += 112;
	}
      else
	lwidth += 170;
      sview->resizeContents( cwidth + 50,
			     lheight + 112 ); 
      sview->updateScrollBars();
    }
}
