// $Id: prefserver.cpp,v 1.4 1998/12/08 16:27:16 denis Exp $
// $Log: prefserver.cpp,v $
// Revision 1.4  1998/12/08 16:27:16  denis
// Cleaned up a little before releasing
//

#include "prefserver.h"

#include "prefserver.moc"

ServerWidget::ServerWidget(QWidget *parent) : QWidget(parent)
{
  mainlabel = new QLabel("Enter Server Settings:",this);
  serverbox = new QGroupBox("ICQ Server", this);
  hostline = new QLineEdit(this);
  hostlabel = new QLabel(hostline, "Server:", this);
  portline = new KIntegerLine(this);
  portlabel = new QLabel(portline, "Port:", this);
}

ServerWidget::~ServerWidget()
{
  if(portlabel)
    delete portlabel;
  if(portline)
    delete portline;
  if(hostlabel)
    delete hostlabel;
  if(hostline)
    delete hostline;
  if(mainlabel)
    delete mainlabel;
  if(serverbox)
    delete serverbox;
}

void ServerWidget::resizeEvent(QResizeEvent *re)
{
  QSize mainlblsize, portlblsize, hostlblsize, portlinesize, hostlinesize;
  QWidget::resizeEvent(re);
  mainlblsize = mainlabel->sizeHint();
  mainlabel->setGeometry(10,10,mainlblsize.width(),mainlblsize.height());
  serverbox->setGeometry(7,30,width()-13,height()-37);
  hostlblsize = hostlabel->sizeHint();
  portlblsize = portlabel->sizeHint();
  hostlinesize = hostline->sizeHint();
  portlinesize = portline->sizeHint();
  int w = QMAX(portlblsize.width(),hostlblsize.width());
  int h = QMAX(QMAX(portlblsize.height(), hostlblsize.height()),
          QMAX(portlinesize.height(), hostlinesize.height()));
  hostlabel->resize(w,h);
  portlabel->resize(w,h);
  hostline->resize(width()-w-40,h);
  portline->resize(width()-w-40,h);
  int mh = (serverbox->height()-20)/2;
  hostlabel->move(15,serverbox->y()+mh/2-h/2+15);
  hostline->move(w+23,serverbox->y()+mh/2-h/2+15);
  portlabel->move(15,serverbox->y()+mh+mh/2-h/2+15);
  portline->move(w+23,serverbox->y()+mh+mh/2-h/2+15);
}

void ServerWidget::setInfo(const char *host, int port)
{
  hostline->setText(host);
  portline->setValue(port);
}

const char *ServerWidget::host()
{
  return hostline->text();
}

unsigned short ServerWidget::port()
{
  return portline->value();
}
