// $Id: infoaddr.cpp,v 1.4 1998/12/08 16:17:26 denis Exp $
// $Log: infoaddr.cpp,v $
// Revision 1.4  1998/12/08 16:17:26  denis
// Cleaned up a little before releasing
//

#include <qwidget.h>
#include <icq.h>
#include "infoaddr.h"

#include "infoaddr.moc"

AddrWidget::AddrWidget(QWidget *parent) : QWidget(parent)
{
  cityline = new QLineEdit(this);
  cityline->setFocusPolicy(QWidget::NoFocus);
  stateline = new QLineEdit(this);
  stateline->setFocusPolicy(QWidget::NoFocus);
  zipline = new QLineEdit(this);
  zipline->setFocusPolicy(QWidget::NoFocus);
  countryline = new QLineEdit(this);
  countryline->setFocusPolicy(QWidget::NoFocus);
  timeline = new QLineEdit(this);
  timeline->setFocusPolicy(QWidget::NoFocus);
  citylabel = new QLabel(cityline, "City",this);
  statelabel = new QLabel(stateline, "State",this);
  ziplabel = new QLabel(zipline, "Zip",this);
  countrylabel = new QLabel(countryline, "Country",this);
  timelabel = new QLabel(timeline, "Local Time",this);
}

AddrWidget::~AddrWidget()
{
  if(citylabel)
    delete citylabel;
  if(statelabel)
    delete statelabel;
  if(ziplabel)
    delete ziplabel;
  if(countrylabel)
    delete countrylabel;
  if(timelabel)
    delete timelabel;
  if(cityline)
    delete cityline;
  if(stateline)
    delete stateline;
  if(zipline)
    delete zipline;
  if(countryline)
    delete countryline;
  if(timeline)
    delete timeline;
}

void AddrWidget::resizeEvent(QResizeEvent *re)
{
  QWidget::resizeEvent(re);
  int hlbl = QMAX(QMAX(QMAX(citylabel->sizeHint().height(),statelabel->sizeHint().height()),
                       QMAX(ziplabel->sizeHint().height(),countrylabel->sizeHint().height())),
                  timelabel->sizeHint().height());
  int hline = QMAX(QMAX(QMAX(cityline->sizeHint().height(),stateline->sizeHint().height()),
                        QMAX(zipline->sizeHint().height(),countryline->sizeHint().height())),
                   timeline->sizeHint().height());
  int w = (width()-20)/2;
  int h = height()/2;
  int w1 = (w-8)/3;
  citylabel->setGeometry(6,15,w,hlbl);
  cityline->setGeometry(6,15+hlbl,w,hline);
  statelabel->setGeometry(w+15,15,w1*2,hlbl);
  stateline->setGeometry(w+15,15+hlbl,w1*2,hline);
  ziplabel->setGeometry(w+w1*2+24,15,w1,hlbl);
  zipline->setGeometry(w+w1*2+24,15+hlbl,w1,hline);
  countrylabel->setGeometry(6,10+h,w,hlbl);
  countryline->setGeometry(6,10+h+hlbl,w,hline);
  timelabel->setGeometry(w+15,10+h,w,hlbl);
  timeline->setGeometry(w+15,10+h+hlbl,w,hline);
}

void AddrWidget::setInfo(const char *pcity, const char *pstate, const char *pzip, unsigned short pcountry, unsigned char pcountry_stat, const char *ptime)
{
  cityline->setText(strlen(pcity)==0?"Not Entered":pcity);
  stateline->setText(strlen(pstate)==0?"Not Entered":pstate);
  zipline->setText(pzip);
  if(pcountry_stat == 0xFE)
    countryline->setText(icq_GetCountryName(pcountry));
  else
    countryline->setText("Not Entered");
  timeline->setText(ptime);
}
