// $Id: blinklistbox.cpp,v 1.5 1998/12/08 16:08:45 denis Exp $
// $Log: blinklistbox.cpp,v $
// Revision 1.5  1998/12/08 16:08:45  denis
// setToolTip moved to MainWindow
// Cleaned up a little before releasing
//

#include "mainwindow.h"
#include "blinklistbox.h"
#include "blinklistbox.moc"

/*********************/
/* WBlinkListBoxItem */
/*********************/

WBlinkListBoxItem::WBlinkListBoxItem(const char *s) : QListBoxItem()
{
  activePixmapNo = 0;
  isBlinkingFlag = 0;
  setText(s);
}

WBlinkListBoxItem::WBlinkListBoxItem() : QListBoxItem()
{
  activePixmapNo = 0 ;
  isBlinkingFlag = 0 ;
}

void WBlinkListBoxItem::setPixmap(int n,const QPixmap &p)
{
  if(n == 0)
    pmap1 = p ;
  if(n == 1)
    pmap2 = p ;
}

void WBlinkListBoxItem::setPixmapXY(int x,int y)
{
  pmapX = x ;
  pmapY = y ;
}

void WBlinkListBoxItem::setPaintMode(blPaintMode m)
{
  paintMode = m ;
}

const QPixmap* WBlinkListBoxItem::activePixmap() const
{
  const QPixmap *pm;
  if(activePixmapNo == 0)
    pm = &pmap1;
  else
    pm = &pmap2;
  return pm;
}

void WBlinkListBoxItem::paint(QPainter *p)
{
  const QPixmap *pm = activePixmap();
  if(isBlinkingFlag || paintMode == FREEZE) p->drawPixmap(pmapX,pmapY,*pm);
  QFontMetrics fm = p->fontMetrics();
  int yPos;
  if(pixmapMaxHeight() < fm.height())
    yPos = fm.ascent() + fm.leading()/2;
  else
    yPos = pixmapMaxHeight()/2 - fm.height()/2 + fm.ascent();
  p->drawText(pixmapMaxWidth() + 6, yPos, text() );
}

int WBlinkListBoxItem::togglePixmap()
{
  if(isBlinkingFlag && activePixmapNo == 0)
    activePixmapNo = 1;
  else 
    activePixmapNo = 0;
  return activePixmapNo;
}

void WBlinkListBoxItem::resetPixmap()
{
  activePixmapNo = 0;
}

const QPixmap* WBlinkListBoxItem::pixmap()
{
  return activePixmap();
}

int WBlinkListBoxItem::pixmapMaxWidth() const
{
  return QMAX(pmap1.width(), pmap2.width());
}

int WBlinkListBoxItem::pixmapMaxHeight() const
{
  return QMAX(pmap1.height(), pmap2.height());
}

void WBlinkListBoxItem::setBlinking(int b)
{
  isBlinkingFlag = b;
}

int WBlinkListBoxItem::isBlinking()
{
  return isBlinkingFlag;
}

int WBlinkListBoxItem::height(const QListBox *lb ) const
{
  return QMAX(pixmapMaxHeight(), lb->fontMetrics().lineSpacing() + 1);
}

int WBlinkListBoxItem::width(const QListBox *lb ) const
{
  return pixmapMaxWidth() + lb->fontMetrics().width(text()) + 6;
}

/*****************/
/* WBlinkListBox */
/*****************/

WBlinkListBox::WBlinkListBox(QWidget *parent=0,const char *name=0, WFlags f=0) : QListBox(parent, name, f)
{
  timerId = -1;
}

void WBlinkListBox::timerEvent(QTimerEvent *te)
{
  int n = 0;
  if(te->timerId() == timerId)
  {
    for(unsigned int i = 0; i < count(); i ++)
    {
      WBlinkListBoxItem* bitem;
      bitem = (WBlinkListBoxItem *)item(i);
      if(bitem->isBlinking())
      {
        n = bitem->togglePixmap();
        int yPos;
        if(itemYPos(i,&yPos))
          update(bitem->pixmapX(),yPos + bitem->pixmapY(),
            bitem->pixmapMaxWidth() + 4,bitem->pixmapMaxHeight() + 4);
      }
    }
    ((MainWindow*)(kapp->topWidget()))->togglePixmap(n);
  }
}

void WBlinkListBox::setBlinkInterval(int interval)
{
  blinkInterval = interval;
}

void WBlinkListBox::setBlinking(int n,int b)
{
  WBlinkListBoxItem* bitem;
  bitem = (WBlinkListBoxItem*)item(n);
  if(bitem != 0L)
    bitem->setBlinking(b);

  /* If we are requested to stop blinking, reset to the first pixmap */
  if(!b)
    bitem->resetPixmap();
  int yPos;
  if(itemYPos(n,&yPos))
    update(3,yPos,bitem->pixmapMaxWidth() + 2,bitem->pixmapMaxHeight() + 1);

  if(blinkItemsCount() > 0)
    if(timerId == -1)
      timerId = startTimer(blinkInterval);
  if(blinkItemsCount() == 0) 
  {
    killTimer(timerId);
    timerId = -1;
  }
}

int WBlinkListBox::blinkItemsCount()
{
  unsigned int i, icount = 0;
  for(i=0; i<count(); i++)
    if(((WBlinkListBoxItem*)item(i))->isBlinking())
      icount++;
  return icount;
}
