/* $Id: docking.cpp,v 1.3 1999/02/19 15:41:32 koss Exp $
   $Log: docking.cpp,v $
   Revision 1.3  1999/02/19 15:41:32  koss
   Reenbled pasting with middle button in the dock widget ( now it also
   beeps for notification )

   Revision 1.2  1999/02/18 19:01:39  koss
   *** empty log message ***

   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.4  1999/02/07 17:13:59  matt
   modified docking policy

   Revision 1.3  1998/10/21 17:32:37  matt
   *** empty log message ***


   Revision 1.2  1998/03/22 07:14:36  matt
   *** empty log message ***

   Revision 1.1  1998/03/02 14:28:43  matt
   Added animation


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   */

#include "docking.h"

#include <kwm.h>
#include <kmsgbox.h>
#include <kstring.h>
#include <kapp.h>
#include <kdebug.h>

#include <qpainter.h>
#include <qmsgbox.h>

#include "kget.h"


DockWidget::DockWidget(const char *name) : QWidget(0, name, 0)
{

  docked = false;
  animating = false;

  QString path = KApplication::getKApplication()->kde_datadir() + "/kget/pics/kget-small.gif";

  movie = QMovie( path.data() );
  movie.setSpeed(50);
  movie.connectUpdate( this, SLOT( movieUpdated(const QRect&) ) );
  movie.connectStatus( this, SLOT( movieStatus( int ) ) );

  setBackgroundMode( NoBackground );

  // popup menu for right mouse button
  popup_m = new QPopupMenu();
  popup_m->insertItem(i18n("Undock"),
				 this, SLOT(toggle_docking()));
  popup_m->insertItem(i18n("Quit"),
				 this, SLOT(quit()));

  KDNDDropZone *myDropZone = new KDNDDropZone(this, DndURL);
  connect( myDropZone, SIGNAL( dropAction( KDNDDropZone *) ), 
	   this, SLOT( slotDropEvent( KDNDDropZone *) ) );

}


DockWidget::~DockWidget() {
}


void DockWidget::movieStatus( int status ) {
  // The movie has sent us a status message.
  
  if ( status == QMovie::SourceEmpty )
    kdebug( KDEBUG_ERROR, 5001, "Could not load movie");
}


void DockWidget::movieUpdated(const QRect& area)
{
  if ( isVisible() )
    repaint();
}


void DockWidget::setAnim( bool anim ) {
  if ( anim )
    movie.unpause();
  else {
    movie.pause();
    movie.restart();
  }
  animating = anim;
}


void DockWidget::slotDropEvent( KDNDDropZone *zone ){
  p_kmain->slotDropEvent ( zone );
}


void DockWidget::dock() {

  if (!docked) {

    // prepare panel to accept this widget
    KWM::setDockWindow (this->winId());

    // that's all the space there is
    this->setFixedSize(24, 24);

    // finally dock the widget
    this->show();

    docked = true;
  } 
}


void DockWidget::undock() {

  if (docked) {

    // the widget's window has to be destroyed in order 
    // to undock from the panel. Simply using hide() is
    // not enough (seems to be necessary though).

    this->hide();

    this->destroy(true, true);

    // recreate window for further dockings
    this->create(0, true, false);

    docked = false;
  }
}


void DockWidget::mousePressEvent(QMouseEvent *e) {

  // open/close kget window on left mouse button 
  if ( e->button() == LeftButton )
    toggle_window_state();
  else if ( e->button() == RightButton )  // open popup menu on right mouse button
    {
      popup_m->move(-1000,-1000);
      popup_m->show();
      popup_m->hide();
      QRect g = KWM::geometry( this->winId() );
      if ( g.x() > QApplication::desktop()->width()/2 &&
	   g.y()+popup_m->height() > QApplication::desktop()->height() )
	popup_m->popup(QPoint( g.x(), g.y() - popup_m->height()));
      else
	popup_m->popup(QPoint( g.x() + g.width(), g.y() + g.height()));

      popup_m->exec();
    }
  else if ( e->button() == MidButton ){
    // notify user that we are going to paste in the URL
    // it's needed when we are in expert mode
    KApplication::getKApplication()->beep();
    p_kmain->pasteTransfer();
  }
}


void DockWidget::toggle_window_state() {

  // restore/hide connect-window
  if(p_kmain != 0L)  {
    if (p_kmain->isVisible())
      p_kmain->hide();
    else 
      p_kmain->show();
  }
}


void DockWidget::toggle_docking() {
  p_kmain->toggleDocking();
}


void DockWidget::paintEvent (QPaintEvent *e) {
  QPixmap p1 = movie.framePixmap();
  bitBlt(this, 0, 0, &p1);
} 


void DockWidget::quit() {
  p_kmain->quit();
}
