/* $Id$
   $Log$

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/


#include <kapp.h>
#include <kurl.h>
#include <kio_manager.h>

#include <qlayout.h>

#include "dlgProxy.h"


extern QString getStringFromBool( bool x );
extern bool getBoolFromString( QString s );

DlgProxy::DlgProxy(QWidget *parent, const char *name, WFlags f)
  : QWidget(parent, name, f)
{

  QVBoxLayout *topLayout = new QVBoxLayout( this, 10, 5 );
  topLayout->addSpacing( 5 );

  gb_proxy = new QGroupBox(this, "gb_proxy");
  gb_proxy->setTitle(i18n("Proxy Options"));
  topLayout->addWidget( gb_proxy, 5 );

  QGridLayout *proxyLayout = new QGridLayout(gb_proxy, 7, 7, 5);

  proxyLayout->addRowSpacing(0,5);
  proxyLayout->addRowSpacing(5,5);
  proxyLayout->addRowSpacing(6,5);

  proxyLayout->addColSpacing(0,5);
  proxyLayout->addColSpacing(6,5);

  proxyLayout->setRowStretch(0,5);
  proxyLayout->setRowStretch(1,5);
  proxyLayout->setRowStretch(2,5);
  proxyLayout->setRowStretch(3,5);
  proxyLayout->setRowStretch(4,5);
  proxyLayout->setRowStretch(5,5);
  proxyLayout->setRowStretch(6,5);

  proxyLayout->setColStretch(0,2);
  proxyLayout->setColStretch(1,8);
  proxyLayout->setColStretch(2,10);
  proxyLayout->setColStretch(3,5);
  proxyLayout->setColStretch(4,5);
  proxyLayout->setColStretch(5,2);

  cb_useProxy = new QCheckBox( i18n("Use proxy"), gb_proxy );
  cb_useProxy->setMinimumSize( cb_useProxy->sizeHint() );
  proxyLayout->addMultiCellWidget( cb_useProxy, 1, 1, 1, 2 );

  // http proxy
  lb_http_url = new QLabel("HTTP Proxy :", gb_proxy);
  lb_http_url->setAlignment(AlignRight | AlignVCenter);
  proxyLayout->addWidget( lb_http_url, 2, 1 );

  le_http_url = new QLineEdit(gb_proxy);
  le_http_url->setFixedHeight( le_http_url->sizeHint().height() );
  proxyLayout->addWidget( le_http_url, 2, 2 );

  lb_http_port = new QLabel("Port :", gb_proxy);
  lb_http_port->setAlignment(AlignRight | AlignVCenter);
  proxyLayout->addWidget( lb_http_port, 2, 3 );

  le_http_port = new QLineEdit(gb_proxy);
  le_http_port->setFixedHeight( le_http_port->sizeHint().height() );
  proxyLayout->addWidget( le_http_port, 2, 4 );

  QPixmap pixmap;
  pixmap.load( kapp->kde_toolbardir() + "/down.xpm" ); 
  cp_down = new QPushButton( gb_proxy );
  cp_down->setPixmap( pixmap );
  cp_down->setMinimumSize( cp_down->sizeHint() );
  connect( cp_down, SIGNAL( clicked() ), SLOT( copyDown() ) );
  proxyLayout->addWidget( cp_down, 2, 5 );

  // ftp proxy
  lb_ftp_url = new QLabel("FTP Proxy :", gb_proxy);
  lb_ftp_url->setAlignment(AlignRight | AlignVCenter);
  proxyLayout->addWidget( lb_ftp_url, 3, 1 );

  le_ftp_url = new QLineEdit(gb_proxy);
  le_ftp_url->setFixedHeight( le_ftp_url->sizeHint().height() );
  proxyLayout->addWidget( le_ftp_url, 3, 2 );

  lb_ftp_port = new QLabel("Port :", gb_proxy);
  lb_ftp_port->setAlignment(AlignRight | AlignVCenter);
  proxyLayout->addWidget( lb_ftp_port, 3, 3 );

  le_ftp_port = new QLineEdit(gb_proxy);
  le_ftp_port->setFixedHeight( le_ftp_port->sizeHint().height() );
  proxyLayout->addWidget( le_ftp_port, 3, 4 );

  // no proxy for
  lb_no_prx = new QLabel(i18n("No proxy for :"), gb_proxy);
  lb_no_prx->setAlignment(AlignRight | AlignVCenter);
  proxyLayout->addWidget( lb_no_prx, 5, 1 );

  le_no_prx = new QLineEdit(gb_proxy);
  le_no_prx->setFixedHeight( le_no_prx->sizeHint().height() );
  proxyLayout->addMultiCellWidget( le_no_prx, 5, 5, 2, 3 );

  connect( cb_useProxy, SIGNAL(toggled(bool)),le_http_url, SLOT(setEnabled(bool)) );
  connect( cb_useProxy, SIGNAL(toggled(bool)),le_http_port, SLOT(setEnabled(bool)) );
  connect( cb_useProxy, SIGNAL(toggled(bool)),le_ftp_url, SLOT(setEnabled(bool)) );
  connect( cb_useProxy, SIGNAL(toggled(bool)),le_ftp_port, SLOT(setEnabled(bool)) );
  connect( cb_useProxy, SIGNAL(toggled(bool)),le_no_prx, SLOT(setEnabled(bool)) );

  proxyLayout->activate();
  //
  topLayout->addSpacing( 5 );
  topLayout->activate();

  // !!! these are not supported yet, so disable them
  le_ftp_url->setEnabled( false );
  le_ftp_port->setEnabled( false );
  cp_down->setEnabled( false );
}


DlgProxy::~DlgProxy()
{
}


void DlgProxy::copyDown()
{
  le_ftp_url->setText( le_http_url->text() );
  le_ftp_port->setText( le_http_port->text() );
}


void DlgProxy::setData()
{
  QString port;
  KURL url;

  bool useProxy = ProtocolManager::self()->getUseProxy();
  le_http_url->setEnabled( useProxy );
  le_http_port->setEnabled( useProxy );
  le_no_prx->setEnabled( useProxy );
  cb_useProxy->setChecked( useProxy );
//   le_ftp_url->setEnabled( useProxy );
//   le_ftp_port->setEnabled( useProxy );
//   cp_down->setEnabled( useProxy );
  
  QString tmp = ProtocolManager::self()->getHttpProxy();
  if ( ! tmp.isEmpty() ) {
    printf("HTTP Proxy found!\n");
    url = tmp.data();
    le_http_url->setText( url.host() );
    port.setNum ( url.port() );    
    le_http_port->setText( port.data() );
  }
  
  tmp = ProtocolManager::self()->getFtpProxy();
  if ( ! tmp.isEmpty() ) {
    printf("FTP Proxy found!\n");
    url = tmp.data();
    le_ftp_url->setText( url.host() );
    port.setNum ( url.port() );
    le_ftp_port->setText( port.data() );
  }
  
  le_no_prx->setText( ProtocolManager::self()->getNoProxyFor().data() );
}

void DlgProxy::getData()
{
  QString url;
  
  ProtocolManager::self()->setUseProxy( cb_useProxy->isChecked() );

  url = le_http_url->text();
  if( url.isEmpty() )
    ProtocolManager::self()->setHttpProxy( "" );
  else {
    QString httpstr("http://");
    httpstr += le_http_url->text();	// host
    httpstr += ":";
    httpstr += le_http_port->text();	// and port
    ProtocolManager::self()->setHttpProxy( httpstr.data() );
  }

  url = le_ftp_url->text();
  if( url.isEmpty() )
    ProtocolManager::self()->setFtpProxy( "" );
  else {
    QString ftpstr("ftp://");
    ftpstr += le_ftp_url->text();	// host
    ftpstr += ":";
    ftpstr += le_ftp_port->text();	// and port
    ProtocolManager::self()->setFtpProxy( ftpstr.data() );
  }

  ProtocolManager::self()->setNoProxyFor( le_no_prx->text() );

}

