##############################################################################
#                                                                            #
# kftpupdater - Mirror a local directory to an ftp server or vice versa      #
# Copyright (C) 2000 Martin P. Holland  <m.holland@noether.freeserve.co.uk>  #
#                                                                            #
# This program is free software; you can redistribute it and/or modify       #
# it under the terms of the GNU General Public License as published by       #
# the Free Software Foundation; either version 2 of the License, or          #
# (at your option) any later version.                                        #
#                                                                            #
# This program is distributed in the hope that it will be useful,            #
# but WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
# GNU General Public License for more details.                               #
#                                                                            #
# You should have received a copy of the GNU General Public License          #
# along with this program; if not, write to the Free Software                #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  #
#                                                                            #
##############################################################################

#blocksize for ftp putting and getting
BLK=8192

import cPickle, tempfile, os, sys
import dbutils
class AbstractTransfer:
    """
    This class is mostly abstract; it provides methods
    to allow file transfer between a source and a target
    directory. These can be remote or local. The methods
    need to be implemented in concrete subclasses.
    """
    def __init__(self,sourcedir,targetdir,ftp,dbfile):
        self.sdir=sourcedir
        self.tdir=targetdir
        self.ftp=ftp
        self.dbfile=dbfile

    def smdtm(self,f):
        pass
    def put(self,f):
        pass
    def sfilesdirs(self,d):
        pass
    def tfilesdirs(self,d):
        pass
    def tdelete(self,f):
        pass
    def tmkd(self,d):
        pass
    def temptydir(self,d):
        pass
    def path_tTos(self,f):

        if self.tdir[-1]=='/':
            x=f[len(self.tdir)-1:]
        else:
            x=f[len(self.tdir):]
        if self.sdir[-1]=='/' and len(x)>0 and x[0]=='/':
            return self.sdir+x[1:]
        else:
            return self.sdir+x
    def path_sTot(self,f):
        if self.sdir[-1]=='/':
            x=f[len(self.sdir)-1:]
        else:
            x=f[len(self.sdir):]
        if self.tdir[-1]=='/' and len(x)>0 and x[0]=='/':
            return self.tdir+x[1:]
        else:
            return self.tdir+x

    def sremove_top(self,f):
        if self.sdir[-1]=='/':
            x=f[len(self.sdir):]
        else:
            x=f[len(self.sdir)+1:]
        return x
        
    def tremove_top(self,f):
        if self.tdir[-1]=='/':
            x=f[len(self.tdir):]
        else:
            x=f[len(self.tdir)+1:]
        return x

    def init_sdb(self):
        "Create file stamps database with values the current file mod times."
        try:
            f=open(self.dbfile,'w')
        except IOError,detail:
            self.error=("Can't open database file "+self.dbfile+ " for writing.",detail)
            return 0
        self.db={}
        self._makedb()
        if not self._writedb(): return 0
        return 1

    def _writedb(self):
        d=dbutils.Dbutils(self.db,self.dbfile)
        if d.write(): return 1
        else:
            self.error=d.error
            return 0

    def _makedb(self,d=None):
        if d==None:
            d=self.sdir
        files,dirs=self.sfilesdirs(d)
        for f in files:
            self.db[os.path.join(d,f)]=self.smdtm(os.path.join(d,f))
        for e in dirs:
            self._makedb(os.path.join(d,e))

    def readdb(self):
        "Read time stamps database."
        try:
            f=open(self.dbfile,'r')
        except IOError,detail:
            self.error=("Can't open "+self.dbfile+" for reading.",detail)
            return 0
        else:
            try:
                self.db=cPickle.load(f)
            except Exception, detail:
                self.error=("Can't load time stamps database from "+self.dbfile,detail)
                return 0
            f.close()
            return 1

    def cleardb(self):
        "Create blank time stamps databse."
        self.db={}
        if not self._writedb():
            return 0
        return 1

    def clean_file_db(self,d,files):
        for f in files:
            fn=os.path.join(d,f)
            if fn in self.db.keys():
                del self.db[fn]

    def clean_dir_db(self,d,dirs):
        for f in dirs:
            fn=os.path.join(d,f)
            for x in self.db.keys():
                if x[len(fn):]==fn:
                    del self.db[x]

    def setProgress(self,init_p,do_p,finish_p):
        self.init_progress=init_p
        self.do_progress=do_p
        self.finish_progress=finish_p

    def init_progress(self,f):
        self._size=self.size(f)
#        self._cycles=size/BLK+1
        self._count=0
        self._lastmsg=''
#        print "0%",

    def do_progress(self,n):
        self._count=self._count+n
        self._msg=str(100*self._count/self._size)+"%"
        #don't print the same percentage twice; never print 100% until done
        if self._msg!=self._lastmsg and self._msg!="100%":
            print self._msg,
            sys.stdout.flush()
        self._lastmsg=self._msg

    def finish_progress(self):
        print "100%"
                    