#include <stdlib.h>
#include <iostream.h>
#include <qpushbt.h>
#include <qlabel.h>
#include <qframe.h>
#include <qlayout.h>
#include <qregexp.h> 
#include <qfileinf.h> 
#include "kprocess.h"
#include "kmsgbox.h"
#include "StringToken.h"
#include "ircDefine.h"
#include "ircClient.h"
#include "mediaDialog.h"
#include "mediaDialog.moc"
#include "ircApp.h"

#define  MEDIADELAY   200

MediaDialog::MediaDialog(IrcClient* client, bool Modal, QWidget *parent, const char *name ) : 
  QDialog( parent, name, Modal )
{
#ifdef EDEBUG
  cout << "MediaDialog Konstruktor"<<endl;
#endif
  this->client=client;
  queueList.setAutoDelete(true);

  playTimer = new QTimer(this);
  connect(playTimer, SIGNAL(timeout()),
	  this,  SLOT  (slotPlayTimer()));

  horLayout = new QHBoxLayout(this, 5);

  createFileBox();
  horLayout->addWidget(fileBox,10);

  verLayout = new QVBoxLayout(0);
  horLayout->addLayout(verLayout,1);
  createButton();

  horLayout->activate();

  readConfig();
  resize(width(), height());
  setCaption("Media Dialog");
  fileBox->refresh();

  resize(400, 300);
}

MediaDialog::~MediaDialog()
{
#ifdef EDEBUG
  cout << "Destruktor MediaDialog" << endl;
#endif
  slotStop();
}


void MediaDialog::createFileBox()
{
  QString entry = "MediaFilter";
  QString value = ircapp->readEntry(entry, "*.mid:*.wav:*.mp3:");
  fileBox = new FileBox(this, "fileBox", value);
}

void MediaDialog::createButton()
{
  QPushButton* btn;

  toLine = new IrcLine(this);
  verLayout->addWidget(toLine);
  toLine->setFixedSize(100, 25);

  btn = new QPushButton(" Play remote to ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotPlayRemote()));
  verLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  verLayout->addSpacing(10);
  
  titleLine = new IrcLine(this);
  verLayout->addWidget(titleLine);
  titleLine->setFixedSize(100, 25);

  playBtn = new QPushButton(" Play local ", this);
  connect(playBtn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotPlayLocal()));
  verLayout->addWidget(playBtn);
  playBtn->setFixedSize(100, 25);

  btn = new QPushButton(" Stop ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotStop()));
  verLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  verLayout->addSpacing(10);

  btn = new QPushButton(" Refresh ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotRefresh()));
  verLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  btn = new QPushButton(" Ok ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotOk()));
  verLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  verLayout->addSpacing(10);
  
  btn = new QPushButton(" Setup Player ", this);
  connect(btn,
	  SIGNAL(clicked()),
	  this,
	  SLOT  (slotSetup()));
  verLayout->addWidget(btn);
  btn->setFixedSize(100, 25);

  verLayout->addStretch(10);
}

void MediaDialog::readConfig()
{
  QString dir=ircapp->readEntry("CTCPSoundDir", ircapp->home);
  fileBox->setDir(dir);
}

void MediaDialog::slotPlay(const char* File)
{
  QString file = File;
#ifdef EDEBUG
  cout << "MediaDialog::slotPlay:" << file << endl;
#endif
  if (file.isNull() || file.isEmpty())
     return;

  if (!QFile::exists(File)){
      KMsgBox::message(0L, "Media-Player Dialog", "File "+file+" not found" , 
		       KMsgBox::INFORMATION, "OK");
      return;
  }

  QString  f = file.mid(file.length()-3, 3);
  QString  starter = client->mediaPlayer->find(f);
  if (starter.isEmpty()){
     KMsgBox::message(0L, "Media-Player Dialog", "Player for format "+QString(f)+" not found.\nPlease configure your Media-Player" , 
		      KMsgBox::INFORMATION, "OK");
     return;
  }

  QRegExp re("%");
  int idx = starter.find(re);
  if (idx>=0){
     starter.replace(re, file);
  }
  else
     starter += " "+file;

  slotStop();

  StringToken st(starter);
  QString p=st.nextToken();
  QString a=st.toEnd();
  proc << p << a;
  ircapp->connect(&proc, SIGNAL(processExited(KProcess*)),
		  this,  SLOT  (slotProcExit (KProcess*)));

  QFileInfo fi(file);
  QString nm=fi.fileName();
#ifdef EDEBUG
  cout << "Filename:"<<nm<<endl;
#endif
  titleLine->setText(nm);
  proc.start();
  playBtn->setEnabled(false);
}

void MediaDialog::slotPlayCTCP(const char* File)
{
  QString file=File;
  if (file.isNull()||file.isEmpty())
     return;
  if (proc.isRunning()){
#ifdef EDEBUG
    cout << "Proces is running"<<endl;
#endif
     QString entry, value;
     entry = "OnCTCPSoundOnPlay";
     value = ircapp->readEntry(entry, "Dontplay");
     if (value=="Dontplay")
        return;
     else if (value=="Wait"){
        queueList.append(file);
        return;
     }
  }
  slotStop();
  queueList.append(file);
  show(client->currentNick());
  if (!playTimer->isActive())
     playTimer->start(MEDIADELAY, TRUE);
}

void MediaDialog::slotPlayRemote()
{
  QString file = fileBox->selectedFile();
  QString to   = toLine->text();
  if (to.isNull()||to.isEmpty() || file.isNull() || file.isEmpty())
     return;
  QFileInfo fi(file);
  QString cmd = "/CTCP "+to+" SOUND "+fi.fileName();
  client->slotCommand(to, cmd);
}

void MediaDialog::slotPlayLocal()
{
  QString file = fileBox->selectedFile();
  slotStop();
  queueList.append(file);
  if (!playTimer->isActive())
     playTimer->start(MEDIADELAY, TRUE);
}

void MediaDialog::slotStop()
{
  if (proc.isRunning())
     proc.kill();
  proc.clearArguments();
  titleLine->setText("");
  playBtn->setEnabled(true);
}

void MediaDialog::slotRefresh()
{
  fileBox->refresh();
}

void MediaDialog::slotOk()
{
  hide();
}

void MediaDialog::slotSetup()
{
  client->optPrefDlg->show("MediaPlayer");
}


void MediaDialog::show(const char* to)
{
  if (isVisible()){
     QPoint p = pos();
     hide();
     move(p);
  }

  QString ts = to?to:"";
  toLine->setText(ts);
  QString c;
 
  if (client->mediaPlayer->count()>0){
     QDictIterator<char> it(*client->mediaPlayer);
     QStrList wl;
     wl.setAutoDelete(true);
     QString f;
     c=fileBox->getFilterBox()->currentText();
     while(f=it.currentKey()){
       wl.append("*."+f);
       ++it;
     }
     fileBox->setFilterList(wl);
     fileBox->getFilterBox()->setFilter(c);
  }

  QDialog::show();
}

void MediaDialog::slotPlayTimer()
{
  playTimer->stop();
  QString file=queueList.first();
  if (file){
     queueList.removeFirst();
     slotPlay(file);
  }
}

void MediaDialog::slotProcExit(KProcess*)
{
  titleLine->setText("");
  playBtn->setEnabled(true);
  if (queueList.count()>0 && !playTimer->isActive())
     playTimer->start(MEDIADELAY, TRUE);
}

