#ifndef __RINGLIST_H__
#define __RINGLIST_H__

#include <qlist.h>

template<class T>  class RingList
{
private:
  unsigned mLen;
  QList<T> mList;
public:
  RingList(unsigned len)
    {
      mLen = len;
      mList.setAutoDelete(TRUE);
    }
  ~RingList(){}
  void add(T* item)
  {
      if (!item)
	 return;
      if (mList.count() > mLen) 
	 mList.removeFirst();
      mList.append(item);
  }
  void addLast(T* item)
  {
      if (!item)
         return;
      mList.removeLast();
      mList.append(item);
  }
  T* back() { 
      T* t = mList.prev();
      return t?t:mList.last(); 
  }
  T* forward(){ 
      T* t = mList.next();
      return t?t:mList.first(); 
  }
  T* current(){ 
      return mList.current(); 
  }
  T* first(){ 
      return mList.first(); 
  }
  T* last(){ 
      return mList.last(); 
  }

};

#endif
