#include "ircSleeper.h"
#include "ircSleeper.moc"

IrcSleeper::IrcSleeper()
{
  timer = 0L;
}

IrcSleeper::~IrcSleeper()
{
  delete timer;
}

void IrcSleeper::start(ulong second)
{
  timer = new IrcCore(0L, 0L, second);
  connect(timer,
	  SIGNAL(signCusTimeout(IrcCore*)),
	  SLOT  (slotSleep     (IrcCore*)));

  timer->setCusInterval(second);
  timer->start();
  ircapp->enter_loop();
}

void IrcSleeper::slotSleep(IrcCore*)
{
  timer->stop();
  ircapp->exit_loop();
}

