#include <netinet/in.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netdb.h>
#include "InetAddress.h"


void InetAddress::Init()
{
  hostName   =NULL;
  hostAddress=NULL;
  address    =0;
}

InetAddress::InetAddress()
{
  Init();
}

InetAddress::InetAddress(const char* hostName)
{
  Init();
  if (!hostName)
     return;
  forHost(hostName);
}

InetAddress::InetAddress(ulong address)
{
  Init();
  forHost(address);
}

InetAddress::~InetAddress()
{
}

bool InetAddress::forHost(const char* hostName)
{
  struct in_addr inAddr;
  if (inet_aton(hostName, &inAddr)==0){
    // hostName not in dot format
    this->hostName=hostName;
    struct hostent*    hp;
    if (!(hp=gethostbyname(hostName))){
       return FALSE;
    }
    bcopy(hp->h_addr, (char *)&(address), hp->h_length);
    family = hp->h_addrtype;
    inAddr.s_addr = address;
    hostAddress = (const char*)inet_ntoa(inAddr);
  }
  else{
    family  = AF_INET;
    address = inAddr.s_addr;
    hostAddress = hostName;
  }
  return TRUE;
}

bool InetAddress::forHost(ulong address)
{
  struct in_addr inAddr;
  this->address = address;
  inAddr.s_addr = address;
  hostAddress   = (const char*)inet_ntoa(inAddr);
  family        = AF_INET;
  return TRUE;
}

QString InetAddress::getHostAddress()
{
  return hostAddress;
}

ulong InetAddress::getAddress()
{
  return address;
}

QString InetAddress::getHostName()
{
  if (hostName.isEmpty()){
     struct hostent*    hp;
     if (!(hp=gethostbyaddr((const char*)&(address), sizeof(address), AF_INET))){
        return NULL;
     }
     hostName = (const char*)hp->h_name;
  }
  return hostName;
}

int InetAddress::getFamily()
{
  return family;
}

QString InetAddress::toString()
{
  QString s, t;
  s.setNum(address);
  if (!hostName.isEmpty())
     t = hostName;
  else
     t = "";
  return (t+":"+hostAddress+":"+s);
}

