#ifndef __WHOISDIALOG_H__
#define __WHOISDIALOG_H__

#include <qdialog.h> 
#include <qframe.h>
#include <qlistbox.h>
#include <knewpanner.h>
#include <ktreelist.h>
#include <qdict.h>
#include <qlined.h>
#include "ircUser.h"
#include "ircHtml.h"

class IrcClient;

class WhoisDialog : public QDialog
{
  Q_OBJECT
protected:
  KNewPanner* mPanner;
  KTreeList*  mTreeList;
  QWidget*    mPageWidget;
  IrcHtml*    mHtml;
  QDict<IrcUser>*  mUserList;
  QLineEdit*       mEditIgnore;
  QLineEdit*       mEditFriend;
  QLineEdit*       mEditBan;
  IrcClient*       mClient;
protected:
  IrcUser* getIrcUser(int idx=-1);
  int      getIdx(const char*);
  virtual void resizeEvent(QResizeEvent*);
public slots:
  void slotSetPage(int idx);
  void slotAddIgnore();
  void slotAddBan();
  void slotAddFriend();
  void slotAddIson();
  void slotDelete();
  void slotClear();
  void slotOk();
public:
  WhoisDialog(IrcClient* Client, QWidget* parent=0L, const char* Name=0L);
  ~WhoisDialog();
  virtual void show();
  void readConfig();
  void addIrcUser(IrcUser* iu);
  void setServer (const char* nick, const char* server);
};

#endif 
