/************************************************************
        Copyright (c) 1997 Michael Glauche
        Copyright (c) 1998 Karl Backstrm

        This code is under GPL - see COPYING.
************************************************************/

#include "newPrimary.h"
#include "record.h"
#include "newPrimary.moc"
#include <qlabel.h>
#include <qlayout.h>

newPrimary::newPrimary ( QList< PrimaryDomain > *pl, QWidget* parent,
			const char* name) 
                        : QDialog ( parent, name, TRUE, 634880 )
{

  QBoxLayout *topLayout = new QVBoxLayout(this, 5);
  QGridLayout *gridLayout = new QGridLayout(8, 3);
  QBoxLayout *buttonLayout = new QHBoxLayout();

  topLayout->addLayout(gridLayout, 10);
  topLayout->addLayout(buttonLayout, 0);

  gridLayout->setColStretch(0, 10);

  buttonLayout->addStretch(10);

  QFont font( "helvetica", 10, 50, 0 );
  font.setStyleHint( (QFont::StyleHint)0 );
  font.setCharSet( (QFont::CharSet)0 );
  
  Label_1 = new QLabel(i18n("Domain :"), this);
  Label_1->setMinimumSize(Label_1->sizeHint());
  gridLayout->addWidget(Label_1, 0, 0);
  
  Label_2 = new QLabel(i18n("Responsible Person :"), this);
  Label_2->setMinimumSize(Label_2->sizeHint());
  gridLayout->addWidget(Label_2, 1, 0);
  
  Label_3 = new QLabel(i18n("Refresh :"), this);
  Label_3->setMinimumSize(Label_3->sizeHint());
  gridLayout->addWidget(Label_3, 2, 0);

  Label_4 = new QLabel(i18n("Retry :"), this);
  Label_4->setMinimumSize(Label_4->sizeHint());
  gridLayout->addWidget(Label_4, 3, 0);
  
  Label_5 = new QLabel(i18n("Expire :"), this);
  Label_5->setMinimumSize(Label_5->sizeHint());
  gridLayout->addWidget(Label_5, 4, 0);

  Label_6 = new QLabel(i18n("Time to live :"), this);
  Label_6->setMinimumSize(Label_6->sizeHint());
  gridLayout->addWidget(Label_6, 5, 0);

  Label_7 = new QLabel(i18n("Filename :"), this);
  Label_7->setMinimumSize(Label_7->sizeHint());
  gridLayout->addWidget(Label_7, 6, 0);
  
  Label_12 = new QLabel(i18n("Primary Name Server :"), this);
  Label_12->setMinimumSize(Label_12->sizeHint());
  gridLayout->addWidget(Label_12, 7, 0);

  Domain_Edit = new QLineEdit(this);
  Domain_Edit->setMinimumSize( 140, 20 );
  Domain_Edit->setFont( font );
  connect( Domain_Edit, SIGNAL(textChanged(const char*)), SLOT(domain_change(const char*)) );
  gridLayout->addWidget(Domain_Edit, 0, 1);
  
  RP_Edit = new QLineEdit(this);
  RP_Edit->setMinimumSize( 140, 20 );
  RP_Edit->setFont( font );
  gridLayout->addWidget(RP_Edit, 1, 1);
  
  Refresh_Edit = new QLineEdit(this);
  Refresh_Edit->setMinimumSize( 140, 20 );
  Refresh_Edit->setFont( font );
  Refresh_Edit->setText( "10800" );
  gridLayout->addWidget(Refresh_Edit, 2, 1);
  
  Retry_Edit = new QLineEdit(this);
  Retry_Edit->setMinimumSize( 140, 20 );
  Retry_Edit->setFont( font );
  Retry_Edit->setText( "3600" );
  gridLayout->addWidget(Retry_Edit, 3, 1);
  
  Expire_Edit = new QLineEdit(this);
  Expire_Edit->setMinimumSize( 140, 20 );
  Expire_Edit->setFont( font );
  Expire_Edit->setText( "604800" );
  gridLayout->addWidget(Expire_Edit, 4, 1);
  
  TTL_Edit = new QLineEdit(this);
  TTL_Edit->setMinimumSize( 140, 20 );
  TTL_Edit->setFont( font );
  TTL_Edit->setText( "86400" );
  gridLayout->addWidget(TTL_Edit, 5, 1);
  
  FN_Edit = new QLineEdit(this);
  FN_Edit->setMinimumSize( 140, 20 );
  FN_Edit->setFont( font );
  gridLayout->addWidget(FN_Edit, 6, 1);
	
  NS_Edit = new QLineEdit(this);
  NS_Edit->setMinimumSize( 140, 20 );
  NS_Edit->setFont( font );
  gridLayout->addWidget(NS_Edit, 7, 1);

  Label_8 = new QLabel(i18n("sec."), this);
  Label_8->setMinimumSize(Label_8->sizeHint());
  gridLayout->addWidget(Label_8, 2, 2);
  
  Label_9 = new QLabel(i18n("sec."), this);
  Label_9->setMinimumSize(Label_9->sizeHint());
  gridLayout->addWidget(Label_9, 3, 2);
  
  Label_10 = new QLabel(i18n("sec."), this);
  Label_10->setMinimumSize(Label_10->sizeHint());
  gridLayout->addWidget(Label_10, 4, 2);
  
  Label_11 = new QLabel(i18n("sec."), this);
  Label_11->setMinimumSize(Label_11->sizeHint());
  gridLayout->addWidget(Label_11, 5, 2);
	
  Ok_Button = new QPushButton(i18n("OK"), this);
  Ok_Button->setMinimumSize(Ok_Button->sizeHint());
  connect( Ok_Button, SIGNAL(clicked()), SLOT(OK_Click()) );
  buttonLayout->addWidget(Ok_Button);

  Cancel_Button = new QPushButton(i18n("Cancel"), this);
  Cancel_Button->setMinimumSize(Cancel_Button->sizeHint());
  connect( Cancel_Button, SIGNAL(clicked()), SLOT(Cancel_Click()) );
  buttonLayout->addWidget(Cancel_Button);

  setFixedSize(200,200);

  setCaption(i18n("New Primary Domain"));
  primaryL = pl;

  gridLayout->addColSpacing(0, 100);
  topLayout->activate();
}


newPrimary::~newPrimary()
{
}

void newPrimary::OK_Click()
{
   if ( (strlen(Domain_Edit->text()) > 0) &&
   	(strlen(FN_Edit->text()) > 0) &&
   	(strlen(RP_Edit->text()) > 0) ) {
		QString RP;
		int i;
		record * r;
		
		r = new record();
		r->type = TYPE_NS;
		r->owner = " ";
		r->st1 = NS_Edit->text();
										
		RP = RP_Edit->text();
		i = RP.find("@");
		if (i>0) {
			RP.replace(i,1,".");
		}
		PrimaryDomain *pd;
		pd = new PrimaryDomain(Domain_Edit->text(),FN_Edit->text());
		pd->rp = RP;
		pd->refresh = atoi(Refresh_Edit->text());
		pd->retry = atoi(Retry_Edit->text());
		pd->expire = atoi(Expire_Edit->text());
		pd->TTL = atoi(TTL_Edit->text());
	        pd->data = new (QList<record>);
		pd->data->setAutoDelete(TRUE);
		pd->data->append(r);
		primaryL->append(pd);	
		close();
	} else {
		debug("Not all Fields filled out !!!!");
	}
}

void newPrimary::Cancel_Click()
{
  //	debug("Cancel Clicked !");
	close();
}

void newPrimary::domain_change(const char * name)
{
	QString st;
	st.sprintf("db.%s",name);
 	FN_Edit->setText(st);
	st.sprintf("root.%s",name);
	RP_Edit->setText(st);
	st.sprintf("ns.%s.",name);
	NS_Edit->setText(st);
}


