/* $Id: kget-defaults.h,v 1.1.1.1 1999/02/10 18:16:34 koss Exp $
   $Log: kget-defaults.h,v $
   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.1  1999/02/07 17:10:42  matt
   defaults for all options


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _CAITOO_DEFAULTS_H_
#define _CAITOO_DEFAULTS_H_

// Connection settings
#define DEF_ReconnectOnError  true
#define DEF_ReconnectTime     1
#define DEF_ReconnectRetries  10
#define DEF_ReconnectOnBroken true

#define DEF_TimeoutData         5
#define DEF_TimeoutDataNoResume 15

#define DEF_ConnectionType    PERMANENT
#define DEF_LinkNumber        0
#define DEF_OfflineMode       false

// Automation settings
#define DEF_AutoSave            true
#define DEF_AutoSaveInterval    10
#define DEF_AutoDisconnect      false 
#define DEF_DisconnectCommand   "kppp -k"
#define DEF_TimedDisconnect     false 
#define DEF_AutoShutdown        false
#define DEF_AutoPaste           false

// Limits settings
#define DEF_MaxSimConnections   2
#define DEF_MinimumBandwidth    1000
#define DEF_MaximumBandwidth    10000

// Advanced settings
#define DEF_AddQueued           true
#define DEF_ShowDownloadWindows false
#define DEF_StartIconified      false
#define DEF_RemoveOnSuccess     true 
#define DEF_GetSizes            true
#define DEF_ExpertMode          false

// Directories settings
#define DEF_UseLastDir          false

// System settings
#define DEF_UseSound    false

#define DEF_SoundAdded           "/caitoo/sounds/added.wav"
#define DEF_SoundStarted         "/caitoo/sounds/started.wav"
#define DEF_SoundFinished        "/caitoo/sounds/finished.wav"
#define DEF_SoundFinishedAll     "/caitoo/sounds/finishedall.wav"

#define DEF_UseAnimation  true

#define DEF_WindowStyle   NORMAL
#define DEF_Style9x       false

#define DEF_Font          "helvetica"
#define DEF_FontSize      12

// Misc settings
#define DEF_Menubar     "top"
#define DEF_Toolbar     "top"
#define DEF_Statusbar   true


#endif
