/* 
    kwintv using Bt848 frame grabber driver

    Copyright (C) 1998 Moritz Wenk (wenk@mathematik.uni-kl.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef wintvmainincluded
#define wintvmainincluded

#include <wintv.h>

#include <qpixmap.h>
#include <qpushbt.h>

#include <ctab.h>
#include <cselector.h>
#include <coptions.h>
#include <cfreq.h>

#include <otab.h>
#include <omixdev.h>
#include <ogeneral.h>
#include <osnapshot.h>
#include <ofullscreen.h>

#include <docking.h>

#include <kapp.h>
#include <kbutton.h>
#include <ktoolbar.h>
#include <ktopwidget.h>
#include <kstatusbar.h>

#ifdef HAVE_KDE11
#include <kaccel.h>        // KDE 1.1
#include <kkeydialog.h>
#else
#include <kkeyconf.h>      // KDE 1.0
#endif

#include <wintvscreen.h>
#include <rcfile.h>
#include <channel.h>
#include <wintvscan.h>
#include <mixer.h>
#include <videoclip.h>

#ifdef HAVE_IRC
#include <kirc.h>
#else
#include <kircdata.h>
#endif

#include <parsecl.h>

#ifdef myDEBUG
#define mainDEBUG
#endif

#define FRAME_NONE 0
#define FRAME_LEFT 1
#define FRAME_RIGHT 2
#define FRAME_UP 3
#define FRAME_DOWN 4

#define UPPER_LEFT  1
#define LOWER_LEFT  2
#define UPPER_RIGHT 3
#define LOWER_RIGHT 4

class winTVMainWidget : public KTopLevelWidget
{
  Q_OBJECT

public:
  winTVMainWidget( parsecl * pcl = 0 ,rcfile *_rc=0, mixer * _mix=0,  
		   QWidget* parent = 0, const char* name = 0 );
  ~winTVMainWidget();

  winTVScreenWidget *winTVScreenPtr() { return winTVScreen; }
  QPopupMenu *getAudioMenu() { return smenu[0]; }
  QPopupMenu *getChannelMenu() { return chmenu[0]; }
    
  void emitSetupSignals();

public slots:
  // audio & volume
  void audioModeChangedSLOT(int mode);
  void volumeUpSLOT();
  void volumeDownSLOT();
  void volumeSLOT(int vl, int vr);
  void volMuteChangedExtSLOT(bool);

  // channel selection
  void channelUpSLOT();
  void channelDownSLOT();
  void channelChangedSLOT();

  // channel managing
  void addChannelSLOT();
  void editChannelSLOT();
  void deleteChannelSLOT();
  void copyChannelSLOT();
  void pasteChannelSLOT();

  // video clip
  void startVClipSLOT(struct MOVIE_PARAMS *);
  void endVClipSLOT();
  void frameVClipSLOT(int);
  void framelostVClipSLOT(int);
  void statVideoClipFrameSLOT(double);

protected slots:
  // buttonbar buttons and keys 
  void buttonsSLOT(int b);
  void keyPressedSLOT(int key);
  void userKeysConfigSLOT();
  void closeRequestSLOT();

  // irc slots
  //#ifdef HAVE_IRC
  void ircCodesConfigSLOT();
  void displaySpecialKeySLOT( KCodeEntry::codeType );
  //#endif

  // channel 
  void switchToChannelSLOT( int );

  // menu bar
  void setupSLOT();
  void naSLOT();
  void videoClipSLOT();
  void propertiesSLOT();
  void captureToggleSLOT();
  void screenShotSLOT();

  // audio: volume, mute, audio
  void audioAutoSLOT();
  void audioMonoSLOT();
  void audioStereoSLOT();
  void audioL1SLOT();
  void audioL2SLOT();
  void volMuteChangedSLOT();

  // adjustments: aspect ratio and full screen 
  void adjustAspectRatioSLOT();
  void fullScreenSLOT();
  void sizemenuSLOT(int id);
  void fullSizeSLOT(int w, int h);

  // channel file actions 
  void scanChannelsSLOT();
  void readyScanChannelsSLOT(int);
  void newChannelsSLOT();
  void saveChannelsSLOT();
  void saveChannelsAsSLOT();
  void loadChannelsSLOT();
  void importXAWTVChannelsSLOT();
  void importXTVSCREENChannelsSLOT();

  // ctab
  void defaultTabSLOT();
  void applyTabSLOT();
  void cancelTabSLOT();

  // mtab
  void defaultMtabSLOT();
  void applyMtabSLOT();
  void cancelMtabSLOT();

  // rc
  void saveRCSLOT();

  // menubar, toolbar, mousecursor, statusbar
  void toggleToolBarSLOT();
  void toggleMenuBarSLOT();
  void toggleStatusBarSLOT();
  void mousecursorToggleSLOT();

  void dockSLOT( bool );

  // info 
  void toggleChannelBoxSLOT();
  void toggleTVonlySLOT();
  void toggleMixerBoxSLOT();

  void vtxSLOT();

  void dataReceivedSLOT(int data);

  void showInfoSLOT();

  bool x11Event( XEvent * );

signals:
  void captureToggleSIGNAL(int);
  void audioModeChangedSIGNAL(int);
  void audioMuteToggledSIGNAL();
  void volumeChangedSIGNAL(int,int);
  void channelChangedSIGNAL();
  void volMuteChangedSIGNAL(bool);
  void newChannelListSIGNAL(QList<channel> *clist);
  void toggleChannelBoxSIGNAL( QPoint * );
  void toggleVClipSIGNAL();
  void toggleMixerBoxSIGNAL();
  void frameVClipSIGNAL(int);
  void framelostVClipSIGNAL(int);
  void statVideoClipFrameSIGNAL(double);
  void x11EventSIGNAL( XEvent * );
  
private slots:
  void closeEvent ( QCloseEvent *);
  void keyPressEvent ( QKeyEvent * );
  void resizeEvent( QResizeEvent * );
  void moveEvent( QMoveEvent * );
  void updateRects();

  void saveProperties (KConfig*);
  void readProperties (KConfig*);

private:
  void saveChannels(const char *FILE);
  void loadChannels(const char *FILE, bool import= false);

  void fillMenu(QPopupMenu *menu[], int reqestId[],
		const char * text, const QObject * receiver, const char * member, int accel=0 );
  void fillMenu(QPopupMenu *menu[], 
		const char * text, const QObject * receiver=0, const char * member=0, int accel=0 );
  void fillMenu(QPopupMenu *menu[], int reqestId[],
		const char * text, QPopupMenu *popup[] );
  void fillMenu(QPopupMenu *menu[], 
		const char * text, QPopupMenu *popup[] );
  void fillMenuSeparator( QPopupMenu *menu[] );
  void setItemChecked(QPopupMenu *menu[], int id[], bool set);
  void setItemEnabled(QPopupMenu *menu[], int id[], bool enable);

  bool isItemChecked(QPopupMenu *menu[], int id[]);

private:
  static QList<winTVMainWidget> windowList;

  winTVScreenWidget *winTVScreen;
  rcfile *rc;
  mixer *mix;

  // the toolbars
  KToolBar* toolbar;
  KMenuBar* menubar;
  KStatusBar* statusbar;
  QLCDNumber* lcd;
  QSlider* volslider;

  QPixmap  pm;
  QPixmap  ch_up_xpm, ch_down_xpm, uncapture_xpm, snap_xpm, aspect_xpm;
  QPixmap  fullsize_xpm, vol_up_xpm, mute_xpm, vol_down_xpm;
  QPixmap  capture_xpm, cs_xpm, exit_xpm;
       
  // keys & irc codes
#ifdef HAVE_KDE11
  KAccel *userKeys;        // PEG kkeyconf not supported  
#else
  KKeyConfig *userKeys;
#endif

#ifdef HAVE_IRC
  KIRCWidget *ircCodes;
#endif

  // dialogs
  ctab *tab;
  cselector *selector;
  coptions *options;
  cfreq *freq;

  // option dialogs
  otab *mtab;
  omixdev *mixdev;
  osnapshot *snapshot;
  ogeneral *general;
  ofullscreen *fullscreen;

  // cannel and country stuff
  QList<channel> channel_list;
  channel *lastCutCopy;
  bool copyChannel;

  winTVscan *scan;

  // POPUPMENU popup --> KPopupMenu  
  POPUPMENU *mainmenu;
  QPopupMenu *tvmenu[2],*smenu[2],*chmenu[2],*optmenu[2],*sizemenu[2];
  int smid[10][2];
  int omid[10][2];
  int tvmid[10][2];
  int sid[10][2];

  DockWidget * dock_widget;

  // adjustments: aspect ratio and full screen 
  QRect oldPos;
  bool isfullscreen,isfullsize;

  // stuff
  char filename[255];
  char *cnamep;
  int capture;

  bool keyup;
  int key1;
  int key2;

  bool fixed,externalMute;
  bool have_vm;
  bool wasEdit;
  bool res_was_switched;
  bool chfile_was_changed;
};

#endif wintvmainincluded










